/**
 * 徐立
 * 2019年9月11日
 * 通知提醒框二次封装
 */
import React from 'react'
import {  notification,Modal } from 'antd';

/**
 *
 * @param {string} type 'success 成功 info 注意 warning 警告 error 错误'
 * @param {string} title '提示标题'
 * @param {string} content '主要内容'
 * @param {string} placement '弹出位置 topLeft topRight bottomLeft bottomRight'
 * @param {pbject} style '使用style 自定义弹出框样式
 */
export const openToast = (type:string,title:string,content:string,placement?:string,style?:object):void => {
    notification[type]({
        message: title,
        description:content,
        placement,
        style
    });
};
/**
 * 点击提示,执行信息展示,只提供一个按钮用于关闭
 * @param {string} title 成功提示信息标题
 * @param {any} content 成功提示信息内容(可为html标签)
 * @param {Function} handleOk 点击确定回调
 */
export const success = (title:string,content:any,handleOk:()=>{}):void => {
    Modal.success({
        title: title,
        content: (
            <div>
                {content}
            </div>),
        onOk:handleOk,
    });
}
/**
 * 点击提示,执行信息展示,只提供一个按钮用于关闭
 * @param {string} title 错误提示信息标题
 * @param {any} content 错误提示信息内容(可为html标签)
 * @param {Function} handleOk 点击确定回调
 */
export const error = (title:string,content:any,handleOk:()=>{}):void => {
    Modal.error({
        title: title,
        content: (
            <div>
                {content}
            </div>),
        onOk:handleOk,
    });
}
/**
 * 点击提示,执行信息展示,只提供一个按钮用于关闭
 * @param {string} title 普通提示信息标题
 * @param {any} content 普通提示信息内容(可为html标签)
 * @param {Function} handleOk 点击确定回调
 */
export const info = (title:string,content:any,handleOk:()=>{}):void => {
    Modal.info({
    title: title,
    content: (
        <div>
            {content}
        </div>
    ),
    onOk:handleOk,
    });
}
/**
 * 点击提示,执行信息展示,只提供一个按钮用于关闭
 * @param {string} title 警告提示信息标题
 * @param {any} content 警告提示信息内容(可为html标签)
 * @param {Function} handleOk 点击确定回调
 */
export const warning = (title:string,content:any,handleOk:()=>{}):void => {
    Modal.warning({
        title: title,
        content: (
            <div>
                {content}
            </div>),
        onOk:handleOk,
    });
}
/**
 * 含有确认取消按钮的消息确认框
 * @param {string} title 消息提示框标题
 * @param {any} content 消息提示框内容
 * @param {Function} handleOk 点击确认回调
 * @param {Function} handleCancel 点击取消回调
 * @param {string} okText 确定按钮文本内容默认确定
 * @param {string} cancelText 取消按钮文本内容默认取消
 */
export const confirm = (title:string,content:any,handleOk:()=>{},handleCancel:()=>{},okText:string='确定',cancelText:string='取消'):void => {
    Modal.confirm({
        title: title,
        content: content,
        okText:okText,
        cancelText:cancelText,
        onOk:handleOk,
        onCancel:handleCancel,
    });
}

export default notification;
