/**
 * @file SVG库
 * @author 徐立 SVG设计与搭建
 * iconFont矢量图标库
 * 已有一下图标
 * @param { ?string|number } width 图标宽度
 * @param { ?string|number } height 图标高度
 * @param { ?string|Array<string> } color 颜色
 * @param { ?string } mouseColor 鼠标移入颜色
 * @param { ?any } style 样式配置
 * @param { string } name 需要调用的svg库
 * phone 手机图标
 * phoneTwo 手机图标 单色版
 * leftArrows 向左箭头
 * rightArrows 向右箭头
 * bottomArrows 向下箭头
 * topArrows 向上箭头
 * email 邮箱
 * vertical 竖线
 * filePreview 文件预览
 * preview 预览 扩展图标
 * cssRight 动画用 右箭头
 * cssLeft css用左箭头
 * delete 删除图标
 * examine 审批图表
 * trunTo 转办图标
 * screen 筛选图表
 * unfold 展开图标
 * packUp 收起图标
 * listSvg 列表图标
 * horn 喇叭图标
 * coverage 图层图标
 * module 组件图标
 * rightPanel 右侧面板
 * toolbar 工具栏图标
 * filter 过滤图标
 * refresh 刷新图标
 * beautify 美化图标
 * project 项目图标
 * help 帮助图标
 * transpond 转发功能
 * previewDynamic 场景设计器预览图标
 * breviary 缩略图标
 * drawer 抽屉图标
 * shiftdown 下移图标
 * topdown 上移图标
 * stick 置顶图标
 * bottommost 置底图标
 * trashcan 垃圾桶图标
 * lock 锁定图标
 * disnone 隐藏图标
 * textType 文字排版
 * location 定位图标
 * charts 图表图表
 * diagram 柱状图表
 * pages 页面图标
 * link 链接图标
 * portal 门户图标
 * login 登录图标
 * personalCenter 个人中心图标
 * backstage 后台图标
 * arraySVG 阵列图标
 * pickUp 收起图标
 * pickDown 打开图标
 * allSvg 表示所有内容相关图标
 * empty 表示空图标
 * close 关闭图标
 * color 颜色板图标
 * config 配置图标
 * introduce 介绍图标
 * await 等待图标
 * theme 主题图标
 * darg 拖动图标
 * colorPalette 调色板
 * cat 集成图标
 * dot 圆点
 * oneModal 单模板图标
 * twoModal 多模板图标
 * fulfill 完成图标
 * borderColor 边框颜色
 * borderType 线段类型
 * add 添加按钮
 * omit 三个点省略
 * insert 插入
 * ren 重命名

 */
/**
 * 样式修改颜色示例
 * svg {
 *    path {
 *      fill: red;
 *    }
 *  }
 */
import React, { useState, useEffect } from 'react';
import './style.css';
interface configProps {
  name: string;
  width?: string | number;
  height?: string | number;
  color?: string | Array<string>;
  mouseColor?: string;
  style?: any;
}
export default function index(props: configProps) {
  const { name, width, height, color: deaColor = '#888888', mouseColor, style } = props;
  const [showColor, setMouseColor] = useState<string | Array<string>>(
    Array.isArray(deaColor) ? deaColor[0] : deaColor || '',
  );
  const [color, setColor] = useState<string | Array<string>>(
    Array.isArray(deaColor) ? deaColor[0] : deaColor || '',
  );
  function mouseEnterColor() {
    if (mouseColor) {
      setMouseColor(mouseColor);
    }
  }
  function mouseLeaveColor() {
    if (mouseColor) {
      setMouseColor('');
    }
  }
  useEffect(() => {
    setColor(deaColor);
    setMouseColor(deaColor);
  }, [deaColor]);
  switch (name) {
    case 'phone': // 手机图标
      return (
        <svg
          t="1585203232204"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2260"
          width={width ? width : '16'}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
          style={{ cursor: 'pointer' }}
        >
          <path
            d="M181.677419 726.709677h660.645162v49.548388H181.677419z"
            fill="#8a8a8a"
            p-id="2261"
          ></path>
          <path
            d="M231.225806 57.806452A24.774194 24.774194 0 0 0 206.451613 82.580645v858.83871A24.774194 24.774194 0 0 0 231.225806 966.193548h561.548388a24.774194 24.774194 0 0 0 24.774193-24.774193V82.580645A24.774194 24.774194 0 0 0 792.774194 57.806452H231.225806z m0-49.548387h561.548388A74.322581 74.322581 0 0 1 867.096774 82.580645v858.83871a74.322581 74.322581 0 0 1-74.32258 74.32258H231.225806A74.322581 74.322581 0 0 1 156.903226 941.419355V82.580645A74.322581 74.322581 0 0 1 231.225806 8.258065z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2262"
          ></path>
          <path
            d="M503.741935 867.096774m-41.290322 0a41.290323 41.290323 0 1 0 82.580645 0 41.290323 41.290323 0 1 0-82.580645 0Z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="2263"
          ></path>
        </svg>
      );
    case 'phoneTwo': // 手机图标 单色版
      return (
        <svg
          t="1585205938395"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2004"
          width={width ? width : '16'}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
          style={{ cursor: 'pointer' }}
        >
          <path
            d="M736 0 288 0c-52.8 0-96 43.2-96 96l0 832c0 52.8 43.2 96 96 96l448 0c52.8 0 96-43.2 96-96L832 96C832 43.2 788.8 0 736 0zM384 48l256 0 0 32L384 80 384 48zM512 960c-35.346 0-64-28.654-64-64s28.654-64 64-64 64 28.654 64 64S547.346 960 512 960zM768 768 256 768 256 128l512 0L768 768z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2005"
          ></path>
        </svg>
      );
    case 'leftArrows': // 向左箭头
      return (
        <svg
          t="1585205394038"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1314"
          width={width ? width : '16'}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
          style={{ cursor: 'pointer' }}
        >
          <path
            d="M402.746 146.746l-320 320c-24.994 24.992-24.994 65.516 0 90.508l320 320c24.994 24.992 65.516 24.992 90.51 0 24.996-24.992 24.996-65.516 0-90.508L282.508 576 896 576c35.346 0 64-28.652 64-64 0-35.346-28.654-64-64-64L282.508 448l210.746-210.746C505.75 224.758 512 208.378 512 192s-6.248-32.758-18.744-45.254C468.26 121.752 427.74 121.752 402.746 146.746z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1315"
          ></path>
        </svg>
      );
    case 'rightArrows': // 向右箭头
      return (
        <svg
          t="1585205490262"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1452"
          width={width ? width : '16'}
          height={height ? height : '16'}
          style={{ cursor: 'pointer' }}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M621.254 877.254l320-320c24.994-24.992 24.994-65.516 0-90.51l-320-320c-24.994-24.992-65.516-24.992-90.51 0-24.994 24.994-24.994 65.516 0 90.51L741.49 448 128 448c-35.346 0-64 28.654-64 64s28.654 64 64 64l613.49 0L530.744 786.746C518.248 799.242 512 815.622 512 832s6.248 32.758 18.744 45.254C555.738 902.248 596.26 902.248 621.254 877.254z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1453"
          ></path>
        </svg>
      );
    case 'bottomArrows': // 向下箭头
      return (
        <svg
          t="1585205593014"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1590"
          width={width ? width : '16'}
          height={height ? height : '16'}
          style={{ cursor: 'pointer' }}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M146.746 621.254l320 320c24.992 24.994 65.516 24.994 90.51 0l320-320c24.992-24.994 24.992-65.516 0-90.51-24.994-24.994-65.516-24.994-90.51 0L576 741.49 576 128c0-35.346-28.654-64-64-64s-64 28.654-64 64l0 613.49L237.254 530.744C224.758 518.248 208.378 512 192 512s-32.758 6.248-45.254 18.744C121.752 555.738 121.752 596.26 146.746 621.254z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1591"
          ></path>
        </svg>
      );
    case 'topArrows': // 向上箭头
      return (
        <svg
          t="1585205724335"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1728"
          width={width ? width : '16'}
          height={height ? height : '16'}
          style={{ cursor: 'pointer' }}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M877.254 402.746l-320-320c-24.992-24.994-65.514-24.994-90.508 0l-320 320c-24.994 24.994-24.994 65.516 0 90.51 24.994 24.996 65.516 24.996 90.51 0L448 282.51 448 896c0 35.346 28.654 64 64 64 35.346 0 64-28.654 64-64L576 282.51l210.746 210.746C799.242 505.752 815.622 512 832 512s32.758-6.248 45.254-18.746C902.248 468.26 902.248 427.74 877.254 402.746z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1729"
          ></path>
        </svg>
      );
    case 'email': // 邮箱
      return (
        <svg
          t="1585205803829"
          className="icon"
          viewBox="0 0 1026 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1866"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M928 96 96 96C43.2 96 0 139.2 0 192l0 640c0 52.8 43.2 96 96 96l832 0c52.8 0 96-43.2 96-96L1024 192C1024 139.2 980.8 96 928 96zM176.38 224l671.24 0L512 476 176.38 224zM512 640l384-412.378L895 800l-766.666 0.334L128 227.622"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1867"
          ></path>
        </svg>
      );
    case 'vertical': // 竖线
      return (
        <svg
          t="1585371781000"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1869"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M450.56 128h61.44v768H450.56zM512 128h61.44v768h-61.44z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1870"
          ></path>
        </svg>
      );
    case 'filePreview': // 文件预览
      return (
        <svg
          t="1585379297430"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2282"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M614.4 1024H128c-70.656 0-128-57.344-128-128V128C0 57.344 57.344 0 128 0h614.4c70.656 0 128 57.344 128 128v230.4c0 14.336-11.264 25.6-25.6 25.6s-25.6-11.264-25.6-25.6V128c0-42.496-34.304-76.8-76.8-76.8H128c-42.496 0-76.8 34.304-76.8 76.8v768c0 42.496 34.304 76.8 76.8 76.8h486.4c14.336 0 25.6 11.264 25.6 25.6s-11.264 25.6-25.6 25.6z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2283"
          ></path>
          <path
            d="M691.2 256H179.2c-14.336 0-25.6-11.264-25.6-25.6s11.264-25.6 25.6-25.6h512c14.336 0 25.6 11.264 25.6 25.6s-11.264 25.6-25.6 25.6zM384 443.904H179.2c-14.336 0-25.6-11.264-25.6-25.6s11.264-25.6 25.6-25.6h204.8c14.336 0 25.6 11.264 25.6 25.6s-11.264 25.6-25.6 25.6zM281.6 631.296H179.2c-14.336 0-25.6-11.264-25.6-25.6s11.264-25.6 25.6-25.6h102.4c14.336 0 25.6 11.264 25.6 25.6s-11.264 25.6-25.6 25.6zM332.8 819.2H179.2c-14.336 0-25.6-11.264-25.6-25.6s11.264-25.6 25.6-25.6h153.6c14.336 0 25.6 11.264 25.6 25.6s-11.264 25.6-25.6 25.6zM640 896c-141.312 0-256-114.688-256-256s114.688-256 256-256 256 114.688 256 256-114.688 256-256 256z m0-460.8c-113.152 0-204.8 91.648-204.8 204.8s91.648 204.8 204.8 204.8 204.8-91.648 204.8-204.8-91.648-204.8-204.8-204.8z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="2284"
          ></path>
          <path
            d="M998.4 1024c-6.656 0-13.312-2.56-17.92-7.68l-189.44-189.44c-10.24-10.24-10.24-26.112 0-36.352s26.112-10.24 36.352 0l189.44 189.44c10.24 10.24 10.24 26.112 0 36.352-5.12 5.12-11.776 7.68-18.432 7.68z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="2285"
          ></path>
        </svg>
      );
    case 'preview': // 预览 扩展图标
      return (
        <svg
          t="1585790369493"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2253"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M32.321058 1023.900012h-0.699915C14.223267 1023.900012 0.025 1009.701745 0.025 992.203881V671.543025C0.025 654.245136 14.223267 639.946881 31.721131 639.946881h0.699914c17.397876 0 31.696131 14.298255 31.696131 31.696131v320.660857c-0.099988 17.397876-14.298255 31.596143-31.796118 31.596143z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2254"
          ></path>
          <path
            d="M383.978131 991.603955v0.699914c0 17.397876-14.298255 31.696131-31.696131 31.696131H31.721131C14.223267 1023.900012 0.025 1009.701745 0.025 992.203881v-0.699914C0.025 974.206078 14.223267 959.907824 31.721131 959.907824h320.660857c17.397876 0 31.596143 14.298255 31.596143 31.696131z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="2255"
          ></path>
          <path
            d="M9.723816 1014.701135l-0.499939-0.499939c-12.298499-12.298499-12.298499-32.496033 0-44.794532l294.564043-294.564042c12.298499-12.298499 32.496033-12.298499 44.794531 0l0.499939 0.499939c12.298499 12.298499 12.298499 32.496033 0 44.794532L54.518348 1014.701135c-12.298499 12.298499-32.496033 12.298499-44.794532 0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="2256"
          ></path>
          <path
            d="M32.321058 0.024997h-0.699915C14.223267 0.024997 0.025 14.223264 0.025 31.721128v320.660857C0.025 369.779861 14.223267 383.978128 31.721131 383.978128h0.699914c17.397876 0 31.696131-14.298255 31.696131-31.696131V31.721128C64.017188 14.223264 49.818922 0.024997 32.321058 0.024997z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
            p-id="2257"
          ></path>
          <path
            d="M383.978131 32.321055v-0.699915C383.978131 14.223264 369.779864 0.024997 352.282 0.024997H31.721131C14.223267 0.024997 0.025 14.223264 0.025 31.721128v0.699914C0.025 49.818919 14.223267 64.017185 31.721131 64.017185h320.660857c17.397876 0 31.596143-14.198267 31.596143-31.69613z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
            p-id="2258"
          ></path>
          <path
            d="M9.723816 9.223874l-0.499939 0.499939C-3.074622 22.022312-3.074622 42.219846 9.223877 54.518345l294.564043 294.564042c12.298499 12.298499 32.496033 12.298499 44.794531 0l0.499939-0.499939c12.298499-12.298499 12.298499-32.496033 0-44.794531L54.518348 9.223874C42.219849-3.074625 22.022315-3.074625 9.723816 9.223874z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[5]
                  : showColor
                : Array.isArray(color)
                ? color[5]
                : color
            }
            p-id="2259"
          ></path>
          <path
            d="M991.603958 1023.900012h0.699914c17.397876 0 31.696131-14.298255 31.696131-31.696131V671.643012c0-17.397876-14.298255-31.696131-31.696131-31.696131h-0.699914c-17.397876 0-31.696131 14.298255-31.696131 31.696131v320.660857c0 17.397876 14.298255 31.596143 31.696131 31.596143z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[6]
                  : showColor
                : Array.isArray(color)
                ? color[6]
                : color
            }
            p-id="2260"
          ></path>
          <path
            d="M639.946885 991.603955v0.699914c0 17.397876 14.298255 31.696131 31.69613 31.696131h320.660857c17.397876 0 31.696131-14.298255 31.696131-31.696131v-0.699914c0-17.397876-14.298255-31.696131-31.696131-31.696131H671.643015c-17.397876 0-31.696131 14.298255-31.69613 31.696131z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[7]
                  : showColor
                : Array.isArray(color)
                ? color[7]
                : color
            }
            p-id="2261"
          ></path>
          <path
            d="M1014.201199 1014.701135l0.499939-0.499939c12.298499-12.298499 12.298499-32.496033 0-44.794532L720.037108 674.842622c-12.298499-12.298499-32.496033-12.298499-44.794532 0l-0.499939 0.499939c-12.298499 12.298499-12.298499 32.496033 0 44.794532l294.564042 294.564042c12.398487 12.298499 32.596021 12.298499 44.89452 0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[8]
                  : showColor
                : Array.isArray(color)
                ? color[8]
                : color
            }
            p-id="2262"
          ></path>
          <path
            d="M991.603958 0.024997h0.699914c17.397876 0 31.696131 14.198267 31.696131 31.696131v320.660857c0 17.397876-14.298255 31.696131-31.696131 31.69613h-0.699914c-17.397876 0-31.696131-14.298255-31.696131-31.69613V31.721128C959.907827 14.223264 974.206081 0.024997 991.603958 0.024997z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[9]
                  : showColor
                : Array.isArray(color)
                ? color[9]
                : color
            }
            p-id="2263"
          ></path>
          <path
            d="M639.946885 32.321055v-0.699915C639.946885 14.223264 654.245139 0.024997 671.643015 0.024997h320.660857c17.397876 0 31.696131 14.198267 31.696131 31.696131v0.699914c0 17.397876-14.298255 31.696131-31.696131 31.696131H671.643015C654.245139 64.017185 639.946885 49.818919 639.946885 32.321055z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[10]
                  : showColor
                : Array.isArray(color)
                ? color[10]
                : color
            }
            p-id="2264"
          ></path>
          <path
            d="M1014.201199 9.223874l0.499939 0.499939c12.298499 12.298499 12.298499 32.496033 0 44.794532L720.037108 349.082387c-12.298499 12.298499-32.496033 12.298499-44.794532 0l-0.499939-0.499939c-12.298499-12.298499-12.298499-32.496033 0-44.794531L969.406667 9.223874c12.298499-12.298499 32.496033-12.298499 44.794532 0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[11]
                  : showColor
                : Array.isArray(color)
                ? color[11]
                : color
            }
            p-id="2265"
          ></path>
        </svg>
      );
    case 'cssRight': // 动画用 右箭头
      return (
        <svg
          t="1585892088918"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1218"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M836.8 551.2L462 176.4c-32.3-32.3-84.8-32.3-117 0-32.3 32.3-32.3 84.8 0 117L671.5 620c10.3 10.3 10.3 27.1 0 37.4-10.3 10.3-27.1 10.3-37.4 0L307.6 330.8c-52.9-52.9-52.9-139 0-191.8 26.4-26.4 61.2-39.7 95.9-39.7s69.5 13.2 95.9 39.7l374.8 374.8M403.5 99.3"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1219"
          ></path>
          <path
            d="M818.1 532.5L475.8 874.9c-42.6 42.6-111.8 42.6-154.4 0-42.7-42.6-42.7-111.8 0-154.4l342.4-342.4"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="1220"
          ></path>
          <path
            d="M645 359.4L307.6 696.8c-52.9 52.9-52.9 139 0 191.8 25.6 25.6 59.7 39.7 95.9 39.7s70.3-14.1 95.9-39.7l337.4-337.4m0-74.8L820 493.2l-20.6 20.6L462 851.2c-15.6 15.6-36.4 24.2-58.5 24.2s-42.9-8.6-58.5-24.2c-32.3-32.3-32.3-84.8 0-117l337.4-337.4 19.9-19.9 17.5-17.5"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="1221"
          ></path>
        </svg>
      );
    case 'cssLeft': // css用左箭头
      return (
        <svg
          t="1585892592534"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1358"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M161.1 511.2l373.6-373.6c26.4-26.4 61-39.5 95.6-39.5 34.6 0 69.2 13.2 95.6 39.5 52.7 52.7 52.7 138.5 0 191.2L400.4 654.3c-10.3 10.3-27 10.3-37.3 0-10.3-10.3-10.3-27 0-37.3l325.4-325.4c32.2-32.2 32.2-84.5 0-116.6-32.2-32.2-84.5-32.2-116.6 0L198.4 548.5M630.3 98.1"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1359"
          ></path>
          <path
            d="M371 375.9l341.2 341.2c42.5 42.5 42.5 111.4 0 153.9s-111.4 42.5-153.9 0L217 529.9"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="1360"
          ></path>
          <path
            d="M198.4 548.5l336.3 336.3c25.5 25.5 59.5 39.6 95.6 39.6 36.1 0 70.1-14.1 95.6-39.6 52.7-52.7 52.7-138.5 0-191.2L389.6 357.3m-74.6 0l17.4 17.4 19.8 19.8 336.3 336.3c32.2 32.2 32.2 84.5 0 116.6-15.6 15.6-36.3 24.2-58.3 24.2s-42.7-8.6-58.3-24.2L235.7 511.2l-20.5-20.5-16.7-16.7"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="1361"
          ></path>
        </svg>
      );
    case 'delete': // 删除图标
      return (
        <svg
          t="1586225333815"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1175"
          width={width ? width : '16'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 1024a512 512 0 1 1 512-512 512 512 0 0 1-512 512zM512 64a448 448 0 1 0 448 448 448 448 0 0 0-448-448z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1176"
          ></path>
          <path
            d="M818.56 544H203.52a32 32 0 1 1 0-64h615.04a32 32 0 0 1 0 64z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="1177"
          ></path>
        </svg>
      );
    case 'examine': // 审批图表
      return (
        <svg
          t="1586504684446"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="14853"
          xlink="http://www.w3.org/1999/xlink"
          width={width ? width : '14'}
          style={{ cursor: 'pointer' }}
          height={height ? height : '14'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <defs>
            <style type="text/css"></style>
          </defs>
          <path
            d="M888.156551 675.947131H603.162672v-143.315888a274.142819 274.142819 0 1 0-182.625388 0v143.315888H135.543405A108.305863 108.305863 0 0 0 27.442278 784.048257v56.30267h968.815399v-55.483722A108.305863 108.305863 0 0 0 888.156551 675.947131zM132.47235 951.932582c0 39.718974 38.081079 72.067418 84.556374 72.067418h589.642508c46.475295 0 84.556374-32.348443 84.556373-72.067418v-37.671604H132.47235z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="14854"
          ></path>
        </svg>
      );
    case 'trunTo': // 转办图标
      return (
        <svg
          t="1586504661137"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="13456"
          xlink="http://www.w3.org/1999/xlink"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <defs>
            <style type="text/css"></style>
          </defs>
          <path
            d="M955.733333 887.466667s-6.826667 20.48-20.48 0c0 0-136.533333-382.293333-464.213333-286.72v116.053333s-6.826667 68.266667-68.266667 27.306667L81.92 484.693333s-68.266667-34.133333 6.826667-81.92L409.6 136.533333s47.786667-34.133333 61.44 20.48v129.706667s607.573333 27.306667 484.693333 600.746667z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="13457"
          ></path>
        </svg>
      );
    case 'screen': // 筛选图表
      return (
        <svg
          t="1586757156769"
          className="icon"
          viewBox="0 0 1031 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1140"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M544.24 870.052a24.08 24.08 0 0 1-24.053-24.054V434.555c0-5.755 2.063-11.32 5.816-15.678l182.513-212.265H213.545l167.578 213.074a24.151 24.151 0 0 1 5.145 14.869v245.637l72.458 72.453a23.849 23.849 0 0 1 6.887 17.024 23.916 23.916 0 0 1-7.173 16.958c-4.532 4.464-10.527 6.922-16.881 6.922s-12.355-2.453-16.88-6.922l-79.463-79.468a23.92 23.92 0 0 1-7.045-17.014V442.88L145.126 197.422a24.08 24.08 0 0 1 4.025-33.777 24.151 24.151 0 0 1 14.868-5.145h596.885a23.884 23.884 0 0 1 17.003 7.05 23.875 23.875 0 0 1 7.04 17.014 24.054 24.054 0 0 1-5.811 15.672L568.284 443.47v402.524a24.074 24.074 0 0 1-24.043 24.059z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1141"
          ></path>
          <path
            d="M660.951 805.99a23.885 23.885 0 0 1-16.998-7.055 23.905 23.905 0 0 1-7.03-17.019 24.084 24.084 0 0 1 24.033-24.033h186.117a24.084 24.084 0 0 1 24.028 24.074 24.084 24.084 0 0 1-24.033 24.033h0.005-186.122z m0-150.553a24.074 24.074 0 0 1-24.028-24.07 24.09 24.09 0 0 1 24.033-24.038h186.117a24.084 24.084 0 0 1 24.028 24.075 24.09 24.09 0 0 1-24.033 24.033h0.005-186.122z m0-148.823c-13.184-0.17-23.839-11.095-23.67-24.356a23.9 23.9 0 0 1 23.747-23.747h186.045c13.261 0 24.049 10.788 24.049 24.054s-10.788 24.054-24.049 24.054H660.951z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="1142"
          ></path>
        </svg>
      );
    case 'unfold': // 展开图标
      return (
        <svg
          t="1586828348739"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2734"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 736 128 320 896 320Z"
            p-id="2735"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'packUp': // 收起图标
      return (
        <svg
          t="1586828524466"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2857"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 320 128 736 896 736Z"
            p-id="2858"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'listSvg': // 列表图标
      return (
        <svg
          t="1587026384401"
          className="icon"
          viewBox="0 0 1515 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2637"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M355.19474 402.291726c-30.481534 0-56.383123 10.660822-77.718795 31.996493C256.147288 455.616877 245.479452 481.518466 245.479452 512c0 30.474521 10.667836 56.383123 32.003507 77.711781s47.244274 31.996493 77.718795 31.996493c30.474521 0 56.37611-10.667836 77.711781-31.996493 21.328658-21.328658 31.996493-47.23726 31.996493-77.711781 0-30.481534-10.667836-56.383123-32.003507-77.711781C411.577863 412.959562 385.676274 402.291726 355.19474 402.291726z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2638"
          ></path>
          <path
            d="M355.201753 109.715288c-30.481534 0-56.383123 10.667836-77.718795 31.996493-21.328658 21.335671-31.996493 47.23726-31.996493 77.711781 0 30.481534 10.660822 56.383123 31.996493 77.718795 21.335671 21.328658 47.244274 31.996493 77.718795 31.996493 30.474521 0 56.37611-10.667836 77.711781-31.996493 21.328658-21.335671 31.996493-47.23726 31.996493-77.718795 0-30.474521-10.667836-56.37611-31.996493-77.711781C411.584877 120.383123 385.683288 109.715288 355.201753 109.715288z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="2639"
          ></path>
          <path
            d="M355.201753 694.861151c-30.481534 0-56.390137 10.660822-77.718795 31.996493s-31.996493 47.23726-31.996493 77.711781c0 30.488548 10.660822 56.383123 31.996493 77.718795 21.335671 21.328658 47.244274 31.996493 77.718795 31.996493 30.474521 0 56.37611-10.667836 77.711781-31.996493 21.328658-21.335671 31.996493-47.230247 31.996493-77.718795 0-30.474521-10.667836-56.383123-31.996493-77.711781S385.683288 694.861151 355.201753 694.861151z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="2640"
          ></path>
          <path
            d="M1264.057863 151.713315c-3.633096-3.612055-7.904438-5.421589-12.863123-5.421589L556.333589 146.291726c-4.951671 0-9.237041 1.802521-12.85611 5.421589-3.619068 3.626082-5.428603 7.904438-5.428603 12.85611l0 109.722301c0 4.951671 1.809534 9.230027 5.428603 12.85611 3.619068 3.612055 7.904438 5.421589 12.85611 5.421589l694.861151 0c4.958685 0 9.237041-1.802521 12.863123-5.421589 3.619068-3.626082 5.421589-7.904438 5.421589-12.85611L1269.479452 164.569425C1269.479452 159.617753 1267.669918 155.332384 1264.057863 151.713315z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
            p-id="2641"
          ></path>
          <path
            d="M1251.19474 438.861151 556.333589 438.861151c-4.951671 0-9.237041 1.802521-12.85611 5.428603-3.619068 3.619068-5.428603 7.904438-5.428603 12.85611l0 109.722301c0 4.944658 1.809534 9.230027 5.428603 12.849096 3.619068 3.626082 7.904438 5.428603 12.85611 5.428603l694.861151 0c4.958685 0 9.237041-1.802521 12.863123-5.428603 3.619068-3.619068 5.421589-7.904438 5.421589-12.849096L1269.479452 457.145863c0-4.951671-1.809534-9.244055-5.421589-12.85611C1260.424767 440.670685 1256.153425 438.861151 1251.19474 438.861151z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
            p-id="2642"
          ></path>
          <path
            d="M1251.19474 731.430575 556.333589 731.430575c-4.951671 0-9.237041 1.809534-12.85611 5.428603-3.619068 3.619068-5.428603 7.904438-5.428603 12.849096l0 109.722301c0 4.958685 1.809534 9.237041 5.428603 12.863123 3.619068 3.612055 7.904438 5.414575 12.85611 5.414575l694.861151 0c4.958685 0 9.237041-1.802521 12.863123-5.414575 3.619068-3.626082 5.421589-7.904438 5.421589-12.863123l0-109.722301c0-4.944658-1.809534-9.237041-5.421589-12.849096C1260.424767 733.247123 1256.153425 731.430575 1251.19474 731.430575z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[5]
                  : showColor
                : Array.isArray(color)
                ? color[5]
                : color
            }
            p-id="2643"
          ></path>
        </svg>
      );
    case 'horn': // 喇叭svg
      return (
        <svg
          t="1589012238656"
          className="icon"
          viewBox="0 0 1096 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2284"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M321.254185 760.42463L0 717.658968V292.341674l337.37355-44.849116L584.829556 0v1024l-263.575371-263.57537zM657.93325 255.862931a292.524433 292.524433 0 0 1 0 542.319757V255.862931z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2285"
          ></path>
          <path
            d="M657.93325 0c235.86907 49.929823 412.889666 259.335356 412.889666 510.081028S893.80232 970.268785 657.93325 1020.162056v-134.035624c163.313653-47.042227 282.801642-197.599286 282.801642-376.081956 0-178.446118-119.487989-329.003177-282.801642-376.045404V0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="2286"
          ></path>
        </svg>
      );
    case 'coverage': // 图层图标
      return (
        <svg
          t="1589778166307"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1943"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 78.77l433.23 315.076L512 708.923 78.77 393.846 512 78.77z m352 492.307l81.23 59.077L512 945.23 78.77 630.154 160 571.077l352 256 352-256z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="1944"
          ></path>
        </svg>
      );
    case 'module': // 组件图标
      return (
        <svg
          t="1589778653804"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3303"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M917.376 243.456L500.8 4.8a34.144 34.144 0 0 0-34.336 0.096l0.16-0.096L50.112 243.52a33.952 33.952 0 0 0-17.088 29.376v477.44c0 12.16 6.528 23.296 17.088 29.44l416.512 238.72a34.88 34.88 0 0 0 34.336-0.064l-0.16 0.096 416.576-238.72c10.272-5.952 17.088-16.896 17.088-29.44v-477.44c0-12.544-6.816-23.488-16.928-29.344l-0.16-0.096z m-51.264 487.36l-382.4 219.136-382.336-219.136V292.48L483.712 73.344l382.4 219.136v438.272zM198.784 360.512a33.76 33.76 0 0 0 12.384 46.304l0.16 0.096 237.824 136.32V812.8c0 18.816 15.232 33.92 34.176 33.92h0.256a33.92 33.92 0 0 0 33.92-33.92V543.616L756.16 406.784a33.92 33.92 0 0 0 12.48-46.528l0.096 0.16a34.4 34.4 0 0 0-46.88-12.32l0.16-0.096-238.272 136.512L245.536 348a34.464 34.464 0 0 0-46.624 12.384l-0.096 0.16z"
            p-id="3304"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'rightPanel': // 右侧面板SVG
      return (
        <svg
          t="1589778787866"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3528"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M896.05 200v624.47H128.63V200h767.42M960 136H64.68v752.43H960z"
            p-id="3529"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M896.05 200v624.47H696.2V200h199.85M960 136H632.25v752.43H960z"
            p-id="3530"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
          <path
            d="M832.1 279.89h-64v447.66h64z"
            p-id="3531"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
          ></path>
        </svg>
      );
    case 'toolbar': // 工具栏图标
      return (
        <svg
          t="1589778990522"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4271"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M768 256h-74.666667v-42.666667a64 64 0 0 0-64-64h-234.666666a64 64 0 0 0-64 64v42.666667h-73.173334A106.666667 106.666667 0 0 0 149.333333 362.666667v405.333333a106.666667 106.666667 0 0 0 107.733334 106.666667H768a106.666667 106.666667 0 0 0 106.666667-106.666667V362.666667a106.666667 106.666667 0 0 0-106.666667-106.666667z m-394.666667-42.666667a21.333333 21.333333 0 0 1 21.333334-21.333333h234.666666a21.333333 21.333333 0 0 1 21.333334 21.333333v42.666667h-277.333334zM832 768a64 64 0 0 1-64 64H257.493333a64 64 0 0 1-64-64V362.666667a64 64 0 0 1 64-64H768a64 64 0 0 1 64 64z"
            p-id="4272"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M757.333333 544H704v-42.666667a42.666667 42.666667 0 0 0-42.666667-42.666666h-42.666666a42.666667 42.666667 0 0 0-42.666667 42.666666v42.666667h-128v-42.666667a42.666667 42.666667 0 0 0-42.666667-42.666666h-42.666666a42.666667 42.666667 0 0 0-42.666667 42.666666v42.666667h-53.333333a21.333333 21.333333 0 0 0 0 42.666667H320v42.666666a42.666667 42.666667 0 0 0 42.666667 42.666667h42.666666a42.666667 42.666667 0 0 0 42.666667-42.666667v-42.666666h128v42.666666a42.666667 42.666667 0 0 0 42.666667 42.666667h42.666666a42.666667 42.666667 0 0 0 42.666667-42.666667v-42.666666h53.333333a21.333333 21.333333 0 0 0 0-42.666667z m-352 85.333333h-42.666666v-128h42.666666v128z m256 0h-42.666666v-128h42.666666v128z"
            p-id="4273"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'filter': // 过滤按钮
      return (
        <svg
          t="1589782054801"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4991"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M537.6 934.4c-19.2 0-32-12.8-32-32V396.8c0-6.4 0-19.2 6.4-19.2l217.6-243.2H147.2l217.6 243.2c6.4 6.4 6.4 12.8 6.4 19.2v300.8l51.2 44.8c12.8 12.8 19.2 32 6.4 44.8-12.8 12.8-32 19.2-44.8 6.4l-64-51.2c-6.4-6.4-12.8-12.8-12.8-25.6V409.6l-256-288c-12.8-6.4-12.8-25.6-6.4-38.4 0-6.4 12.8-19.2 25.6-19.2h736c12.8 0 25.6 6.4 32 19.2 6.4 12.8 0 25.6-6.4 38.4L576 409.6V896c0 19.2-19.2 38.4-38.4 38.4z m364.8-518.4h-224c-19.2 0-32 12.8-32 32s12.8 32 32 32h224c19.2 0 32-12.8 32-32 0-12.8-12.8-32-32-32z m0 179.2h-224c-19.2 0-32 12.8-32 32s12.8 32 32 32h224c19.2 0 32-12.8 32-32s-12.8-32-32-32z m0 179.2h-224c-19.2 0-32 12.8-32 32s12.8 32 32 32h224c19.2 0 32-12.8 32-32s-12.8-32-32-32z"
            p-id="4992"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'refresh': // 刷新图标
      return (
        <svg
          t="1591164665142"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3216"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M171.309757 549.028173C146.751772 395.45579 231.111425 240.268869 381.752145 181.550641c111.636862-43.528816 232.004979-22.709763 317.235633 39.471225l-72.526783 117.478943 325.244596-1.253392L835.458797 0l-59.546741 96.426206c-125.572881-81.321771-296.756483-107.919173-446.653666-49.477117C121.577713 127.909713 2.038109 337.289905 25.640117 549.028173L171.309757 549.028173zM852.687625 464.965935c24.536741 153.572383-59.780424 308.780549-210.421144 367.477532-102.693166 40.023567-215.859591 24.940376-302.874735-29.019211 16.570267-26.894818 65.53753-106.198415 65.53753-106.198415L55.169182 676.704203l148.006473 347.295797 62.053525-100.483797c125.551637 81.321771 279.591386 101.992117 429.488569 43.55006 207.638189-80.981868 327.220281-290.340816 303.618273-502.05784L852.687625 465.008423z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'beautify': //美化SVG
      return (
        <svg
          t="1589782551637"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="7595"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M410.9824 615.68a48.4864 48.4864 0 0 1 0.512 68.608L134.144 961.4336a48.4864 48.4864 0 0 1-68.5568-0.512 48.4864 48.4864 0 0 1-0.512-68.608l277.248-277.1968a48.4864 48.4864 0 0 1 68.608 0.512zM464.896 561.664L205.7216 479.488 425.728 324.608l-5.4272-270.848 218.2144 163.584 255.8976-85.1456-85.1456 255.8464L972.8 606.3104l-270.848-5.376-154.7776 220.0064L464.896 561.664z"
            p-id="7596"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'project': // 项目图标
      return (
        <svg
          t="1589785791333"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="11642"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M787.308264 551.182943 604.465062 551.182943C575.089819 551.182943 551.277133 575.022177 551.277133 604.436008L551.271298 787.477208C551.271298 917.984949 656.948189 1023.776146 787.308264 1023.776146 917.663673 1023.776146 1023.339396 917.983781 1023.339396 787.481882 1023.339396 656.979981 917.663673 551.182943 787.308264 551.182943L787.308264 551.182943 787.308264 551.182943Z"
            p-id="11643"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M787.312556 599.236379 787.312556 599.236379C837.551437 599.236379 884.77647 618.825397 920.306803 654.386776 955.825732 689.946728 975.387231 737.234399 975.387231 787.519298 975.387231 837.814186 955.825732 885.100432 920.296823 920.657529 884.77647 956.221764 837.551437 975.803643 787.312556 975.803643 737.075099 975.803643 689.850066 956.221764 654.321161 920.657529 618.797956 885.091867 599.237881 837.814186 599.237881 787.519298L599.237881 599.236379 787.312556 599.236379 787.312556 599.236379Z"
            p-id="11644"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
          <path
            d="M787.308264 0.385327C656.954024 0.385327 551.277133 106.17886 551.277133 236.678424L551.277133 419.725466C551.277133 449.134623 575.089819 472.972688 604.465062 472.972688L787.308264 472.978531C917.663673 472.978531 1023.339396 367.18266 1023.339396 236.678424 1023.339396 106.177692 917.663673 0.385327 787.308264 0.385327L787.308264 0.385327 787.308264 0.385327Z"
            p-id="11645"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
          ></path>
          <path
            d="M787.312556 48.435259C837.551437 48.435259 884.77647 68.019995 920.306803 103.588509 955.825732 139.148462 975.387231 186.427569 975.387231 236.721031 975.387231 287.014493 955.825732 334.29931 920.296823 369.862117 884.77647 405.423497 837.551437 425.006804 787.312556 425.006804L599.237881 425.006804 599.237881 236.721031C599.237881 186.426143 618.797956 139.148462 654.321161 103.588509 689.850066 68.025702 737.080803 48.435259 787.312556 48.435259L787.312556 48.435259Z"
            p-id="11646"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
          ></path>
          <path
            d="M237.122842 551.182943C106.767434 551.182943 1.091711 656.978814 1.091711 787.477208 1.091711 917.984949 106.767434 1023.776146 237.122842 1023.776146 367.482917 1023.776146 473.153973 917.983781 473.159808 787.477208L473.159806 604.436008C473.159806 575.029186 449.341286 551.182943 419.966045 551.182943L237.122842 551.182943 237.122842 551.182943Z"
            p-id="11647"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
          ></path>
          <path
            d="M237.127391 599.236379 237.127391 599.236379 425.20064 599.236379 425.20064 787.519298C425.20064 837.814186 405.640567 885.100432 370.117361 920.657529 334.597008 956.221764 287.364848 975.803643 237.125967 975.803643 186.885659 975.803643 139.660627 956.221764 104.140273 920.657529 68.611366 885.100432 49.051292 837.814186 49.051292 787.519298 49.051292 737.225836 68.611366 689.946728 104.140273 654.386776 139.662052 618.81826 186.887084 599.236379 237.127391 599.236379L237.127391 599.236379Z"
            p-id="11648"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[5]
                  : showColor
                : Array.isArray(color)
                ? color[5]
                : color
            }
          ></path>
          <path
            d="M237.122842 0.385327C106.767434 0.385327 1.091711 106.17886 1.091711 236.678424 1.091711 367.18266 106.767434 472.978531 237.122842 472.978531L419.966045 472.978531C449.341286 472.978531 473.153973 449.134623 473.153973 419.725466L473.153973 236.685433C473.159806 106.177692 367.482917 0.385327 237.122842 0.385327L237.122842 0.385327 237.122842 0.385327Z"
            p-id="11649"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[6]
                  : showColor
                : Array.isArray(color)
                ? color[6]
                : color
            }
          ></path>
          <path
            d="M237.127587 48.435259C287.366658 48.435259 334.598998 68.025777 370.119486 103.588718 405.642825 139.148805 425.202973 186.433801 425.202973 236.721744L425.202973 425.006804 237.129011 425.006804C186.888516 425.006804 139.663303 405.423422 104.135686 369.861906 68.612347 334.298964 49.053625 287.013968 49.053625 236.720316 49.053625 186.432373 68.613773 139.147377 104.135686 103.58729 139.661878 68.025776 186.887089 48.435259 237.127587 48.435259L237.127587 48.435259Z"
            p-id="11650"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[7]
                  : showColor
                : Array.isArray(color)
                ? color[7]
                : color
            }
          ></path>
        </svg>
      );
    case 'help': // 帮助图标
      return (
        <svg
          t="1589788114473"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="12393"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 1021.724C230.514 1021.724 2.276 793.486 2.276 512S230.514 2.276 512 2.276 1021.724 230.514 1021.724 512 793.486 1021.724 512 1021.724z m0-67.925c243.94 0 441.8-197.746 441.8-441.799S755.94 70.2 512 70.2 70.2 268.06 70.2 512 268.06 953.8 512 953.8z"
            p-id="12394"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M525.198 262.827c46.422 0 84.082 12.288 113.095 38.457 29.014 25.372 43.463 60.188 43.463 103.651 0 35.499-9.443 65.195-27.534 88.405-6.485 7.965-26.851 26.852-60.87 56.548-13.768 11.605-23.894 24.69-30.493 37.66-7.965 14.45-11.606 30.493-11.606 47.9v12.289h-77.596v-12.288c0-26.852 4.323-50.062 14.45-68.836 9.443-20.252 36.977-50.062 81.92-89.884l12.288-13.767c13.084-16.726 20.252-34.02 20.252-52.907 0-25.372-7.282-44.942-21.049-59.392-14.45-14.45-35.498-21.731-61.667-21.731-32.655 0-56.548 10.126-70.998 31.175-13.084 17.408-19.57 42.097-19.57 73.955h-76.117c0-52.906 15.246-94.208 45.625-124.7 30.72-31.29 72.818-46.535 126.407-46.535z m-12.97 424.05c15.246 0 28.216 4.323 38.456 14.45 10.127 9.443 15.247 21.73 15.247 36.977 0 15.246-5.803 27.534-15.93 37.66-10.125 9.444-23.21 14.45-37.66 14.45-14.45 0-27.534-5.12-37.66-15.246-10.126-10.126-15.246-22.528-15.246-36.978 0-15.246 5.12-27.534 15.246-36.978 9.899-10.012 22.983-14.336 37.547-14.336z"
            p-id="12395"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'transpond': // 转发svg
      return (
        <svg
          t="1589788348603"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="13157"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M773.3 747.8l-309.1-95.1L773.3 296 369.1 652.7l-237.8-95.1 760.9-404.3-118.9 594.5zM464.2 890.5V724l95.1 47.6-95.1 118.9z"
            p-id="13158"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'previewDynamic': // 预览svg
      return (
        <svg
          t="1589788529051"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="18283"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M81.188571 340.845714a18.285714 18.285714 0 0 1-18.285714-18.285714V158.72a24.137143 24.137143 0 0 1 24.868572-24.137143h159.451428a18.285714 18.285714 0 0 1 18.285714 18.285714 18.285714 18.285714 0 0 1-18.285714 18.285715h-146.285714v151.405714a18.285714 18.285714 0 0 1-19.748572 18.285714zM942.811429 340.845714a18.285714 18.285714 0 0 1-18.285715-18.285714V171.154286h-146.285714a18.285714 18.285714 0 0 1-18.285714-18.285715 18.285714 18.285714 0 0 1 18.285714-18.285714h157.988571a24.137143 24.137143 0 0 1 24.868572 24.137143v163.84a18.285714 18.285714 0 0 1-18.285714 18.285714zM247.222857 890.148571H87.771429a24.868571 24.868571 0 0 1-24.868572-24.868571V701.44a18.285714 18.285714 0 0 1 36.571429 0v152.137143h146.285714a18.285714 18.285714 0 0 1 18.285714 18.285714 18.285714 18.285714 0 0 1-16.822857 18.285714zM936.228571 890.148571h-159.451428a18.285714 18.285714 0 0 1-18.285714-18.285714 18.285714 18.285714 0 0 1 18.285714-18.285714h146.285714V701.44a18.285714 18.285714 0 0 1 36.571429 0v163.84a24.868571 24.868571 0 0 1-23.405715 24.868571zM804.571429 650.24H219.428571a36.571429 36.571429 0 0 1-36.571428-36.571429V410.331429a36.571429 36.571429 0 0 1 36.571428-36.571429h585.142858a36.571429 36.571429 0 0 1 36.571428 36.571429v203.337142a36.571429 36.571429 0 0 1-36.571428 36.571429zM219.428571 410.331429v203.337142h585.142858V410.331429z"
            p-id="18284"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'breviary': // 缩略SVG
      return (
        <svg
          t="1589860549471"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2091"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M479.355 155.746H153.087v325.957h326.267V155.746z m-48.008 277.949H201.1V203.759h230.247v229.936z m-278.26 436.589H479.67V544.225H153.087v326.059zM201.1 592.237h230.559v230.039H201.1V592.237zM543.131 154.6v326.374h326.583V154.6H543.131z m278.57 278.361H591.143V202.612H821.7v230.349zM544.277 870.6h325.329V544.327H544.277V870.6z m48.013-278.26h229.304v230.247H592.29V592.34z m0 0"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2092"
          ></path>
        </svg>
      );
    case 'drawer': // 抽屉图标
      return (
        <svg
          t="1589860809511"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="9834"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M816.374754 246.569722 237.717611 246.569722l0 51.244104 578.658166 0L816.375777 246.569722zM816.374754 451.584002 237.717611 451.584002l0 51.244104 578.658166 0L816.375777 451.584002zM816.374754 656.597259 237.717611 656.597259l0 51.244104 578.658166 0L816.375777 656.597259zM135.602909 75.724659 135.602909 878.685403l782.88757 0L918.490479 75.724659 135.602909 75.724659zM867.432617 827.421856 186.659749 827.421856 186.659749 126.96774l680.772868 0L867.432617 827.421856z"
            p-id="9835"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'shiftdown': // 下移图标
      return (
        <svg
          t="1589866287331"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2572"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M460.8 759.232L460.8 204.8l-307.2 0a51.2 51.2 0 1 1 0-102.4L870.4 102.4a51.2 51.2 0 1 1 0 102.4l-307.2 0L563.2 755.584l128-128a51.2 51.2 0 0 1 72.384 72.384l-217.216 217.216a51.2 51.2 0 0 1-72.384 0l-217.216-217.216a51.2 51.2 0 0 1 72.384-72.384L460.8 759.232zM819.2 409.6l-153.6 0a51.2 51.2 0 1 1 0-102.4L819.2 307.2a51.2 51.2 0 1 1 0 102.4z m-460.8 0l-153.6 0a51.2 51.2 0 1 1 0-102.4l153.6 0a51.2 51.2 0 1 1 0 102.4z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2573"
          ></path>
        </svg>
      );
    case 'topdown': // 上移图标
      return (
        <svg
          t="1589866364136"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2693"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M563.2 264.832V819.2h307.2a51.2 51.2 0 1 1 0 102.4H153.6a51.2 51.2 0 1 1 0-102.4h307.2V268.416l-128 128a51.2 51.2 0 0 1-72.384-72.448L477.568 106.88a51.2 51.2 0 0 1 72.448 0l217.216 217.152a51.2 51.2 0 1 1-72.384 72.448L563.2 264.832zM204.8 614.4h153.6a51.2 51.2 0 1 1 0 102.4H204.8a51.2 51.2 0 1 1 0-102.4z m460.8 0h153.6a51.2 51.2 0 1 1 0 102.4h-153.6a51.2 51.2 0 1 1 0-102.4z"
            p-id="2694"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'stick': // 置顶图标
      return (
        <svg
          t="1589866481629"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3435"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M533.196 164.62c-22.197-8.878-48.835-4.438-67.228 13.319L160.277 486.805c-12.048 12.05-17.758 27.902-17.758 43.126 0 15.852 6.346 31.712 18.393 43.76 24.096 24.102 63.423 23.467 87.52-0.635l195.34-190.899v577.771c0 34.252 34.252 61.524 68.497 61.524 34.246 0 68.498-27.907 68.498-61.524V385.962l192.799 185.829c24.103 24.099 63.423 24.099 87.526 0 24.097-24.102 24.097-63.423 0-87.525L554.13 177.939c-5.71-5.71-12.689-9.515-19.664-12.683-0.635-0.636-1.27-0.636-1.27-0.636z m0 0"
            p-id="3436"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M142.519 19.714C142.519 8.827 147.869 0 154.471 0H867.6c6.601 0 11.951 8.827 11.951 19.714v75.572c0 10.888-5.351 19.714-11.951 19.714H154.471c-6.602 0-11.952-8.826-11.952-19.714V19.714z"
            p-id="3437"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'bottommost': // 置底图标
      return (
        <svg
          t="1589866605403"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4162"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M146.285714 877.714286h731.428572c40.228571 0 73.142857 32.914286 73.142857 73.142857s-32.914286 73.142857-73.142857 73.142857H146.285714c-40.228571 0-73.142857-32.914286-73.142857-73.142857s32.914286-73.142857 73.142857-73.142857z m21.333715-387.169143l288.914285 292.692571c14.628571 14.628571 34.254857 21.821714 53.515429 21.333715h5.364571c0.731429 0 1.462857-0.122286 2.194286-0.122286 0.486857 0 0.852571 0 1.340571-0.121143 0.731429-0.122286 1.462857-0.122286 2.072-0.244571 0.488-0.121143 0.976-0.121143 1.462858-0.243429 0.610286-0.122286 1.219429-0.243429 1.707428-0.243429a58.316571 58.316571 0 0 1 1.949714-0.365714c0.365714-0.122286 0.731429-0.122286 1.219429-0.244571 0.853714-0.243429 1.706286-0.365714 2.56-0.609143 0.122286 0 0.243429-0.122286 0.365714-0.122286 12.190857-3.169143 23.649143-9.508571 33.157715-18.894857l292.937142-292.814857c28.404571-28.404571 28.404571-74.971429 0-103.497143-28.403429-28.404571-74.971429-28.404571-103.497142 0L585.142857 554.788571V73.142857c0-40.228571-32.914286-73.142857-73.142857-73.142857s-73.142857 32.914286-73.142857 73.142857v483.962286l-167.740572-170.057143c-28.404571-28.404571-74.971429-28.404571-103.497142 0-28.404571 28.403429-28.404571 74.971429 0 103.497143z"
            p-id="4163"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'trashcan': // 垃圾桶图标
      return (
        <svg
          t="1589869500297"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4911"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M292.864 163.84c22.95808-94.04416 107.78624-163.84 208.896-163.84 101.10976 0 185.93792 69.79584 208.896 163.84H983.04a40.96 40.96 0 1 1 0 81.92H40.96a40.96 40.96 0 1 1 0-81.92h251.904z m85.97504 0h245.84192a133.16096 133.16096 0 0 0-245.84192 0zM819.2 368.64a40.96 40.96 0 1 1 81.92 0v491.52a163.84 163.84 0 0 1-163.84 163.84H286.72a163.84 163.84 0 0 1-163.84-163.84V368.64a40.96 40.96 0 1 1 81.92 0v491.52a81.92 81.92 0 0 0 81.92 81.92h450.56a81.92 81.92 0 0 0 81.92-81.92V368.64z m-409.6-40.96a40.96 40.96 0 0 1 40.96 40.96v409.6a40.96 40.96 0 1 1-81.92 0V368.64a40.96 40.96 0 0 1 40.96-40.96z m204.8 0a40.96 40.96 0 0 1 40.96 40.96v409.6a40.96 40.96 0 1 1-81.92 0V368.64a40.96 40.96 0 0 1 40.96-40.96z"
            p-id="4912"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'lock': // 锁定图标
      return (
        <svg
          t="1589869660565"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="5838"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M768 362.6h85.4c23.6 0 42.6 19.1 42.6 42.6v512.1c0 23.6-19.1 42.6-42.6 42.6H170.6c-23.6 0-42.6-19.1-42.6-42.6v-512c0-23.6 19.1-42.6 42.6-42.6H256V320c0-141.4 114.6-256 256-256s256 114.6 256 256v42.6z m-298.6 330v96.8h85.4v-96.8C595.6 669 609.6 616.8 586 576c-23.6-40.8-75.8-54.8-116.6-31.2s-54.8 75.8-31.2 116.6c7.4 12.9 18.2 23.7 31.2 31.2z m213.3-329.9V320c0-94.3-76.4-170.7-170.7-170.7S341.4 225.7 341.4 320v42.6l341.3 0.1z"
            p-id="5839"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'disnone':
      return (
        <svg
          t="1589869764069"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="6572"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M669.9 490.4L501 659.3c3.5 0.5 7.3 0.5 11.1 0.5 87.1 0 158.3-70.9 158.3-158.3 0.1-3.8 0.1-7.3-0.5-11.1zM512.1 343.2c-13 0-25.4 1.6-37.3 4.6-57.4 13.8-102.6 59-116.4 116.4-3 11.9-4.6 24.6-4.6 37.3 0 10 0.8 19.8 3 29.2l184.6-184.6c-9.5-2.1-19.3-2.9-29.3-2.9z"
            p-id="6573"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M863.2 297.2L805 355.4c78.5 51.4 127.2 112 127.2 146.1 0 66.6-186.5 236-420 236-28.1 0-55.8-2.4-82.3-6.8l-67.7 67.4c47.4 12.4 98 19.5 149.9 19.5 271.2 0 499.9-194.3 499.9-316.1 0-60.9-57.4-140.2-148.8-204.3zM121.3 562.7c-18.9-23.8-29.5-45.5-29.5-61.2 0-56.3 133.2-185.9 315.6-224.6 33.3-7.3 68.5-11.4 104.7-11.4 14.6 0 29 0.5 43 1.9h0.3c19.2 1.6 37.9 4.6 56.3 8.4l66.3-66.3c-17.1-5.1-34.4-9.5-52.2-12.7-36.5-7.3-74.7-11.4-113.7-11.4-4.6 0-9.2 0-13.8 0.3C233.1 191.9 12 381.9 12 501.5c0 35.2 19.2 76.6 53 117.5 18.9 23.3 42.8 46.3 70.6 67.9 11.9 9.5 24.4 18.4 37.6 27.3l58.7-58.7c-14.1-8.4-27.1-17.1-39-26-29.9-22.1-54.2-45.4-71.6-66.8zM82.7 990.4c-12.6 0-25.1-4.8-34.7-14.4-19.2-19.2-19.2-50.2 0-69.4L906.7 48c19.2-19.1 50.2-19.1 69.4 0 19.2 19.2 19.2 50.2 0 69.4L117.4 976c-9.6 9.6-22.1 14.4-34.7 14.4z"
            p-id="6574"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'textType': // 文字排版
      return (
        <svg
          t="1589955480479"
          className="icon"
          viewBox="0 0 1075 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3195"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M27.6992 1024h1013.248v-59.904H27.7504V1024z m0-240.9472h1013.248v-59.7504H27.7504v59.7504zM452.352 588.8L387.7376 419.1232H155.8016L94.8736 588.8H17.0496L230.144 28.416h79.0528L536.2176 588.8H452.352zM237.9264 194.304L176.9984 358.4h187.9552l-57.9072-155.136a1571.9936 1571.9936 0 0 1-39.424-116.224 721.92 721.92 0 0 1-29.8496 107.0592l0.1536 0.1536z m445.2352 347.5456h357.8368V482.0992h-357.888v59.7504z m0-240.9472h357.8368V241.152h-357.888v59.7504z m0-240.8448V0.1536h357.8368V59.904l-357.888 0.1536z"
            p-id="3196"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'location': // 定位图标
      return (
        <svg
          t="1589955826394"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3988"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M511.2 234.4c-36 0-70.4 14.4-96 40.8-25.6 25.6-40 60-40 96s14.4 70.4 40 96c25.6 25.6 60 39.2 96 39.2s70.4-14.4 96-40c25.6-25.6 40-60 40-96s-14.4-70.4-40-96c-25.6-25.6-59.2-40-96-40z m0 208.8c-20 0-37.6-7.2-52-21.6-13.6-13.6-21.6-32-21.6-52 0-19.2 7.2-36.8 21.6-51.2 13.6-13.6 32-21.6 52-21.6s37.6 7.2 52 21.6c13.6 13.6 21.6 32 21.6 52 0 19.2-7.2 36.8-21.6 51.2-13.6 14.4-32 21.6-52 21.6z"
            p-id="3989"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M962.4 885.6L872 572c-7.2-24.8-32.8-42.4-60-42.4h-48.8c32.8-49.6 50.4-107.2 50.4-167.2 0-80.8-31.2-156.8-88.8-213.6-56-57.6-132-89.6-213.6-89.6-80.8 0-156 31.2-213.6 88.8-56.8 56.8-88.8 132.8-88.8 213.6 0 60.8 17.6 118.4 50.4 167.2h-48.8c-27.2 0-52.8 17.6-60 42.4L60.8 885.6c-5.6 19.2-2.4 38.4 8.8 52.8 10.4 13.6 26.4 20.8 44 20.8h796.8c17.6 0 33.6-8 44.8-21.6 10.4-14.4 12.8-33.6 7.2-52zM680 530.4L511.2 699.2l-168-168.8c-44.8-44.8-69.6-104.8-69.6-168.8 0-64 24.8-124 69.6-168.8 44.8-44.8 104.8-69.6 168.8-69.6 64 0 124 24.8 168.8 69.6 44.8 44.8 69.6 104.8 69.6 168.8S725.6 485.6 680 530.4z m81.6 62.4h50.4l87.2 304h-776l87.2-304H264c14.4 0 25.6-8.8 29.6-21.6 1.6 1.6 2.4 3.2 4 4.8l213.6 213.6L724.8 576l6.4-6.4c3.2 12.8 16 23.2 30.4 23.2z"
            p-id="3990"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'charts': // 图表图表
      return (
        <svg
          t="1589956003706"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4781"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M128 896h816c8.837 0 16 7.163 16 16v32c0 8.837-7.163 16-16 16H80c-8.837 0-16-7.163-16-16V80c0-8.837 7.163-16 16-16h32c8.837 0 16 7.163 16 16v816z m96-325h48c8.837 0 16 7.163 16 16v220c0 8.837-7.163 16-16 16h-48c-8.837 0-16-7.163-16-16V587c0-8.837 7.163-16 16-16z m360-112h48c8.837 0 16 7.163 16 16v332c0 8.837-7.163 16-16 16h-48c-8.837 0-16-7.163-16-16V475c0-8.837 7.163-16 16-16zM404 248h48c8.837 0 16 7.163 16 16v543c0 8.837-7.163 16-16 16h-48c-8.837 0-16-7.163-16-16V264c0-8.837 7.163-16 16-16z m360-99h48c8.837 0 16 7.163 16 16v642c0 8.837-7.163 16-16 16h-48c-8.837 0-16-7.163-16-16V165c0-8.837 7.163-16 16-16z"
            p-id="4782"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'diagram': // 柱状图表
      return (
        <svg
          t="1590110720189"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2924"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M153.6 204.8h-51.2C45.8 204.8 0 250.6 0 307.2v614.4C0 978.2 45.8 1024 102.4 1024h51.2c56.6 0 102.4-45.8 102.4-102.4V307.2c0-56.6-45.8-102.4-102.4-102.4zM537.6 0h-51.2C429.8 0 384 45.8 384 102.4v819.2c0 56.6 45.8 102.4 102.4 102.4h51.2c56.6 0 102.4-45.8 102.4-102.4V102.4C640 45.8 594.2 0 537.6 0z m384 409.6h-51.2C813.8 409.6 768 455.4 768 512v409.6c0 56.6 45.8 102.4 102.4 102.4h51.2c56.6 0 102.4-45.8 102.4-102.4V512c0-56.6-45.8-102.4-102.4-102.4z m0 0"
            p-id="2925"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'pages': // 页面组件
      return (
        <svg
          t="1590110999628"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3688"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M658.32207031 243.28496094L207.04414063 243.28496094c-79.97818359 0-145.04414063 65.06613281-145.04414063 145.04414062L62 783.17861328C61.99912109 863.16171875 127.06455078 928.22714844 207.04589844 928.22451172l451.27792969 0c79.97818359 0 145.03535156-65.06613281 145.03535156-145.04414063l0-394.85126953c0-79.97818359-65.05716797-145.04414063-145.03535156-145.04414062Zm0 620.47792969L207.04414063 863.76201172c-44.4393457 0-80.58120117-36.15082031-80.58120118-80.58120117l0-394.85126953c0-44.4393457 36.15082031-80.59016602 80.58102539-80.58999024l451.27792969 0c44.43029297 0 80.58120117 36.15978516 80.58102539 80.58999024L738.90283203 783.18037109c0 44.4393457-36.15978516 80.58120117-80.58120117 80.58120118Zm-405.44384765-714.66503907l564.08642578 0c44.43029297 0 80.58120117 36.15978516 80.58120117 80.58120117L897.54628906 737.35595703 962 737.35244141l0-507.67734375c0-79.97818359-65.05743164-145.03535156-145.03535156-145.03535157l-564.08642578 0 0 64.45415039Z"
            p-id="3689"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'link': // 链接组件
      return (
        <svg
          t="1590111125208"
          className="icon"
          viewBox="0 0 1025 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4424"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M768.512 256l-128 0c-35.392 0-64 28.608-64 64 0 35.328 28.608 64 64 64l128 0c70.656 0 128 57.344 128 128s-57.344 128-128 128l-128 0c-35.392 0-64 28.608-64 64s28.608 64 64 64l128 0c141.376 0 256-114.624 256-256S909.888 256 768.512 256zM384.512 640l-128 0c-70.656 0-128-57.344-128-128s57.344-128 128-128l128 0c35.392 0 64-28.672 64-64 0-35.392-28.608-64-64-64l-128 0c-141.376 0-256 114.624-256 256s114.624 256 256 256l128 0c35.392 0 64-28.608 64-64S419.904 640 384.512 640zM320.512 512c0 35.392 28.608 64 64 64l256 0c35.392 0 64-28.608 64-64s-28.608-64-64-64l-256 0C349.12 448 320.512 476.608 320.512 512z"
            p-id="4425"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'portal': // 门户或者书本图标
      return (
        <svg
          t="1590111332076"
          className="icon"
          viewBox="0 0 1212 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="5792"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M1212.072602 0a88.504754 88.504754 0 0 1-84.964564 75.229041c-489.431288 22.568712-495.626621 188.072602-495.626621 188.072601v760.255834s6.195333-173.911841 508.017287-189.400173a74.343993 74.343993 0 0 0 73.016421-72.573898V0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="5793"
          ></path>
          <path
            d="M85.407087 645.199654c2.655143 0-2.655143 0 0 0a88.504754 88.504754 0 0 1-84.964563-73.901469v190.28522a88.504754 88.504754 0 0 0 84.964563 73.90147c489.431288 22.568712 495.626621 188.072602 495.626621 188.072601v-190.28522s-6.195333-165.946413-495.626621-188.072602zM85.407087 359.3293c2.655143 0-2.655143 0 0 0A88.504754 88.504754 0 0 1 0.442524 285.427831v190.727744a88.504754 88.504754 0 0 0 84.964563 73.458945c489.431288 22.568712 495.626621 188.515125 495.626621 188.515126v-190.727745s-6.195333-165.946413-495.626621-188.072601zM85.407087 75.229041c2.655143 0-2.655143 0 0 0A88.504754 88.504754 0 0 1 0.442524 0v190.28522a88.504754 88.504754 0 0 0 84.964563 73.90147c489.431288 22.126188 495.626621 188.072602 495.626621 188.072601V261.531547s-6.195333-165.503889-495.626621-186.302506z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="5794"
          ></path>
        </svg>
      );
    case 'login': // 登录图标
      return (
        <svg
          t="1590111448340"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="6555"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512.966327 67.064929a444.944102 444.944102 0 0 1 314.55312 759.551408 444.944102 444.944102 0 1 1-629.232674-629.232674A442.018027 442.018027 0 0 1 512.966327 67.064929m0-33.704056c-264.358281 0-478.648158 214.289877-478.648157 478.648158s214.289877 478.648158 478.648157 478.648158 478.648158-214.289877 478.648158-478.648158-214.289877-478.648158-478.648158-478.648158z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="6556"
          ></path>
          <path
            d="M512.225777 127.049477a385.627855 385.627855 0 1 1-272.739138 112.942903 383.081086 383.081086 0 0 1 272.739138-112.942903m0-16.852028C289.95241 110.179387 109.763957 290.403965 109.763957 512.677332s180.188454 402.461821 402.46182 402.461821 402.479883-180.188454 402.479883-402.461821S734.499145 110.179387 512.225777 110.179387z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="6557"
          ></path>
          <path
            d="M280.108514 491.996119q-10.006456 5.147725-15.714109-4.569735a10.331575 10.331575 0 0 1-0.848923-8.579542 10.548322 10.548322 0 0 1 5.418658-6.863634l30.290301-16.581095q41.163742-24.293652 56.588855-49.165294H286.105163a11.722364 11.722364 0 0 1-11.433369-11.433369q0-11.433369 11.433369-11.433369h79.744589a15.714109 15.714109 0 0 1 14.287196 8.001552 16.003104 16.003104 0 0 1 1.137918 16.003105q-18.062195 37.153934-70.876051 67.733229v0.288996z m217.775881 104.887165a11.722364 11.722364 0 0 1 11.433369 11.433369q0 11.433369-11.433369 11.433369H278.663539q-11.433369 0-11.433369-11.433369a10.385762 10.385762 0 0 1 3.431816-8.001552 10.963752 10.963752 0 0 1 8.001553-3.431817h41.434674l-5.147725-8.290548a11.776551 11.776551 0 0 1-1.137919-8.868537 10.494135 10.494135 0 0 1 5.147726-6.863634q9.717461-5.707654 15.714109 4.009807l12.01136 20.012912h81.171502l12.282293-20.012912a10.602508 10.602508 0 0 1 7.224878-5.147725 11.216623 11.216623 0 0 1 8.579542 1.137918 10.530259 10.530259 0 0 1 5.147725 6.863634 11.812675 11.812675 0 0 1-1.137918 8.868537l-5.147725 8.290548z m-187.48558-160.338102a12.42679 12.42679 0 0 1-17.719013 0 11.505618 11.505618 0 0 1-3.720812-8.868538 12.10167 12.10167 0 0 1 3.720812-8.868537 13.16734 13.16734 0 0 1 17.719013 0 12.10167 12.10167 0 0 1 3.720812 8.868537 11.52368 11.52368 0 0 1-3.720812 8.868538z m-5.418659 87.746141a27.599033 27.599033 0 0 1 8.272485-20.356093 28.213148 28.213148 0 0 1 20.283845-8.290547h109.456899a28.303459 28.303459 0 0 1 28.574392 28.574392v12.011359a28.303459 28.303459 0 0 1-28.574392 28.574392h-109.456899a28.195086 28.195086 0 0 1-20.283845-8.290547 27.580971 27.580971 0 0 1-8.290547-20.283845z m143.757007 0q0-5.707654-5.707653-5.707653h-109.4569q-5.725716 0-5.707653 5.707653v12.01136q0 5.725716 5.707653 5.707653h109.4569q5.707654 0 5.707653-5.707653z m-17.719013-66.017321q11.433369 0 11.43337 11.433369t-11.43337 11.433369h-85.470305A11.722364 11.722364 0 0 1 334.150601 469.61706a10.385762 10.385762 0 0 1 3.431817-8.001552 10.963752 10.963752 0 0 1 8.001552-3.431817z m79.166599 17.141023q9.717461 5.725716 4.009808 15.425114a12.788034 12.788034 0 0 1-6.863634 5.418658A11.054063 11.054063 0 0 1 498.516572 494.904133a265.279452 265.279452 0 0 1-38.869843-24.582647A198.684141 198.684141 0 0 1 417.236696 427.676644q-3.720812-5.418658-13.438273-21.674633l-9.428466-15.425114q-5.725716-9.717461 4.009808-15.71411a11.812675 11.812675 0 0 1 8.868537-1.137918 11.595929 11.595929 0 0 1 6.863634 5.418658l8.868538 14.576191q9.428466 15.714109 13.149277 20.57284A158.477696 158.477696 0 0 0 473.229499 451.970296q5.996649 4.569735 21.999753 14.287196zM458.779744 412.540525q-8.868538 7.224878-16.255976-0.288995-7.712557-8.290547 0.288995-16.255975l18.062195-17.141023a11.469494 11.469494 0 0 1 8.001552-3.142822 10.385762 10.385762 0 0 1 8.001553 3.431817q8.001552 8.001552-0.288996 16.255976z m12.282292 22.866739a11.469494 11.469494 0 0 1 3.142822-8.001553l14.287196-14.865186a11.343058 11.343058 0 0 1 8.001552-3.720812 11.487556 11.487556 0 0 1 8.001552 3.142822 11.343058 11.343058 0 0 1 3.720812 8.001552 11.830737 11.830737 0 0 1-3.142822 8.290548l-14.287196 14.865186q-7.224878 7.224878-16.255975 0.288995a10.3677 10.3677 0 0 1-3.504066-8.001552zM559.042986 503.700422a11.722364 11.722364 0 0 1-11.433369-11.43337 10.385762 10.385762 0 0 1 3.431817-8.001552 10.963752 10.963752 0 0 1 8.001552-3.431817h86.590161q11.433369 0 11.433369 11.433369t-11.433369 11.43337zM639.40169 569.735805l-74.054998 34.860036a12.372603 12.372603 0 0 1-8.290548 0.57799 9.554901 9.554901 0 0 1-6.863633-5.996649 11.866862 11.866862 0 0 1-0.577991-8.868537 11.415307 11.415307 0 0 1 5.996649-6.285644l57.799023-27.093292-51.441131-20.283844a11.36112 11.36112 0 0 1 8.290548-21.15083l68.31122 26.58755a14.449756 14.449756 0 0 1 9.717461 13.438273 14.720689 14.720689 0 0 1-8.8866 14.214947z m46.961706-66.017321v89.751045a34.065299 34.065299 0 0 1-9.428466 23.715661 32.855132 32.855132 0 0 1-24.871642 10.566384h-36.720441a11.722364 11.722364 0 0 1-11.43337-11.433369 10.385762 10.385762 0 0 1 3.431817-8.001552 10.963752 10.963752 0 0 1 8.001553-3.431817h36.575944q11.433369 0 11.433369-11.433369v-101.14829q0-11.433369 11.433369-11.433369h70.027129v-64.301413q0-9.13947-9.139471-9.139471H581.602667a11.722364 11.722364 0 0 1-11.433369-11.433369q0-11.433369 11.433369-11.433369h154.07052a32.204893 32.204893 0 0 1 31.970085 31.970084v64.301413h19.723916a11.722364 11.722364 0 0 1 11.433369 11.433369 10.963752 10.963752 0 0 1-3.431817 8.001553 10.385762 10.385762 0 0 1-8.001552 3.431817z m-95.458699-48.009314a11.722364 11.722364 0 0 1-11.433369-11.433369 10.385762 10.385762 0 0 1 3.431817-8.001552 10.963752 10.963752 0 0 1 8.001552-3.431817h127.753903a11.722364 11.722364 0 0 1 11.433369 11.433369 10.963752 10.963752 0 0 1-3.431817 8.001552 10.385762 10.385762 0 0 1-8.001552 3.431817z m200.056868 128.241582a11.415307 11.415307 0 0 1 5.996649 6.285644 11.902986 11.902986 0 0 1-0.577991 8.868538 10.331575 10.331575 0 0 1-6.285643 5.707653 11.017939 11.017939 0 0 1-8.868538-0.288995l-74.307869-34.860036a13.709206 13.709206 0 0 1-8.579542-14.287196 14.449756 14.449756 0 0 1 9.717461-13.438272l68.31122-26.587551a11.415307 11.415307 0 0 1 14.576191 6.574639 11.144374 11.144374 0 0 1 0 8.579542 11.415307 11.415307 0 0 1-6.285644 5.996649l-51.549503 20.356093z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="6558"
          ></path>
        </svg>
      );
    case 'personalCenter': // 个人中心
      return (
        <svg
          t="1590111550403"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="7272"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M996.9152 951.8592s-28.16 49.5616-93.4912 49.5616H114.944c-36.608 0-67.584-19.712-85.0432-49.5616 0 0-13.5168-14.08-13.5168-49.5616V878.08h1.6896c12.9536-149.248 144.1792-273.7152 323.84-322.7136-77.1584-53.504-128.4096-142.4896-128.4096-243.8656 0-163.328 132.352-295.68 295.68-295.68 163.328 0 295.68 132.352 295.68 295.68 0 101.376-51.2512 190.3616-128.9728 243.8656 179.6608 48.4352 310.8864 173.4656 323.84 322.7136h1.6896v24.7808c0 16.3328-1.6896 32.6656-4.5056 48.9984z"
            p-id="7273"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'backstage': // 后台图标
      return (
        <svg
          t="1590111669521"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="8025"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 0C229.228089 0 0 229.228089 0 512s229.228089 512 512 512 512-229.228089 512-512S794.771911 0 512 0z m0 972.8C257.501867 972.8 51.2 766.486756 51.2 512S257.501867 51.2 512 51.2c254.486756 0 460.8 206.313244 460.8 460.8S766.486756 972.8 512 972.8z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="8026"
          ></path>
          <path
            d="M725.333333 264.533333h-426.666666c-23.552 0-42.666667 19.273956-42.666667 43.042134v301.2608c0 23.768178 17.396622 47.524978 40.96 47.524977h174.08v61.872356h-40.96c-11.810133 0-24.746667 7.816533-24.746667 19.717689s9.5232 21.526756 21.333334 21.526755h170.666666c11.798756 0 21.333333-9.614222 21.333334-21.526755s-12.936533-19.717689-24.758045-19.717689h-40.96v-61.872356H727.04c23.552 0 40.96-23.7568 40.96-47.524977V307.575467c0-23.768178-19.114667-43.042133-42.666667-43.042134z m8.419556 335.758223a22.755556 22.755556 0 0 1-22.755556 22.755555H312.991289a22.755556 22.755556 0 0 1-22.755556-22.755555V321.308444a22.755556 22.755556 0 0 1 22.755556-22.755555H710.997333a22.755556 22.755556 0 0 1 22.755556 22.755555v278.983112zM702.691556 307.2H321.319822a22.755556 22.755556 0 0 0-22.755555 22.755556v261.688888a22.755556 22.755556 0 0 0 22.755555 22.755556H702.691556a22.755556 22.755556 0 0 0 22.755555-22.755556V329.955556c0-12.561067-10.205867-22.755556-22.755555-22.755556zM556.373333 551.662933l-32.119466 18.921245a8.339911 8.339911 0 0 1-11.502934-3.185778l-29.058844-51.291022c-1.536-2.787556-4.061867-4.539733-6.314667-4.881067-1.581511-0.273067-3.675022 0.682667-2.8672 0.4096a59.778844 59.778844 0 0 1-20.297955 4.824178c-30.856533-10.148978-53.1456-39.048533-53.1456-73.181867 0-12.242489 2.935467-23.768178 8.044089-34.053689 6.530844-6.166756 10.319644-9.511822 13.073066-4.630755l25.270045 44.669155a6.064356 6.064356 0 0 0 8.305777 2.230045l33.644089-19.785956c2.935467-1.627022 3.857067-5.552356 2.195911-8.533333l-16.554666-29.149867-8.715378-15.405511c-0.841956-1.536-3.925333-9.022578 22.243556-11.684978a77.289244 77.289244 0 0 1 62.702933 50.471823h-4.687645c-6.269156 0-13.835378 4.539733-16.884622 9.966933l-23.870578 42.166044c-1.661156 2.912711-2.4576 6.781156-2.332444 10.569956v0.068267c0.068267 3.390578 0.876089 6.712889 2.332444 9.272888l23.870578 42.029512c3.060622 5.484089 10.626844 9.955556 16.884622 9.955555h13.437156a8.624356 8.624356 0 0 1-3.652267 10.228622z m64.091023-63.658666l-16.110934 27.739022c-2.980978 5.165511-10.331022 9.352533-16.247466 9.352533h-32.290134c11.446044 0-9.307022 2.776178-16.315733-9.352533l-16.110933-27.739022c-2.935467-5.028978-2.935467-13.425778 0-18.579911l16.110933-27.739023c3.003733-5.154133 10.331022-9.341156 16.315733-9.341155h32.290134c5.927822 0 13.266489 4.187022 16.247466 9.341155l16.110934 27.739023c2.935467 5.165511 2.935467 13.539556 0 18.579911z m-33.6896-24.064c-1.365333-2.070756-4.699022-3.743289-7.384178-3.743289h-14.677334c-2.707911 0-6.052978 1.672533-7.406933 3.743289l-7.327289 11.093333a7.406933 7.406933 0 0 0 0 7.429689l7.327289 11.093333c3.1744 4.858311 12.606578 3.743289 7.395556 3.743289h14.677333c2.685156 0 6.018844-1.672533 7.3728-3.743289l7.338667-11.093333a7.406933 7.406933 0 0 0 0-7.429689l-7.315911-11.093333z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="8027"
          ></path>
        </svg>
      );
    case 'arraySVG': // 阵列svg
      return (
        <svg
          t="1590119634267"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="9352"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M401.066667 155.733333H234.666667c-44.8 0-83.2 36.266667-83.2 83.2V405.333333c0 44.8 36.266667 83.2 83.2 83.2h166.4c44.8 0 83.2-36.266667 83.2-83.2v-166.4c0-44.8-36.266667-83.2-83.2-83.2z m19.2 241.066667c0 14.933333-12.8 27.733333-27.733334 27.733333H234.666667c-14.933333 0-27.733333-12.8-27.733334-27.733333v-149.333333c0-14.933333 12.8-27.733333 27.733334-27.733334h157.866666c14.933333 0 27.733333 12.8 27.733334 27.733334v149.333333zM401.066667 544H234.666667c-44.8 0-83.2 36.266667-83.2 83.2v166.4c0 44.8 36.266667 83.2 83.2 83.2h166.4c44.8 0 83.2-36.266667 83.2-83.2v-166.4c0-44.8-36.266667-83.2-83.2-83.2z m19.2 241.066667c0 14.933333-12.8 27.733333-27.733334 27.733333h-149.333333c-14.933333 0-27.733333-12.8-27.733333-27.733333v-149.333334c0-14.933333 12.8-27.733333 27.733333-27.733333h149.333333c14.933333 0 27.733333 12.8 27.733334 27.733333v149.333334zM789.333333 155.733333h-166.4c-44.8 0-83.2 36.266667-83.2 83.2V405.333333c0 44.8 36.266667 83.2 83.2 83.2H789.333333c44.8 0 83.2-36.266667 83.2-83.2v-166.4c0-44.8-38.4-83.2-83.2-83.2z m19.2 241.066667c0 14.933333-12.8 27.733333-27.733333 27.733333h-157.866667c-14.933333 0-27.733333-12.8-27.733333-27.733333v-149.333333c0-14.933333 12.8-27.733333 27.733333-27.733334h157.866667c14.933333 0 27.733333 12.8 27.733333 27.733334v149.333333zM789.333333 544h-166.4c-44.8 0-83.2 36.266667-83.2 83.2v166.4c0 44.8 36.266667 83.2 83.2 83.2H789.333333c44.8 0 83.2-36.266667 83.2-83.2v-166.4c0-44.8-38.4-83.2-83.2-83.2z m19.2 241.066667c0 14.933333-12.8 27.733333-27.733333 27.733333h-149.333333c-14.933333 0-27.733333-12.8-27.733334-27.733333v-149.333334c0-14.933333 12.8-27.733333 27.733334-27.733333h149.333333c14.933333 0 27.733333 12.8 27.733333 27.733333v149.333334z"
            p-id="9353"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'pickUp': // 收起图标
      return (
        <svg
          t="1590123856411"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="10074"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M511.936 285.376a73.792 73.792 0 0 0-58.496 20.992L150.08 609.92a75.776 75.776 0 0 0 0 106.944 75.52 75.52 0 0 0 106.688-0.128l255.104-255.488 255.296 255.424c29.44 29.184 77.312 29.312 106.816-0.192a75.776 75.776 0 0 0 0-106.816L570.24 306.368a75.008 75.008 0 0 0-58.304-20.992z m0 0"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="10075"
          ></path>
        </svg>
      );
    case 'pickDown': // 下拉图标
      return (
        <svg
          t="1590123982687"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1733"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M52.335 261.072c-31.269 30.397-31.269 79.722 0 110.194l403.212 391.718c31.325 30.382 82.114 30.382 113.377 0l403.197-391.718c31.325-30.466 31.325-79.793 0-110.194-31.28-30.449-82.058-30.449-113.39 0l-346.497 336.64-346.457-336.64c-31.325-30.448-82.105-30.448-113.446 0l0 0z"
            p-id="1734"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'allSvg': // 表示所有内容相关图标
      return (
        <svg
          t="1590139189752"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3496"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M960.4 215c0-60.8-49.3-110.1-110.1-110.1S740.2 154.2 740.2 215s49.3 110.1 110.1 110.1c60.8-0.1 110.1-49.3 110.1-110.1z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="3497"
          ></path>
          <path
            d="M64 215a146 146 0 1 0 292 0 146 146 0 1 0-292 0Z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="3498"
          ></path>
          <path
            d="M664.4 215c0-65.8-53.3-119.1-119.1-119.1S426.2 149.2 426.2 215s53.3 119.1 119.1 119.1c65.8-0.1 119.1-53.4 119.1-119.1zM931.2 558.7c0-44.7-36.2-80.9-80.9-80.9s-80.9 36.2-80.9 80.9 36.2 80.9 80.9 80.9c44.7-0.1 80.9-36.3 80.9-80.9z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="3499"
          ></path>
          <path
            d="M208.545913 670.994097a112.298877 112.298877 0 1 0 3.033965-224.577261 112.298877 112.298877 0 1 0-3.033965 224.577261Z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
            p-id="3500"
          ></path>
          <path
            d="M643 558.7c0-54-43.7-97.7-97.7-97.7s-97.7 43.7-97.7 97.7 43.7 97.7 97.7 97.7 97.7-43.8 97.7-97.7zM897.9 865.6c0-26.3-21.3-47.6-47.6-47.6s-47.6 21.3-47.6 47.6 21.3 47.6 47.6 47.6 47.6-21.3 47.6-47.6zM297.1 865.6c0-48.1-39-87-87-87-48.1 0-87 39-87 87 0 48.1 39 87 87 87s87-38.9 87-87zM613.5 865.6c0-37.6-30.5-68.2-68.2-68.2s-68.2 30.5-68.2 68.2 30.5 68.2 68.2 68.2 68.2-30.6 68.2-68.2z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
            p-id="3501"
          ></path>
        </svg>
      );
    case 'empty':
      return (
        <svg
          t="1590385163638"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2785"
          width="200"
          height="200"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M456 864.8v-1.6 1.6z m57.6-58.4c-32 0-57.6 24.8-57.6 56.8v0.8c0 6.4 4.8 11.2 11.2 11.2s11.2-4.8 11.2-11.2v-0.8c0-18.4 15.2-34.4 34.4-34.4s34.4 16 34.4 34.4v0.8c0 6.4 4.8 11.2 11.2 11.2 6.4 0 11.2-4.8 11.2-11.2v-0.8c1.6-30.4-24.8-56.8-56-56.8zM380 717.6c-16-3.2-39.2-3.2-44.8 13.6-3.2 10.4 13.6 11.2 28.8 15.2 12 3.2 18.4 9.6 17.6 11.2-3.2 4-21.6-3.2-37.6 2.4s-12.8 20-3.2 24c9.6 3.2 24.8-0.8 60 4.8 17.6 3.2 28.8-3.2 31.2-13.6 3.2-24.8-29.6-52.8-52-57.6zM593.6 776c2.4 10.4 12 16.8 31.2 13.6 35.2-5.6 50.4-1.6 60-4.8 9.6-3.2 12-18.4-3.2-24-16-5.6-33.6 1.6-37.6-2.4-2.4-3.2 4.8-9.6 17.6-12 15.2-3.2 32-4.8 28.8-15.2-4.8-16.8-28-17.6-44.8-13.6-23.2 4.8-56 32.8-52 58.4z"
            p-id="2786"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M71.2 1024C32 1024 0 992 0 952.8V502.4c0-7.2 3.2-13.6 8-18.4l201.6-184c4.8-4 10.4-6.4 16.8-6.4h572.8c7.2 0 12.8 2.4 16.8 5.6l200 184c4.8 4.8 8.8 12 8.8 18.4V952c0 39.2-32 71.2-71.2 71.2H71.2z m-40-71.2c0 21.6 18.4 39.2 40.8 39.2h882.4c21.6 0 39.2-16.8 39.2-39.2V509.6H676.8l-1.6 9.6c-5.6 34.4-22.4 66.4-48.8 92.8-31.2 28.8-70.4 44.8-112 44.8-41.6 0-81.6-16-112-44.8-26.4-24-43.2-56.8-48.8-92.8l-1.6-9.6H31.2v443.2zM54.4 484h310.4c6.4 0 12 6.4 12 12.8 0 73.6 63.2 136 137.6 136S652 570.4 652 496.8c0-7.2 5.6-12.8 12-12.8h307.2L797.6 324h-568L54.4 484z m130.4-378.4c-28.8 0-52.8-24-52.8-52.8C132 24 156 0 184.8 0c28.8 0 52.8 24 52.8 52.8 0 28.8-24 52.8-52.8 52.8z m0-89.6c-20 0-36.8 16.8-36.8 36.8 0 20 16.8 36.8 36.8 36.8 20 0 36.8-16.8 36.8-36.8 0-20-16.8-36.8-36.8-36.8z m553.6 207.2c-19.2 0-35.2-16-35.2-35.2s16-35.2 35.2-35.2c19.2 0 35.2 16 35.2 35.2s-16 35.2-35.2 35.2z m0-53.6c-10.4 0-19.2 8.8-19.2 19.2S728 208 738.4 208s19.2-8.8 19.2-19.2-8.8-19.2-19.2-19.2zM364 179.2c-4.8 0-8-3.2-8-8v-36c0-4.8 3.2-8 8-8s8 3.2 8 8v36c0 4.8-4 8-8 8z"
            p-id="2787"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
          <path
            d="M381.6 160.8h-36c-4.8 0-8-3.2-8-8s3.2-8 8-8h36c4.8 0 8 3.2 8 8s-3.2 8-8 8zM72 301.6c-4.8 0-8-3.2-8-8v-70.4c0-4.8 3.2-8 8-8s8 3.2 8 8v70.4c0 4.8-3.2 8-8 8z"
            p-id="2788"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
          ></path>
          <path
            d="M107.2 266.4H36.8c-4.8 0-8-3.2-8-8s3.2-8 8-8h70.4c4.8 0 8 3.2 8 8s-3.2 8-8 8zM944 308c-4.8 0-8-3.2-8-8v-51.2c0-4.8 3.2-8 8-8s8 3.2 8 8V300c0 4.8-3.2 8-8 8z"
            p-id="2789"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
          ></path>
          <path
            d="M969.6 282.4h-51.2c-4.8 0-8-3.2-8-8s3.2-8 8-8h51.2c4.8 0 8 3.2 8 8s-3.2 8-8 8zM856 169.6c-4.8 0-8-3.2-8-8V80.8c0-4.8 3.2-8 8-8s8 3.2 8 8v80.8c0 4.8-3.2 8-8 8z"
            p-id="2790"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
          ></path>
          <path
            d="M896 129.6h-80c-4.8 0-8-3.2-8-8s3.2-8 8-8h80c4.8 0 8 3.2 8 8s-3.2 8-8 8z"
            p-id="2791"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[5]
                  : showColor
                : Array.isArray(color)
                ? color[5]
                : color
            }
          ></path>
        </svg>
      );
    case 'close':
      return (
        <svg
          t="1590386563568"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3544"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M572.267 512l225.867-225.867c16.533-16.533 16.533-43.733 0-60.267s-43.733-16.533-60.267 0L512 451.733 286.133 225.866c-16.533-16.533-43.733-16.533-60.267 0s-16.533 43.733 0 60.267L451.733 512 225.866 737.867c-16.533 16.533-16.533 43.733 0 60.267 8.267 8.267 19.2 12.533 30.133 12.533s21.867-4.267 30.133-12.533l225.867-225.867 225.867 225.867c8.267 8.267 19.2 12.533 30.133 12.533s21.867-4.267 30.133-12.533c16.533-16.533 16.533-43.733 0-60.267L572.265 512z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="3545"
          ></path>
        </svg>
      );
    case 'color': // 颜色版
      return (
        <svg
          t="1590479298970"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2717"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 0a512 512 0 0 0 0 1024c180.224 0-110.592-204.8 204.8-204.8a302.08 302.08 0 0 0 307.2-307.2A512 512 0 0 0 512 0zM179.2 486.4A76.8 76.8 0 1 1 256 409.6a76.8 76.8 0 0 1-76.8 76.8zM358.4 307.2a76.8 76.8 0 1 1 76.8-76.8A76.8 76.8 0 0 1 358.4 307.2z m307.2 0a76.8 76.8 0 1 1 76.8-76.8A76.8 76.8 0 0 1 665.6 307.2z m179.2 179.2A76.8 76.8 0 1 1 921.6 409.6a76.8 76.8 0 0 1-76.8 76.8z"
            p-id="2718"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'config': // 配置图标
      return (
        <svg
          t="1590545658011"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2667"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M264.704 749.568c8.192-47.616 48.128-84.992 97.792-84.992 54.784 0 99.328 45.568 99.328 101.888 0 55.808-44.544 101.888-99.328 101.888-49.664 0-89.6-37.376-97.792-84.992H172.032c-9.728 0-16.384-6.656-16.384-16.896 0-10.24 6.656-16.896 16.384-16.896h92.672z m0-508.928c8.192-47.616 48.128-84.992 97.792-84.992 54.784 0 99.328 45.568 99.328 101.888 0 55.808-44.544 101.888-99.328 101.888-49.664 0-89.6-37.376-97.792-84.992H172.032c-9.728 0-16.384-6.656-16.384-16.896 0-10.24 6.656-16.896 16.384-16.896h92.672z m494.592 254.464c-8.192-47.616-48.128-84.992-97.792-84.992-54.784 0-99.328 46.08-99.328 101.888s44.544 101.888 99.328 101.888c49.664 0 89.6-37.376 97.792-84.992h92.672c9.728 0 16.384-6.656 16.384-16.896 0-10.24-6.656-16.896-16.384-16.896h-92.672zM851.968 240.64c9.728 0 16.384 6.656 16.384 16.896 0 10.24-6.656 16.896-16.384 16.896h-331.776c-9.728 0-16.384-6.656-16.384-16.896 0-10.24 6.656-16.896 16.384-16.896h331.776z m0 508.928c9.728 0 16.384 6.656 16.384 16.896 0 10.24-6.656 16.896-16.384 16.896h-331.776c-9.728 0-16.384-6.656-16.384-16.896 0-10.24 6.656-16.896 16.384-16.896h331.776zM594.944 512c0-37.376 29.696-68.096 66.56-68.096 36.352 0 66.56 30.72 66.56 68.096s-29.696 68.096-66.56 68.096-66.56-30.72-66.56-68.096z m-91.136-16.896c9.728 0 16.384 6.656 16.384 16.896 0 10.24-6.656 16.896-16.384 16.896H172.032c-9.728 0-16.384-6.656-16.384-16.896s6.656-16.896 16.384-16.896h331.776zM296.448 257.536c0 37.376 29.696 68.096 66.56 68.096 36.352 0 66.56-30.72 66.56-68.096S399.36 189.44 362.496 189.44c-36.352 0-66.048 30.72-66.048 68.096z m0 508.928c0 37.376 29.696 68.096 66.56 68.096 36.352 0 66.56-30.72 66.56-68.096 0-37.376-29.696-68.096-66.56-68.096-36.864 0.512-66.56 30.72-66.56 68.096z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2668"
          ></path>
        </svg>
      );
    case 'introduce': // 介绍图标
      return (
        <svg
          t="1590546424241"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3400"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M787.607552 64H234.952704c-0.258048 0-0.48128 0.038912-0.765952 0.053248-0.258048-0.014336-0.507904-0.053248-0.765952-0.053248-60.520448 0-109.764608 50.663424-109.764608 112.920576v660.146176c0 8.323072 3.258368 16.246784 9.078784 21.983232l89.673728 88.981504c11.49952 11.38688 29.691904 11.38688 41.191424 0l91.48416-90.773504 94.918656 94.162944c11.503616 11.436032 29.710336 11.436032 41.209856 0l94.9248-94.162944 94.932992 94.162944c5.746688 5.701632 13.176832 8.57088 20.578304 8.57088 7.424 0 14.864384-2.869248 20.617216-8.57088l85.927936-85.233664c5.799936-5.77536 9.07264-13.694976 9.07264-21.979136V285.78816c47.802368-13.129728 83.075072-56.91392 83.075072-108.867584 0.002048-62.257152-50.569216-112.920576-112.734208-112.920576z m-22.76352 775.03488l-57.636864 57.206784-97.220608-96.454656c-11.759616-11.69408-30.386176-11.69408-42.162176 0l-97.19808 96.454656-97.210368-96.454656c-11.778048-11.69408-30.404608-11.69408-42.186752 0l-93.683712 92.928-61.458432-60.946432V169.013248c0-29.30688 23.164928-53.133312 51.636224-53.133312 0.258048 0 0.483328-0.077824 0.7168-0.077824 0.309248 0 0.575488 0.077824 0.86016 0.077824h0.106496c30.101504 0.069632 54.566912 23.885824 54.566912 53.133312 0 29.300736-24.520704 53.147648-54.675456 53.147648-16.791552 0-30.369792 13.96736-30.369792 31.227904 0 17.281024 13.576192 31.287296 30.369792 31.287296h535.545856v554.358784z m26.247168-605.673472l-15.958016 1.47456-473.073664-3.024896c28.807168-14.125056 28.827648-42.502144 28.807168-51.040256-0.07168-31.852544-4.909056-45.942784-13.029376-61.642752l473.624576-0.79872c29.71648 0 60.715008 31.16032 60.715008 60.03712 0 28.860416-31.37536 54.994944-61.085696 54.994944z"
            p-id="3401"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M283.240448 521.242624h360.763392c6.557696 0 11.855872-8.849408 11.855872-19.795968 0-10.98752-5.302272-19.867648-11.855872-19.867648H283.240448c-6.565888 0-11.864064 8.880128-11.864064 19.867648 0 10.944512 5.300224 19.795968 11.864064 19.795968zM283.240448 612.780032h360.763392c6.557696 0 11.855872-8.845312 11.855872-19.795968 0-10.954752-5.302272-19.857408-11.855872-19.857408H283.240448c-6.565888 0-11.864064 8.912896-11.864064 19.857408 0 10.950656 5.300224 19.795968 11.864064 19.795968zM283.240448 429.733888h360.763392c6.557696 0 11.855872-8.88832 11.855872-19.836928s-5.302272-19.80416-11.855872-19.80416H283.240448c-6.565888 0-11.864064 8.855552-11.864064 19.808256 0 10.944512 5.300224 19.832832 11.864064 19.832832z"
            p-id="3402"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
        </svg>
      );
    case 'await': // 等待图标
      return (
        <svg
          t="1590546740999"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4193"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M815.552527 511.178285c-43.008536 0.651846-67.994604 11.053754-81.297584 18.24248l0-13.235442c0-0.542352 0.212848-3.193739 0.212848-4.00522 0-32.408107-40.074717-60.886719-106.070804-77.308737-4.803399-0.552585-11.205203-0.552585-13.526061 5.877871-1.165546 3.228531-1.88186 11.683087 3.741207 12.57234 40.24254 10.224876 65.877383 25.467021 65.877383 42.503023 0 30.786167-83.355453 55.743582-186.222285 55.743582s-186.239681-24.957415-186.239681-55.743582c0-17.026792 25.546839-32.260751 65.750493-42.485627 13.033851-4.912893 14.373359-6.915503 12.748349-14.250562-1.031493-4.657067-5.716188-8.686846-11.888771-6.789637-72.091922 15.903202-123.737162 45.709041-123.737162 79.882352 0 0.811482-0.574075 3.462868-0.574075 4.00522l0 244.336868c0 74.661444 109.422132 135.185912 242.154155 135.185912 120.906697 0 221.834364-50.227961 238.70152-115.609041 1.393743-0.743944 2.752694-13.910824 2.996241-15.572674 1.948375-13.280468 23.25975-20.027126 74.830289-53.072753 51.571562-33.045627 83.635839-79.108732 82.635045-120.543424C894.640794 549.477566 881.643782 510.177492 815.552527 511.178285zM785.53384 677.212786c-30.726815 17.483186-46.162366 24.821315-51.278897 24.876574L734.254943 579.49216c5.116531-4.121877 35.790134-23.801079 69.985958-24.261567 39.377846-0.530073 46.537919 24.267706 47.134507 46.189995C851.971995 623.341854 816.260655 659.729599 785.53384 677.212786z"
            p-id="4194"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
          <path
            d="M456.243115 150.681838c0 0 78.285994 48.021713 80.110549 112.154359 1.338485 47.064922-27.836999 59.137889-32.04381 114.15697-3.004427 39.281655 34.046421 92.127234 18.024515 110.151749s-107.147322-9.012258-107.147322-86.891999c0-52.300156 14.369266-78.422094 42.057885-122.396631 18.285458-29.040407 23.031553-60.0824 15.021112-89.122807C468.097094 173.624363 456.243115 150.681838 456.243115 150.681838z"
            p-id="4195"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
          <path
            d="M577.420989 429.065126c17.927301 12.252045 30.364565 3.004427 29.696346-27.036773-0.667196-30.0412-1.793856-38.492686 4.840238-70.052472 6.007831-28.584012-12.016685-57.623395-20.862143-74.813916-6.607488-12.841469-13.674441-24.033369-13.674441-24.033369s9.361205 53.632501 5.496178 78.274738c-5.496178 35.048237-21.694091 57.579393-21.091364 84.118839C562.071396 406.328285 567.897078 422.556898 577.420989 429.065126z"
            p-id="4196"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
          ></path>
        </svg>
      );
    case 'theme': // 主题图标
      return (
        <svg
          t="1590658760194"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3191"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M1004.094293 321.092267L762.737493 79.735467a68.266667 68.266667 0 0 0-96.546133 0l-30.293333 30.293333a68.283733 68.283733 0 0 1-48.264534 20.002133h-151.1936a68.181333 68.181333 0 0 1-48.264533-20.002133l-30.293333-30.293333a68.266667 68.266667 0 0 0-96.546134 0L19.962027 321.092267a68.266667 68.266667 0 0 0 0 96.546133l96.546133 96.546133a67.84 67.84 0 0 0 66.645333 17.271467c10.8032-3.072 21.674667 4.181333 21.674667 15.4112V896c0 37.546667 30.72 68.266667 68.266667 68.266667h477.866666c37.546667 0 68.266667-30.72 68.266667-68.266667V546.8672c0-11.229867 10.871467-18.4832 21.674667-15.4112a67.84 67.84 0 0 0 66.645333-17.271467l96.546133-96.546133a68.266667 68.266667 0 0 0 0-96.546133z"
            p-id="3192"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'darg': // 拖动图标
      return (
        <svg
          t="1590997735668"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2575"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M1013.964333 488.004182L865.949488 339.988337a33.984735 33.984735 0 0 0-48.119624 0v118.193078H565.699831V206.119382h118.387076c13.311896-13.311896 13.311896-34.814728 0-48.119625L536.067062 9.982912a33.984735 33.984735 0 0 0-48.119624 0L339.931593 157.993757a33.984735 33.984735 0 0 0 0 48.119625h118.193077v252.063033H206.122637V339.988337h-0.061c-13.310896-13.310896-34.813728-13.310896-48.119624 0L9.987167 487.937183c-13.309896 13.311896-13.309896 34.813728 0 48.119624L158.003012 684.068652a33.974735 33.974735 0 0 0 48.119625 0V565.751576h252.002033V817.881608H339.931593a33.984735 33.984735 0 0 0 0 48.119625l148.014845 148.015845c13.311896 13.309896 34.809728 13.309896 48.119624 0L684.082907 866.001233c13.311896-13.315896 13.311896-34.813728 0-48.119625H565.694831V565.751576h252.129033v118.388076c13.310896 13.310896 34.809728 13.310896 48.119624 0l148.015845-148.015845c13.310896-13.315896 13.310896-34.813728 0.005-48.119625z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'colorPalette': // 调色板
      return (
        <svg
          t="1591338869724"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="5477"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M647.786916 376.524764A191.534094 191.534094 0 1 1 512.149811 320.22257a190.595724 190.595724 0 0 1 135.637105 56.302194z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            // fill="#FCFCFC"
            p-id="5478"
          ></path>
          <path
            d="M512.149811 192.263037v127.959533a190.595724 190.595724 0 0 0-135.637105 56.302194l-90.638002-90.638002A319.685566 319.685566 0 0 1 512.149811 192.263037z"
            // fill="#00E8CF"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="5479"
          ></path>
          <path
            d="M512.149811 21.650326v170.612711a319.685566 319.685566 0 0 0-226.275107 93.623725L165.379477 165.391535A488.144291 488.144291 0 0 1 512.149811 21.650326z"
            // fill="#70FFEF"
            p-id="5480"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
          ></path>
          <path
            d="M285.874704 285.886762l90.638002 90.638002A190.595724 190.595724 0 0 0 320.210512 512.161869H192.250979a319.685566 319.685566 0 0 1 93.623725-226.275107z"
            // fill="#0064B5"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[3]
                  : showColor
                : Array.isArray(color)
                ? color[3]
                : color
            }
            p-id="5481"
          ></path>
          <path
            d="M285.874704 285.886762A319.685566 319.685566 0 0 0 192.250979 512.161869H21.638269A488.144291 488.144291 0 0 1 165.379477 165.391535z"
            // fill="#0091FF"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[4]
                  : showColor
                : Array.isArray(color)
                ? color[4]
                : color
            }
            p-id="5482"
          ></path>
          <path
            d="M320.210512 512.161869a190.595724 190.595724 0 0 0 56.302194 135.637105l-90.638002 90.638002A319.685566 319.685566 0 0 1 192.250979 512.161869z"
            // fill="#31C4FF"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[5]
                  : showColor
                : Array.isArray(color)
                ? color[5]
                : color
            }
            p-id="5483"
          ></path>
          <path
            d="M192.250979 512.161869a319.685566 319.685566 0 0 0 93.623725 226.275107l-120.495227 120.495227A488.144291 488.144291 0 0 1 21.638269 512.161869z"
            // fill="#9EEBFF"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[6]
                  : showColor
                : Array.isArray(color)
                ? color[6]
                : color
            }
            p-id="5484"
          ></path>
          <path
            d="M512.149811 704.101168v127.959533a319.685566 319.685566 0 0 1-226.275107-93.623725l90.638002-90.638002A190.595724 190.595724 0 0 0 512.149811 704.101168z"
            // fill="#5F4A9E"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[6]
                  : showColor
                : Array.isArray(color)
                ? color[6]
                : color
            }
            p-id="5485"
          ></path>
          <path
            d="M285.874704 738.436976A319.685566 319.685566 0 0 0 512.149811 832.060701v170.61271a488.144291 488.144291 0 0 1-346.770334-143.741208z"
            // fill="#9D87E0"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[7]
                  : showColor
                : Array.isArray(color)
                ? color[7]
                : color
            }
            p-id="5486"
          ></path>
          <path
            d="M738.424918 738.436976A319.685566 319.685566 0 0 1 512.149811 832.060701v-127.959533a190.595724 190.595724 0 0 0 135.637105-56.302194z"
            // fill="#FF468C"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[8]
                  : showColor
                : Array.isArray(color)
                ? color[8]
                : color
            }
            p-id="5487"
          ></path>
          <path
            d="M738.424918 738.436976l120.495227 120.495227A488.144291 488.144291 0 0 1 512.149811 1002.673411v-170.61271a319.685566 319.685566 0 0 0 226.275107-93.623725z"
            // fill="#FFA1C8"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[9]
                  : showColor
                : Array.isArray(color)
                ? color[9]
                : color
            }
            p-id="5488"
          ></path>
          <path
            d="M704.08911 512.161869h127.959533a319.685566 319.685566 0 0 1-93.623725 226.275107l-90.638002-90.638002A190.595724 190.595724 0 0 0 704.08911 512.161869z"
            // fill="#F03049"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[10]
                  : showColor
                : Array.isArray(color)
                ? color[10]
                : color
            }
            p-id="5489"
          ></path>
          <path
            d="M832.048643 512.161869h170.612711a488.144291 488.144291 0 0 1-143.741209 346.770334l-120.495227-120.495227A319.685566 319.685566 0 0 0 832.048643 512.161869z"
            // fill="#FF636E"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[11]
                  : showColor
                : Array.isArray(color)
                ? color[11]
                : color
            }
            p-id="5490"
          ></path>
          <path
            d="M738.424918 285.886762A319.685566 319.685566 0 0 1 832.048643 512.161869h-127.959533a190.595724 190.595724 0 0 0-56.302194-135.637105z"
            // fill="#FE8205"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[12]
                  : showColor
                : Array.isArray(color)
                ? color[12]
                : color
            }
            p-id="5491"
          ></path>
          <path
            d="M1002.661354 512.161869h-170.612711a319.685566 319.685566 0 0 0-93.623725-226.275107l120.495227-120.495227A488.144291 488.144291 0 0 1 1002.661354 512.161869z"
            // fill="#FFA426"
            p-id="5492"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[13]
                  : showColor
                : Array.isArray(color)
                ? color[13]
                : color
            }
          ></path>
          <path
            d="M738.424918 285.886762l-90.638002 90.638002A190.595724 190.595724 0 0 0 512.149811 320.22257V192.263037a319.685566 319.685566 0 0 1 226.275107 93.623725z"
            // fill="#FFC247"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[14]
                  : showColor
                : Array.isArray(color)
                ? color[14]
                : color
            }
            p-id="5493"
          ></path>
          <path
            d="M858.920145 165.391535l-120.495227 120.495227A319.685566 319.685566 0 0 0 512.149811 192.263037V21.650326a488.144291 488.144291 0 0 1 346.770334 143.741209z"
            // fill="#FFFD78"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[15]
                  : showColor
                : Array.isArray(color)
                ? color[15]
                : color
            }
            p-id="5494"
          ></path>
          <path
            d="M934.757495 308.109067l38.38786-18.575459c-7.272367-14.928612-15.44045-29.857224-24.269658-44.401958l-36.383161 22.243633c8.12543 13.265138 15.525757 26.956808 22.264959 40.733784z"
            p-id="5495"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[16]
                  : showColor
                : Array.isArray(color)
                ? color[16]
                : color
            }
          ></path>
          <path
            d="M992.126019 334.020873l-39.987354 14.928612A466.071272 466.071272 0 0 1 980.396395 490.83528h-127.959533A337.983779 337.983779 0 0 0 768.068877 286.419926l90.616676-90.595349c8.99982 9.874211 17.615762 20.1323 25.741192 30.710288l33.82397-25.975785a516.231408 516.231408 0 0 0-44.146039-50.33075 511.838131 511.838131 0 0 0-798.595444 629.13437l36.340507-22.328939A468.139951 468.139951 0 0 1 43.434043 533.488458h128.151472a337.983779 337.983779 0 0 0 84.879823 204.202087L165.806009 828.349874c-9.042474-9.895537-17.829028-20.046993-25.911805-30.561001l-33.82397 25.975785a518.790599 518.790599 0 0 0 44.146039 50.330749 511.987417 511.987417 0 0 0 841.909746-540.074534zM165.635396 195.803251L256.230746 286.419926A337.983779 337.983779 0 0 0 171.884087 490.83528h-127.959533A464.919636 464.919636 0 0 1 165.635396 195.803251z m467.158928 437.003131A170.61271 170.61271 0 1 1 682.762522 512.161869a169.503728 169.503728 0 0 1-49.968198 120.644513z m-285.77629-255.620494A211.133229 211.133229 0 0 0 300.035559 490.83528h-85.412988a295.543868 295.543868 0 0 1 72.062543-173.982311z m300.107758-30.177123A211.133229 211.133229 0 0 0 533.4764 300.047617v-85.412989a295.543868 295.543868 0 0 1 173.982311 72.062544zM490.823222 299.940984a211.133229 211.133229 0 0 0-113.585412 47.153087l-60.396899-60.396899A295.543868 295.543868 0 0 1 490.823222 214.634628zM299.928926 533.488458a211.133229 211.133229 0 0 0 47.153088 113.585412l-60.3969 60.396899A295.543868 295.543868 0 0 1 214.622571 533.488458z m77.244905 143.826514A211.133229 211.133229 0 0 0 490.823222 724.276121v85.412988a295.543868 295.543868 0 0 1-173.982311-72.062543zM533.4764 724.382754a211.133229 211.133229 0 0 0 113.585412-47.153088l60.396899 60.3969A295.543868 295.543868 0 0 1 533.4764 809.689109z m204.138108-16.911985l-60.33292-60.33292A211.133229 211.133229 0 0 0 724.264063 533.488458h85.412989a295.543868 295.543868 0 0 1-72.062544 173.982311zM809.677052 490.83528h-85.306356a211.133229 211.133229 0 0 0-47.153087-113.585412l60.396899-60.396899A295.543868 295.543868 0 0 1 809.677052 490.83528zM533.4764 43.4461a465.282188 465.282188 0 0 1 294.669477 122.563906l-90.467389 90.46739A338.197045 338.197045 0 0 0 533.4764 171.576246z m-42.653178 0.511838v127.959533A338.175719 338.175719 0 0 0 286.407869 256.242803L195.791193 165.647454A464.919636 464.919636 0 0 1 490.823222 43.957938zM286.407869 768.080934A338.175719 338.175719 0 0 0 490.823222 852.427593v127.959533a465.175555 465.175555 0 0 1-295.032029-121.710842zM533.4764 980.877637V852.747492A338.410311 338.410311 0 0 0 737.891754 768.080934l90.616675 90.616676A465.602087 465.602087 0 0 1 533.4764 980.877637z m324.825274-152.719702l-90.46739-90.46739A337.983779 337.983779 0 0 0 852.714108 533.488458h128.151472a465.111575 465.111575 0 0 1-122.563906 294.669477z"
            p-id="5496"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[17]
                  : showColor
                : Array.isArray(color)
                ? color[17]
                : color
            }
          ></path>
        </svg>
      );
    case 'cat':
      return (
        <svg
          t="1591925532828"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2687"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M649.728 859.166l-3.072-3.072a63.307 63.307 0 0 0-60.838-15.36 251.302 251.302 0 0 1-68.066 9.758 257.807 257.807 0 0 1-71.59-10.24 53.097 53.097 0 0 0-61.379 24.034 55.145 55.145 0 0 0-4.096 46.562c6.144 15.36 18.402 27.106 34.274 31.714 33.25 10.24 67.524 15.36 102.791 15.36 35.84 0 71.108-5.12 104.87-15.872 15.36-5.12 27.618-16.866 33.762-31.714a53.91 53.91 0 0 0-3.584-46.05l-3.072-5.12z m54.212-444.988a248.2 248.2 0 0 1 44.514 58.308c11.746 20.962 19.938 43.971 25.058 67.523 5.12 24.034 26.081 41.412 50.145 42.466h2.018c15.872 0 30.72-7.168 40.96-18.974 10.722-12.77 14.818-29.124 11.234-44.996a354.424 354.424 0 0 0-36.322-97.19 342.83 342.83 0 0 0-64.451-83.877 53.338 53.338 0 0 0-43.972-14.306 53.399 53.399 0 0 0-38.882 25.058 54.302 54.302 0 0 0 9.698 65.958zM209.318 580.909c2.048 0 4.096 0 6.144-0.512a53.308 53.308 0 0 0 47.074-47.044 243.712 243.712 0 0 1 18.913-71.077 256.03 256.03 0 0 1 38.37-61.922c15.36-18.914 16.866-45.508 2.56-65.476-9.728-13.282-24.546-21.986-40.93-22.498a53.158 53.158 0 0 0-42.947 18.402 354.756 354.756 0 0 0-55.266 88.004A342.106 342.106 0 0 0 156.13 520.04c-2.048 16.384 3.614 32.226 14.848 43.972 10.722 11.294 24.034 16.896 38.34 16.896z m193.355-210.733c9.728 16.866 27.618 27.106 47.074 27.106H581.18c19.456 0 37.346-10.24 47.074-27.106l65.958-114.056c9.728-16.865 9.728-37.345 0-54.211L628.254 87.823c-9.728-16.866-27.618-27.106-47.074-27.106H449.747c-19.456 0-37.346 10.24-47.074 27.106L337.197 201.91a54.061 54.061 0 0 0 0 54.211l65.476 114.056z m24.546-141.161l44.002-76.74h88.485l43.972 76.74-43.972 76.71h-88.485l-43.972-76.71zM298.315 638.193c-9.698-16.866-27.618-27.106-47.043-27.106H119.808c-19.426 0-37.346 10.24-47.044 27.106L7.288 752.279a54.061 54.061 0 0 0 0 54.211l65.958 114.056c9.758 16.866 27.648 27.106 47.074 27.106h131.464c19.425 0 37.345-10.24 47.073-27.106l65.958-114.056c9.728-16.866 9.728-37.346 0-54.211l-66.47-114.086z m-24.034 141.191l-43.971 76.71h-88.486l-43.972-76.71 43.972-76.74h88.486l43.971 76.74z m741.678-19.937L950 645.36c-9.728-16.866-27.648-27.106-47.074-27.106H771.464c-19.426 0-37.346 10.24-47.044 27.106l-65.476 114.086a54.061 54.061 0 0 0 0 54.211l65.958 114.056c9.728 16.866 27.648 27.106 47.074 27.106h131.463c19.426 0 37.346-10.24 47.044-27.106l65.988-114.056a55.326 55.326 0 0 0-0.512-54.211z m-90.022 27.105l-43.972 76.71h-88.997l-44.002-76.71 43.971-76.74h88.516l44.484 76.74z"
            p-id="2688"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'dot':
      return (
        <svg
          t="1594710675065"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="1541"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            d="M480 480m-288 0a4.5 4.5 0 1 0 576 0 4.5 4.5 0 1 0-576 0Z"
            p-id="1542"
          ></path>
        </svg>
      );
    case 'oneModal':
      return (
        <svg
          t="1594710910524"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3506"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M410.709944 409.99607c0 8.636859 6.577147 15.616993 14.68863 15.616993 0.099503 0 0.159205 0 0.283584 0 3.024891 41.114632 35.385251 82.231255 74.930721 82.231255s71.937671-41.116622 74.967537-82.231255c0.079602 0 0.179105 0 0.263683 0 8.129394 0 14.706541-6.980134 14.706541-15.616993 0-6.335355-3.597033-11.783143-8.716461-14.201066 2.990065-9.240842 4.602013-19.126463 4.602013-29.415072 0-50.278857-38.388251-91.030304-85.823313-91.030304-47.390286 0-85.806397 40.751447-85.806397 91.030304 0 10.288608 1.633839 20.17423 4.599028 29.415072C414.259215 398.212926 410.709944 403.660715 410.709944 409.99607zM318.309484 653.633103l364.62072 0c4.422908 0 8.014965-3.557232 8.014965-7.995065l0-28.567306c0-2.139314-0.895527-4.233852-2.422898-5.731372-35.039975-34.015095-77.836208-58.020189-123.856338-69.517759-1.174135-0.606968-2.457724-0.975129-3.810964-0.975129l-4.159225 0c-1.33334 0-2.616928 0.32836-3.791064 0.950253-13.880666 7.442823-32.965338 11.721451-52.290807 11.721451-19.330444 0-38.375315-4.278628-52.275882-11.721451-1.16916-0.621894-2.440808-0.950253-3.774148-0.950253l-3.024891 0c-0.624879 0-1.251748 0.079602-1.857721 0.203981-47.206205 11.17916-91.109906 35.472813-126.937945 70.288907-1.555232 1.48757-2.422898 3.592058-2.422898 5.731372l0 28.567306C310.319395 650.075871 313.891552 653.633103 318.309484 653.633103zM709.50148 755.554008 291.739203 755.554008c-7.567202 0-13.738377 6.149284-13.738377 13.761262 0 7.582127 6.171175 13.716486 13.738377 13.716486l417.762277 0c7.582127 0 13.761262-6.134359 13.761262-13.716486C723.262743 761.703292 717.083607 755.554008 709.50148 755.554008zM907.587043 165.921223 759.456953 19.933433c-6.422918-6.375156-15.044851-9.885621-24.104598-9.885621L149.003169 10.047811c-18.985169 0-34.37828 15.35331-34.37828 34.338479l0 945.27336c0 18.970244 15.393111 34.343454 34.37828 34.343454l734.489226 0c18.965268 0 34.333504-15.373211 34.333504-34.343454l0-799.287559C917.8259 181.172046 914.159215 172.375982 907.587043 165.921223zM183.358564 955.30127 183.358564 78.721785l531.386723 0L714.745287 190.737267c0 11.378166 9.218951 20.617018 20.607068 20.617018l113.756785 0 0 743.946985L183.358564 955.30127z"
            p-id="3507"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'twoModal':
      return (
        <svg
          t="1594710975346"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="3634"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M935.875038 232.997248 730.025085 10.164552C724.022981 3.688207 715.605215 0 706.787308 0L370.250547 0c-48.980136 0-88.816326 39.838165-88.816326 88.801506l0 40.791586 63.318003 0L344.752224 88.801506c0-14.05431 11.445988-25.477575 25.497335-25.477575l310.167022 0 0 215.885076c0 8.165826 6.619605 14.785431 14.785431 14.785431l185.763897 0 0 478.245706c0 14.06419-11.445988 25.480539-25.500299 25.480539l-79.301879 0 0 63.325907 79.301879 0c48.965316 0 88.821266-39.841129 88.821266-88.806446L944.286876 254.481324C944.287864 246.500254 941.274462 238.839297 935.875038 232.997248zM709.988431 81.773857l168.740645 182.646755-168.740645 0L709.988431 81.773857zM530.617886 173.137248c-6.002104-6.476345-14.439631-10.181348-23.257537-10.181348L170.800864 162.955901c-48.960376 0-88.778782 39.836189-88.778782 88.796566l0 683.43271c0 48.980136 39.818405 88.816326 88.778782 88.816326l485.237787 0c48.960376 0 88.821266-39.836189 88.821266-88.816326L744.859916 417.417465c0-7.943526-2.993642-15.622268-8.417766-21.466292L530.617886 173.137248zM668.54674 415.747744l-142.489465 0L526.057274 261.507986 668.54674 415.747744zM656.038651 960.675595 170.798888 960.675595c-14.04937 0-25.457815-11.426228-25.457815-25.490419L145.341073 251.751478c0-14.051346 11.403504-25.477575 25.457815-25.477575l322.712655 0 2.973882 3.217918 0 201.017641c0 8.165826 6.616641 14.767647 14.785431 14.767647l170.264142 0 0 489.906091C681.534009 949.249366 670.088021 960.675595 656.038651 960.675595zM576.224 808.385162 229.216407 808.385162c-6.300481 0-11.413384 5.088204-11.413384 11.426228 0 6.298505 5.112904 11.401528 11.413384 11.401528l347.007593 0c6.318265 0 11.426228-5.103024 11.426228-11.401528C587.64924 813.473366 582.541276 808.385162 576.224 808.385162zM576.224 713.932292 229.216407 713.932292c-6.300481 0-11.413384 5.122784-11.413384 11.436108 0 6.298505 5.112904 11.386708 11.413384 11.386708l347.007593 0c6.318265 0 11.426228-5.088204 11.426228-11.386708C587.64924 719.055076 582.541276 713.932292 576.224 713.932292zM576.224 619.51499 229.216407 619.51499c-6.300481 0-11.413384 5.122784-11.413384 11.436108 0 6.298505 5.112904 11.411408 11.413384 11.411408l347.007593 0c6.318265 0 11.426228-5.112904 11.426228-11.411408C587.64924 624.652594 582.541276 619.51499 576.224 619.51499zM229.216407 550.102999l158.732197 0c6.315301 0 11.411408-5.098084 11.411408-11.396588s-5.096108-11.421288-11.411408-11.421288l-158.732197 0c-6.300481 0-11.413384 5.122784-11.413384 11.421288C217.800058 545.004915 222.914938 550.102999 229.216407 550.102999zM269.704677 362.163524c0 4.462799 3.401687 8.071966 7.589822 8.071966 0.052364 0 0.086944 0 0.1482 0 1.563017 21.256836 18.29481 42.513671 38.739509 42.513671 20.441735 0 37.193288-21.256836 38.759269-42.513671 0.03952 0 0.090896 0 0.136344 0 4.200979 0 7.599702-3.608179 7.599702-8.071966 0-3.277198-1.855465-6.091025-4.505283-7.342821 1.546221-4.776984 2.381082-9.889887 2.381082-15.207307 0-25.991335-19.848935-47.063415-44.371113-47.063415-24.504394 0-44.361233 21.071092-44.361233 47.063415 0 5.31742 0.842765 10.430324 2.379106 15.207307C271.539394 356.072499 269.704677 358.885338 269.704677 362.163524zM221.931877 488.117809l188.507575 0c2.282282 0 4.141699-1.834717 4.141699-4.129843l0-14.767647c0-1.106561-0.45942-2.190398-1.256737-2.964002-18.114993-17.583449-40.238306-29.997678-64.029363-35.943467-0.60268-0.31122-1.271557-0.496964-1.971061-0.496964l-2.148902 0c-0.686661 0-1.353561 0.165984-1.958217 0.487084-7.177825 3.848263-17.043013 6.06336-27.033676 6.06336-9.995603 0-19.841031-2.213122-27.02676-6.06336-0.60268-0.3211-1.259701-0.487084-1.951301-0.487084l-1.561041 0c-0.32604 0-0.650104 0.042484-0.960337 0.10374-24.408558 5.77684-47.104911 18.33433-65.627949 36.335703-0.805221 0.773605-1.251797 1.857441-1.251797 2.964002l0 14.767647C217.800058 486.283092 219.64762 488.117809 221.931877 488.117809z"
            p-id="3635"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'fulfill':
      return (
        <svg
          t="1594715476030"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4371"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M512 0C230.4 0 0 230.4 0 512s230.4 512 512 512c281.6 0 512-230.4 512-512S793.6 0 512 0zM838.4 371.2l-384 384C448 761.6 428.8 768 416 768c-12.8 0-25.6-6.4-38.4-12.8L147.2 524.8C128 505.6 128 467.2 147.2 448c19.2-19.2 57.6-19.2 76.8 0l192 192 345.6-345.6c19.2-19.2 57.6-19.2 76.8 0C864 313.6 864 345.6 838.4 371.2z"
            p-id="4372"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'borderColor': // 边框颜色
      return (
        <svg
          t="1593654578160"
          className="icon"
          viewBox="0 0 1028 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="2277"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M320 768H0V0h834v64H64v640h256z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="2278"
          ></path>
          <path
            d="M0 832h1024v192H0z"
            p-id="2279"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
          ></path>
          <path
            d="M1004.3 83.8c-26.4-26.4-68.9-26.4-95.2 0l-47.6 47.8 95.2 95.5 47.6-47.7c26.3-26.5 26.3-69.2 0-95.6zM812.4 178.8L526.8 465.2l95.2 95.5 285.6-286.4zM384 704l190.4-95.5-95.2-95.5z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="2280"
          ></path>
        </svg>
      );
    case 'borderType': // 线段类型
      return (
        <svg
          t="1593658444933"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="10034"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M153.6 204.8h716.8v51.2H153.6zM153.6 409.6h716.8v102.4H153.6zM153.6 665.6h716.8v153.6H153.6z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="10035"
          ></path>
        </svg>
      );
    case 'add': // 添加按钮
      return (
        <svg
          t="1593744781834"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4559"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M546.133333 477.866667h136.533334v68.266666h-136.533334v136.533334h-68.266666v-136.533334h-136.533334v-68.266666h136.533334v-136.533334h68.266666v136.533334z m-34.133333 341.333333a307.2 307.2 0 1 0 0-614.4 307.2 307.2 0 0 0 0 614.4z m0 68.266667C304.64 887.466667 136.533333 719.36 136.533333 512S304.64 136.533333 512 136.533333s375.466667 168.106667 375.466667 375.466667-168.106667 375.466667-375.466667 375.466667z"
            p-id="4560"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'omit': // 三个点省略
      return (
        <svg
          t="1593759127839"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="4737"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M221 592c-44.183 0-80-35.817-80-80s35.817-80 80-80 80 35.817 80 80-35.817 80-80 80z m291 0c-44.183 0-80-35.817-80-80s35.817-80 80-80 80 35.817 80 80-35.817 80-80 80z m291 0c-44.183 0-80-35.817-80-80s35.817-80 80-80 80 35.817 80 80-35.817 80-80 80z"
            p-id="4738"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
          ></path>
        </svg>
      );
    case 'insert': // 插入图标
      return (
        <svg
          t="1593763080764"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="5506"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M251.733333 917.333333h-128c-12.8 0-21.333333-8.533333-21.333333-21.333333V341.333333c0-12.8 8.533333-21.333333 21.333333-21.333333h128c12.8 0 21.333333 8.533333 21.333334 21.333333v554.666667c0 12.8-8.533333 21.333333-21.333334 21.333333zM891.733333 917.333333h-128c-12.8 0-21.333333-8.533333-21.333333-21.333333V341.333333c0-12.8 8.533333-21.333333 21.333333-21.333333h128c12.8 0 21.333333 8.533333 21.333334 21.333333v554.666667c0 12.8-8.533333 21.333333-21.333334 21.333333z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="5507"
          ></path>
          <path
            d="M573.866667 597.333333h-132.266667c-10.666667 0-19.2-8.533333-19.2-19.2V125.866667c0-10.666667 8.533333-19.2 19.2-19.2h132.266667c10.666667 0 19.2 8.533333 19.2 19.2v452.266666c0 10.666667-8.533333 19.2-19.2 19.2z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[1]
                  : showColor
                : Array.isArray(color)
                ? color[1]
                : color
            }
            p-id="5508"
          ></path>
          <path
            d="M524.8 789.333333l140.8-179.2a21.333333 21.333333 0 0 0-17.066667-34.133333H366.933333c-17.066667 0-27.733333 21.333333-17.066666 34.133333L490.666667 789.333333c8.533333 10.666667 25.6 10.666667 34.133333 0z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[2]
                  : showColor
                : Array.isArray(color)
                ? color[2]
                : color
            }
            p-id="5509"
          ></path>
        </svg>
      );
    case 'ren':
      return (
        <svg
          t="1593763260063"
          className="icon"
          viewBox="0 0 1024 1024"
          version="1.1"
          xmlns="http://www.w3.org/2000/svg"
          p-id="5850"
          width={width ? width : '16'}
          style={{ ...style, cursor: 'pointer' }}
          height={height ? height : '16'}
          onMouseEnter={mouseEnterColor}
          onMouseLeave={mouseLeaveColor}
        >
          <path
            d="M163.84 619.52l-57.6 219.52a38.4 38.4 0 0 0 8.96 35.84 37.76 37.76 0 0 0 25.6 10.24h14.72L355.84 832h6.4l551.68-576a92.8 92.8 0 0 0 24.32-74.24 112.64 112.64 0 0 0-32-78.08l-52.48-50.56a106.24 106.24 0 0 0-74.88-32.64 88.96 88.96 0 0 0-64 26.24l-550.4 571.52z m694.4-424.32l-54.4 56.32-88.96-93.44 53.12-56.96a25.6 25.6 0 0 1 34.56 0l53.12 53.76a30.72 30.72 0 0 1 8.32 20.48 22.4 22.4 0 0 1-5.76 16zM261.76 628.48l394.88-411.52 89.6 94.08-394.88 410.88z m-73.6 167.68l28.8-109.44L293.76 768z m693.12-376.32M938.88 1001.6h-832a35.2 35.2 0 0 1-35.2-35.2 34.56 34.56 0 0 1 35.2-35.2h832a35.2 35.2 0 0 1 35.2 35.2 35.2 35.2 0 0 1-35.2 35.2z"
            fill={
              showColor
                ? Array.isArray(showColor)
                  ? showColor[0]
                  : showColor
                : Array.isArray(color)
                ? color[0]
                : color
            }
            p-id="5851"
          ></path>
        </svg>
      );

    default:
      return <>缺乏匹配项</>;
  }
}
