import React, { Fragment } from 'react';
import { Card, Form, Input, Select, Switch, Modal, Button, Checkbox, Col, Row, Icon, Tooltip } from 'antd';
import { connect } from 'dva';
import { withPropsAPI } from 'gg-editor';
import upperFirst from 'lodash/upperFirst';
import styles from './index.less';
import textImg from '../assets/down.png'

const { Item } = Form;
const { Option } = Select;
const options = [
    {
        id: 'static',
        name: '流程发起人'
    },
    {
        id: 'dynamicAllocation',
        name: '动态分配'
    },
    {
        id: 'idm',
        name: '候选人'
    },
    {
        id: 'group',
        name: '分组'
    },

]
let golbalInfo = {}//获取信息

const inlineFormItemLayout = {
    labelCol: {
        sm: { span: 8 },
    },
    wrapperCol: {
        sm: { span: 16 },
    },
};

@connect()
class DetailForm extends React.Component {
    constructor(props) {
        super(props)
        // console.log(69554154, this.props.type)
        this.state = {
            values: {},
            checked: true,//判断是否打开监听器
            judge: true,//判断条件
            initialFp: false,//初始分配人
            visible: false,
            optionValue: 'static',//分配人初始值
            idm: [],
            group: [],
            searchList: [],//候选人列表数据
            searchGroupList: [],//分组列表数据
            dynamicAllocation: [],
            candidateUsers: [],
            openModel: false,
            activity: true,
            expand: false,//监听器下展开点击控制
            idRender: true,//是否再次渲染
            isCancel: false,//是否取消添加
            IsADD: false,//是否有另外的新增
            isAddlisner: false,//是否新增监听器
        }
    }

    get item() {
        const { propsAPI } = this.props;
        return propsAPI.getSelected()[0];//获取当前选中图形
    }

    //表单提交函数
    handleSubmit = (e) => {
        if (e && e.preventDefault) {
            e.preventDefault();
        }

        const { form, propsAPI } = this.props;
        const { getSelected, executeCommand, update } = propsAPI;

        setTimeout(() => {
            form.validateFieldsAndScroll((err, values) => {
                if (err) {
                    return;
                }
                values = {
                    ...values,
                    static: values.s
                }
                this.valueDistriBution = values.distriBution
                this.setState({
                    values: values
                }, () => {
                    console.log(this.state.values)
                    this.setallmasg(this.state.values)
                })

                const item = getSelected()[0];
                if (!item) {
                    return;
                }

                executeCommand(() => {
                    update(item, {
                        ...values,
                    });
                });
            });
        }, 0);
    };


    // 修改属性
    setallmasg = (values) => {
        let data = this.props.data
        let flag = true//判断是否修改的是最外层的数据
        data.model.childShapes = data.model.childShapes.map(item => {
            //判断节点
            if (item.resourceId == values.id) {
                //判断是否是线条
                if (item.stencil.id === 'SequenceFlow') {
                    item.properties.overrideid = values.overrideid
                    item.properties.name = values.label
                    if (values.conditions !== '') {
                        // console.log(values.conditions)
                        item.properties.conditionsequenceflow = {
                            expression: {
                                "type": "static",
                                staticValue: values.conditions
                            }
                        }
                    }
                    flag = false
                } else {
                    if (!item?.properties) {
                        item.properties = {
                            "overrideid": "",
                            "name": '',
                            "documentation": "",
                            "executionlisteners": "",
                            "initiator": "userId",
                            "formkeydefinition": "",
                            "formreference": "",
                            "formproperties": ""
                        }
                    }
                    item.properties.overrideid = values.overrideid
                    item.properties.name = values.label
                    flag = false

                    //判断是否设置监听器
                    if (values.listener && this.state.isAddlisner) {
                        // console.log('设置监听器')
                        this.handleFormReset()
                        if (item.properties.executionlisteners.executionListeners == undefined) {
                            item.properties.executionlisteners = { executionListeners: [] }
                        }
                        item.properties.executionlisteners.executionListeners.push({//添加监听者到数组
                            "event": values.things,
                            "implementation": values.expression !== '' ? values.expression : values.category !== '' ? values.category : '',
                            "className": values.category,
                            "expression": values.expression,
                        })
                        this.setState({
                            isAddlisner: false
                        })
                    } else if (values.listener && !this.state.isAddlisner) {
                        console.log('监听器个数不变')
                    } else {
                        // console.log('没有监听器')
                        item.properties.executionlisteners = ''
                    }

                    //判断是否设置分配人
                    if (this.state.isCancel && this.state.openModel == true) {

                        item.properties.usertaskassignment = ''
                        if (values.distriBution == 'static') {
                            item.properties.usertaskassignment = {
                                assignment: {
                                    type: this.state.optionValue,
                                    assignee: '${ userId }'
                                }
                            }
                        } else if (values.distriBution == 'idm') {
                            if (this.state.idm.length > 0) {
                                item.properties.usertaskassignment = {
                                    assignment: {
                                        type: this.state.optionValue,
                                        idm: {
                                            type: "users",
                                            candidateUsers: this.state.idm
                                        }
                                    }
                                }
                            } else {
                                item.properties.usertaskassignment = ''
                            }

                        } else if (values.distriBution == 'group') {
                            console.log(this.state.group)
                            if (this.state.group.length > 0) {
                                item.properties.usertaskassignment = {
                                    assignment: {
                                        type: this.state.optionValue,
                                        idm: {
                                            type: "groups",
                                            candidateGroups: this.state.group
                                        }
                                    }
                                }
                            } else {
                                item.properties.usertaskassignment = ''
                            }

                        } else if (values.distriBution == 'dynamicAllocation') {
                            console.log(values.dynamicAllocation)
                            if (!!values.dynamicAllocation.length) {
                                item.properties.usertaskassignment = {
                                    assignment: {
                                        type: 'static',
                                        candidateUsers: [{
                                            value: values.dynamicAllocation,
                                            $$hashKey: ""
                                        }]
                                    }
                                }
                            } else {
                                item.properties.usertaskassignment = ''
                            }
                        }
                    } else {
                        console.log('发起者确定或者没有修改')
                    }
                    //判断定时器时间
                    if (values.activity !== undefined) {
                        item.properties.timerdatedefinition = values.timer
                        item.properties.cancelactivity = values.activity
                    }
                    //添加表单键
                    item.properties.formkeydefinition = values.formkey
                    return item
                }
            }
            return item
        })
        if (flag) {
            data.name = values.name
            data.key = values.key
            data.model.modelid = this.props.data.modelId
            data.model.properties.process_id = values.key
            data.model.properties.name = values.name
            data.model.properties.process_author = values.author
            data.model.properties.process_namespace = values.namespace
        }
        // console.log(data)
        const newData = this.newData = this.deformation(data)//把新的数据转换为能展示的数据
        // console.log(newData)
        // newData.edges[8].controlPoints = [{ x: 3000, y: 1000 }]
        const type = 'masg'
        this.props.getprocess(data, newData, type);
    }

    //把线和节点重新构建
    getNewMap = (itemMap, id) => {
        let data = this.props.data
        //初始化所有节点
        let nodes = itemMap._nodes.map((item) => {
            if (item.model.shape === 'flow-circle' || item.model.shape === 'EndNoneEvent') {
                item = {
                    "resourceId": item.model.id,
                    "properties": {
                        "overrideid": "",
                        "name": item.model.label,
                        "documentation": "",
                        "executionlisteners": "",
                        "initiator": "userId",
                        "formkeydefinition": "",
                        "formreference": "",
                        "formproperties": ""
                    },
                    "stencil": {
                        "id": item.model.shape
                    },
                    "childShapes": [],
                    "outgoing": [],
                    "bounds": {
                        "lowerRight": {
                            "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                            "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                        },
                        "upperLeft": {
                            "x": Number(item.model.x),
                            "y": Number(item.model.y)
                        }
                    },
                    "dockers": []
                }
            } else if (item.model.shape === 'UserTask') {
                item = {
                    "resourceId": item.model.id,
                    "properties": {
                        "overrideid": "",
                        "name": item.model.label,
                        "documentation": "",
                        "asynchronousdefinition": "false",
                        "exclusivedefinition": "false",
                        "executionlisteners": "",
                        "multiinstance_type": "None",
                        "multiinstance_cardinality": "",
                        "multiinstance_collection": "",
                        "multiinstance_variable": "",
                        "multiinstance_condition": "",
                        "isforcompensation": "false",
                        "usertaskassignment": '',
                        "formkeydefinition": "",
                        "formreference": "",
                        "duedatedefinition": "",
                        "prioritydefinition": "",
                        "formproperties": "",
                        "tasklisteners": "",
                        "skipexpression": "",
                        "nodetype": "",
                        "iseditdata": ""
                    },
                    "stencil": {
                        "id": item.model.shape
                    },
                    "childShapes": [],
                    "outgoing": [],
                    "bounds": {
                        "lowerRight": {
                            "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                            "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                        },
                        "upperLeft": {
                            "x": Number(item.model.x),
                            "y": Number(item.model.y)
                        }
                    },
                    "dockers": []
                }
            } else if (item.model.shape === 'StartNoneEvent') {
                item = {
                    "resourceId": item.model.id,
                    "properties": {
                        "overrideid": "",
                        "name": item.model.label,
                        "documentation": "",
                        "executionlisteners": "",
                        "initiator": "userId",
                        "formkeydefinition": "",
                        "formreference": "",
                        "formproperties": ""
                    },
                    "stencil": {
                        "id": item.model.shape
                    },
                    "childShapes": [],
                    "outgoing": [],
                    "bounds": {
                        "lowerRight": {
                            "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                            "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                        },
                        "upperLeft": {
                            "x": Number(item.model.x),
                            "y": Number(item.model.y)
                        }
                    },
                    "dockers": []
                }
            } else if (item.model.shape === 'BoundaryTimerEvent') {
                // this.bindTimer(data)
                item = {
                    "resourceId": item.model.id,
                    "properties": {
                        "overrideid": "",
                        "name": item.model.label,
                        "documentation": "",
                        "timercycledefinition": "",
                        "timerdatedefinition": "",
                        "timerdurationdefinition": "",
                        "timerenddatedefinition": "",
                        "cancelactivity": true
                    },
                    "stencil": {
                        "id": item.model.shape
                    },
                    "childShapes": [],
                    "outgoing": [],
                    "bounds": {
                        "lowerRight": {
                            "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                            "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                        },
                        "upperLeft": {
                            "x": Number(item.model.x),
                            "y": Number(item.model.y)
                        }
                    },
                    "dockers": []
                }
            } else if (item.model.shape === 'ExclusiveGateway') {
                item = {
                    "resourceId": item.model.id,
                    "properties": {
                        "overrideid": "",
                        "name": item.model.label,
                        "documentation": "",
                        "asynchronousdefinition": "false",
                        "exclusivedefinition": "false",
                        "sequencefloworder": ""
                    },
                    "stencil": {
                        "id": item.model.shape
                    },
                    "childShapes": [],
                    "outgoing": [],
                    "bounds": {
                        "lowerRight": {
                            "x": Number(item.model.x) + Number(item.model.size.split("*")[0]),
                            "y": Number(item.model.y) + Number(item.model.size.split("*")[1])
                        },
                        "upperLeft": {
                            "x": Number(item.model.x),
                            "y": Number(item.model.y)
                        }
                    },
                    "dockers": []
                }
            }
            return item
        })
        //把已经有的节点重新赋值
        data.model.childShapes.map(node => {
            nodes = nodes.map((item) => {
                if (item.resourceId === node.resourceId) {
                    let flag = true
                    //获取节点是的outgoing是否有定时器节点的id
                    node.outgoing.map(timerId => {
                        data.model.childShapes.map(timer => {
                            if (timer.stencil.id === 'BoundaryTimerEvent' && timerId.resourceId === timer.resourceId) {
                                // console.log(timerId, node.outgoing)
                                node.outgoing = []
                                node.outgoing.push(timerId)
                                flag = false
                            }
                        })
                    })
                    if (flag) {
                        node.outgoing = []
                    }
                    //清空节点定的bounds的值
                    node.bounds = item.bounds
                    return item = node
                }
                return item
            })
        })
        let edges = itemMap._edges.map((item) => {
            let conditions = ''
            if (!!item.model.conditions) {
                conditions = {
                    expression: {
                        "type": "static",
                        staticValue: item.model.conditions
                    }
                }
            }
            return item = {
                "resourceId": item.id,
                "properties": {
                    "overrideid": item.model.overrideid,
                    "name": item.model.label,
                    "documentation": "",
                    "conditionsequenceflow": conditions,
                    "executionlisteners": "",
                    "defaultflow": "false",
                    "skipexpression": "",
                    "sequence_flow_text_x": "",
                    "targetAnchor": item.model.targetAnchor !== undefined ? item.model.targetAnchor : '',
                    "sourceAnchor": item.model.sourceAnchor !== undefined ? item.model.sourceAnchor : ''
                },
                "stencil": {
                    "id": "SequenceFlow"
                },
                "childShapes": [],
                "outgoing": [
                    {
                        "resourceId": item.model.target
                    }
                ],
                "bounds": {
                    "lowerRight": item.model.source,
                    "upperLeft": item.model.target
                },
                "dockers": [{ x: item.model.sourceAnchor * 50, y: item.model.sourceAnchor * 40 }, { x: item.model.targetAnchor * 50, y: item.model.targetAnchor * 40 }],
                "target": {
                    "resourceId": item.model.target
                }
            }
        })
        //把已有的线重新赋值
        data.model.childShapes.map(edge => {
            edges = edges.map((item) => {
                if (item.resourceId === edge.resourceId) {
                    if (item.resourceId == id) {
                        return item
                    }
                    return item = edge
                }
                return item
            })
        })
        data.model.childShapes = edges
        if (itemMap._edges.length == 0) {
            data.model.childShapes = nodes
            this.props.getprocess(data);
        } else {
            this.summary(nodes, itemMap._edges)
        }
    }

    //结合线把nodes的指向完善
    summary = (nodes, edges) => {
        const { id } = this.item.getModel();
        let stencil = ''
        //得到节点的stencil
        nodes.map(item => {
            if (item.resourceId === id) {
                stencil = item.stencil.id
            }
        })

        if (edges.length > 0 && nodes.length > 0) {
            //绑定线和节点
            edges.map(item => {
                nodes = nodes.map(node => {
                    if (node.resourceId === item.model.source) {
                        node.outgoing.push({ resourceId: item.id })
                        return node
                    } else {
                        return node
                    }
                })
            })
            //是否移出定时器
            if (stencil === 'BoundaryTimerEvent') {
                // console.log(this.myNode, nodes)
                nodes.map(item => {
                    item.outgoing = item.outgoing.filter(delItem => {
                        if (!!this.myNode && delItem.resourceId !== this.myNode.resourceId) {
                            return delItem
                        }
                    })
                })
            }
            //是否绑定定时器到节点上
            if (stencil === 'BoundaryTimerEvent') {
                nodes.map(item => {
                    if (item.stencil.id === 'UserTask') {
                        nodes.map(timer => {
                            if (timer.stencil.id === 'BoundaryTimerEvent') {
                                const w = item.bounds.upperLeft.x + 50 - timer.bounds.upperLeft.x - 36
                                const h = item.bounds.upperLeft.y + 40 - timer.bounds.upperLeft.y - 36
                                if (-40 < w && w < 60 && -40 < h && h < 50) {
                                    console.log(w, h, item.properties.name)
                                    item.outgoing.push({ resourceId: timer.resourceId })
                                    timer.dockers = [{
                                        x: w,
                                        y: h
                                    }]
                                }
                            }
                        })
                    }
                })
            }
            let data = this.props.data
            data.model.childShapes = [...data.model.childShapes, ...nodes]
            let type = 'node'
            //判断是否是一个新边
            if (this.newEdge) {
                type = 'newEdge'
            }
            //判断是否移动的带有定时器的节点
            let flag = false
            if (this.stencil == 'UserTask') {
                data.model.childShapes.map(item => {
                    this.myNode.outgoing.map(outgoingitem => {
                        if (item.resourceId == outgoingitem.resourceId && item.stencil.id == 'BoundaryTimerEvent') {
                            flag = true
                        }
                    })
                })
            }
            // console.log(flag)
            const isGetEvent = !!this.props.getEvent
            if (this.stencil == 'UserTask' && flag && !isGetEvent) {
                type = 'stencilNode'
                // console.log(12566)
            }
            const newData = this.deformation(data)//把新的数据转换为能展示的数据
            // console.log(data, newData)
            this.props.getprocess(data, newData, type);
        }
    }
    //把新的数据转换为能展示的数据
    deformation = (data) => {
        // console.log(data)
        const arr = {
            nodes: [],
            edges: []
        }
        data.model.childShapes.map(item => {
            if (item.stencil.id == "StartNoneEvent") {
                const obj = {
                    type: 'node',
                    size: '55*55',
                    shape: 'StartNoneEvent',
                    label: item?.properties?.name ? item.properties.name : '',
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "UserTask") {
                const obj = {
                    type: 'node',
                    size: '60*48',
                    shape: 'UserTask',
                    // color: '#578586',
                    label: item.properties.name,
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "SequenceFlow") {
                data.model.childShapes.map(edge => {
                    if (edge.outgoing.length > 0) {
                        edge.outgoing.map(dome => {
                            if (dome.resourceId == item.resourceId) {
                                let staticValue = item?.properties?.conditionsequenceflow?.expression?.staticValue
                                const obj = {
                                    source: edge.resourceId,
                                    target: item.target.resourceId,
                                    label: item.properties.name,
                                    index: 1,
                                    style: {
                                        lineWidth: 4,
                                    },
                                    id: item.resourceId,
                                    shape: "flow-polyline",
                                    overrideid: item.properties.overrideid,
                                    conditions: staticValue ? staticValue : '',
                                    static: '',
                                    controlPoints: [],
                                    targetAnchor: item.properties.targetAnchor !== undefined ? item.properties.targetAnchor : '',
                                    sourceAnchor: item.properties.sourceAnchor !== undefined ? item.properties.sourceAnchor : ''
                                }
                                arr.edges.push(obj)
                            }
                        })
                    }
                })
            } else if (item.stencil.id == "EndNoneEvent") {
                const obj = {
                    type: 'node',
                    size: '55*55',
                    shape: 'EndNoneEvent',
                    label: item.properties.name,
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "ExclusiveGateway") {
                const obj = {
                    type: 'node',
                    size: '55*55',
                    shape: 'ExclusiveGateway',
                    label: '选择',
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                // console.log(obj)
                arr.nodes.push(obj)
            } else if (item.stencil.id == "BoundaryTimerEvent") {
                let obj = {
                    type: 'node',
                    size: '55*55',
                    shape: 'BoundaryTimerEvent',
                    label: '计时器',
                    x: item.bounds.upperLeft.x,
                    y: item.bounds.upperLeft.y,
                    id: item.resourceId,
                }
                data.model.childShapes.map(node => {
                    if (node.outgoing.length > 0) {
                        node.outgoing.map(timer => {
                            if (timer.resourceId === item.resourceId) {
                                item.bounds.upperLeft = {
                                    x: node.bounds.upperLeft.x + 45,
                                    y: node.bounds.upperLeft.y + 39,
                                }
                                item.bounds.lowerRight = {
                                    x: node.bounds.lowerRight.x - 10,
                                    y: node.bounds.lowerRight.y - 16,
                                }
                                obj = {
                                    type: 'node',
                                    size: '55*55',
                                    shape: 'BoundaryTimerEvent',
                                    label: '计时器',
                                    x: node.bounds.upperLeft.x + 45,
                                    y: node.bounds.upperLeft.y + 39,
                                    id: item.resourceId,
                                }
                                // console.log(obj)

                            }
                        })
                    }
                })
                arr.nodes.push(obj)
            }
        })
        return arr
    }
    //固定定时器的位子
    bindTimer = (nodes) => {
        nodes.map(item => {
            if (item.outgoing.length > 0) {
                item.outgoing.map(outgoingid => {
                    nodes.map(timer => {
                        // { timer.stencil.id === 'BoundaryTimerEvent' ? console.log(outgoingid["resourceId "], timer.resourceId, 32555585) : 3655855 }
                        if (timer.stencil.id === 'BoundaryTimerEvent' && outgoingid["resourceId "] === timer.resourceId) {
                            const w = item.bounds.upperLeft.x + 50 - timer.bounds.upperLeft.x - 18
                            const h = item.bounds.upperLeft.y + 40 - timer.bounds.upperLeft.y - 18
                            console.log(w, h, item.properties.name)
                            timer.bounds.upperLeft = {
                                x: item.bounds.upperLeft.x - w,
                                y: item.bounds.upperLeft.y - h
                            }
                            // console.log(timer.bounds.upperLeft)
                        }
                    })
                })
            }
        })
    }
    //是否打开监听器
    onChange = (checked) => {
        // console.log('change事件')
        this.checked = checked
        this.setState({
            checked: checked,
            judge: false
        })
        if (!checked) {
            // console.log(!checked)
            this.handleSubmit()
        }
    }
    //监听器的下拉选项
    listenerSelect = () => {
        return (
            <Select style={{ width: '160px' }}>
                <Option value="start">开始</Option>
                <Option value="end">结束</Option>
                <Option value="take">任务中</Option>
            </Select>
        )
    }
    //监听器开关
    switch = () => {
        let numlisners = this.myNode?.properties?.executionlisteners?.executionListeners?.length
        return (<>
            <Switch checkedChildren="开" unCheckedChildren="关" defaultChecked={this.checked ? true : false} onChange={this.onChange} />
            {numlisners ? numlisners + '个监听器' : ''}
        </>
        )
    }
    //展开点击事件
    toggleForm = () => {
        const { expand } = this.state;
        this.setState({ expand: !expand });
    }
    //重置表单
    handleFormReset = () => {
        const { form } = this.props;
        form.resetFields();
    }
    //删除表单
    deleteLiseen = (index) => {
        this?.myNode?.properties?.executionlisteners?.executionListeners?.splice(index, 1);
        this.setState({
            idRender: true
        })
    }
    //监听器的box
    renderSimpleForm = (golbalInfo) => {
        const {
            form: { getFieldDecorator },
        } = this.props;
        // console.log(558565, this.myNode)
        const { label, id, detail, shape, userId, listener, timer, activity, category, things, expression } = golbalInfo
        return (
            // <Form onSubmit={this.handleSearch} layout="inline">
            <Row className={styles.myRow} gutter={{ md: 8, lg: 24, xl: 48 }} >
                <Item label="事件" {...inlineFormItemLayout}>
                    {getFieldDecorator('things', {
                        initialValue: things,
                    })(this.listenerSelect())}
                </Item>
                <Item label="类" {...inlineFormItemLayout}>
                    {getFieldDecorator('category', {
                        initialValue: category,
                    })(<Input />)}
                </Item>
                <Item label="表达式" {...inlineFormItemLayout}>
                    {getFieldDecorator('expression', {
                        initialValue: expression,
                    })(<Input />)}
                </Item>
                <Col md={8} sm={24} className={styles.myCol} style={{ paddingLeft: '24px', paddingRight: '10px' }}>
                    <span className={styles.submitButtons}>
                        <Button type="primary" htmlType="submit" onClick={() => { this.IsLisenner() }}>
                            保存
                  </Button>
                        <Button style={{ marginLeft: 8 }} onClick={this.handleFormReset}>
                            重置
                  </Button>
                        <a style={{ marginLeft: 8 }} onClick={this.toggleForm}>
                            {this.state.expand ? <span>关闭</span> : <span>展开</span>}
                            <Icon type={this.state.expand ? 'down' : 'right'} />
                        </a>
                    </span>
                    {this.state.expand ?
                        <div>
                            {this?.myNode?.properties?.executionlisteners?.executionListeners?.map((item, index) => {
                                return <div key={index}>
                                    事件 : <span className={styles.mySpen}>{item.event}</span>
                                    {item.expression.length > 0 || item.className.length > 0 ?
                                        <Tooltip title={item.expression.length > 0 ? item.expression : item.className}>
                                            <span
                                                style={{ display: "inline-block", width: '83px', overflow: 'hidden', whiteSpace: 'nowrap', textOverflow: 'ellipsis', verticalAlign: 'bottom' }}>实现
                                            : {item.expression.length > 0 ? item.expression : item.className}
                                            </span>
                                        </Tooltip>
                                        : ''}
                                    <Button type="danger" size="small" style={{ marginLeft: 3 }} onClick={() => { this.deleteLiseen(index) }}> 删除</Button>
                                </div>
                            }
                            )}
                        </div> : ''}
                </Col>
            </Row>
            // </Form>
        );
    }
    //判断是否添加监听器
    IsLisenner = () => {
        this.setState({
            isAddlisner: true
        }, () => {
            if (this.state.isAddlisner) {
                this.handleSubmit()
            }
        })
    }

    //分配人模态框
    modal = () => {
        // console.log(this.myNode)
        const { form } = this.props;
        const { initialFp, IsADD } = this.state
        const type = this.myNode?.properties?.usertaskassignment?.assignment?.type
        // console.log(type)

        let num2 = ''//流程发起人的判断
        //确定展示的分配人选项
        let optionValue = '' //确定是类别

        //个数判断
        //候选人个数
        let num = this.usertaskassignment?.assignment?.idm?.candidateUsers ? this.usertaskassignment.assignment.idm.candidateUsers.length : ''
        if (this.state.idm.length > 0 || this.state.isCancel) {
            num = this.state.idm.length
        }
        //动态分配个数
        let num1 = this.usertaskassignment?.assignment?.candidateUsers ? this.usertaskassignment.assignment.candidateUsers.length : ''
        if (this.state.dynamicAllocation.length > 0 || this.state.isCancel) {
            num1 = 1
            dynamicAllocation = this.state.dynamicAllocation[0]?.value
        }
        //分组个数
        let num3 = this.usertaskassignment?.assignment?.idm?.candidateGroups ? this.usertaskassignment.assignment.idm.candidateGroups.length : ''
        if (this.state.group.length > 0 || this.state.isCancel) {
            num3 = this.state.group.length
        }

        //当动态分配时获取值
        let dynamicAllocation = ''
        if (!!num1) {
            dynamicAllocation = this.state.dynamicAllocation[0]?.value
        }

        //类型判断
        if (!initialFp && type) {
            optionValue = type ? type : this.state.optionValue
            if (optionValue == 'static' && this.myNode?.properties?.usertaskassignment?.assignment?.candidateUsers) {//做动态分配人的逻辑
                optionValue = 'dynamicAllocation'
                if (!this.myNode?.properties?.usertaskassignment?.assignment?.candidateUsers) {
                    optionValue = 'static'
                }
            } else if (optionValue == 'idm' && this.myNode?.properties?.usertaskassignment?.assignment?.idm?.candidateUsers) {//做候选人的逻辑
                optionValue = 'idm'
                if (!this.myNode?.properties?.usertaskassignment?.assignment?.idm?.candidateUsers) {
                    optionValue = 'static'
                }
            } else if (optionValue == 'static' && this.myNode?.properties?.usertaskassignment?.assignment?.assignee) {
                optionValue = 'static'
                //流程发起人
                num2 = '流程发起人'
            } else if (optionValue == 'idm' && this.myNode?.properties?.usertaskassignment?.assignment?.idm?.candidateGroups) {
                optionValue = 'group'
            }
        } else {
            // console.log(2)
            // console.log(initialFp, this.valueDistriBution)
            //清空个数
            if (IsADD) {
                num = num1 = num2 = num3 = ''
            }
            //判断转化类型和个数
            if (!initialFp && !type) {//当初始进来和type没有的时候进入的判断
                optionValue = 'static'
            } else if (initialFp && this.valueDistriBution == 'static') {
                optionValue = 'static'
                this.valueDistriBution = ''
                //流程发起人
                num2 = '流程发起人'
                num = num1 = num3 = ''
            } else if (initialFp && this.valueDistriBution == 'dynamicAllocation') {
                optionValue = 'dynamicAllocation'
                // this.valueDistriBution = ''
                if (this.state.dynamicAllocation.length > 0 || this.state.isCancel) {
                    num1 = 1
                    console.log(this.state.dynamicAllocation[0]?.value)
                    dynamicAllocation = this.state.dynamicAllocation[0]?.value
                }
                num2 = num = num3 = ''
            } else if (initialFp && this.valueDistriBution == 'idm') {
                optionValue = 'idm'
                // this.valueDistriBution = ''
                if (this.state.idm.length > 0 || this.state.isCancel) {
                    num = this.state.idm.length
                }
                num2 = num1 = num3 = ''
            } else if (initialFp && this.valueDistriBution == 'group') {
                optionValue = 'group'
                // this.valueDistriBution = ''
                if (this.state.group.length > 0 || this.state.isCancel) {
                    num3 = this.state.group.length
                }
                num2 = num1 = num = ''
            } else {
                optionValue = this.state.optionValue
            }
        }
        //参数配置
        const search = ''
        const defaultperson = 'userId'
        // console.log(optionValue)
        return (
            <div>
                <Button type="primary" onClick={() => { this.showModal(optionValue) }}>分配</Button>
                {!!num ? num + '个候选人' : ''}
                {!!num1 ? num1 + '动态分配' : ''}
                {!!num2 ? num2 : ''}
                {!!num3 ? num3 + '个分组' : ''}
                <Modal
                    title="分配"
                    visible={this.state.visible}
                    onOk={this.handleOk}
                    onCancel={this.handleCancel}
                    maskClosable={false}
                    destroyOnClose={true}
                >
                    {form.getFieldDecorator('distriBution', {
                        initialValue: optionValue,
                    })(this.personSlect(optionValue))}

                    {optionValue == 'static' ?
                        <Item label="" {...inlineFormItemLayout}>
                            {form.getFieldDecorator('static', {
                                initialValue: defaultperson,
                            })(<div></div>)}
                        </Item> : ''}
                    {optionValue == 'dynamicAllocation' ?
                        <Item label="动态分配" {...inlineFormItemLayout}>
                            {form.getFieldDecorator('dynamicAllocation', {
                                initialValue: dynamicAllocation,
                            })(<Input onBlur={this.handleSubmit} />)}
                        </Item> : ''}
                    {optionValue == 'idm' ?
                        <Fragment>
                            <Item label="分配" {...inlineFormItemLayout}>
                                {form.getFieldDecorator('idm', {
                                    initialValue: optionValue,
                                })(this.renderIdm())}
                            </Item>
                            <Item label="搜索" {...inlineFormItemLayout}>
                                {form.getFieldDecorator('search', {
                                    initialValue: search,
                                })(this.searchList())}
                            </Item>
                        </Fragment>
                        : ''}
                    {optionValue == 'group' ?
                        <Fragment>
                            <Item label="分配" {...inlineFormItemLayout}>
                                {form.getFieldDecorator('group', {
                                    initialValue: optionValue,
                                })(this.renderGroup())}
                            </Item>
                            <Item label="搜索" {...inlineFormItemLayout}>
                                {form.getFieldDecorator('search', {
                                    initialValue: search,
                                })(this.searchGroupList())}
                            </Item>
                        </Fragment>
                        : ''}
                </Modal>
            </div>
        )
    }
    //分配人下拉框
    personSlect = (optionValue) => {
        return (<Select onSelect={this.onSelect}>
            <Option value="static">流程发起人</Option>
            <Option value="dynamicAllocation">动态分配</Option>
            <Option value="idm">候选人</Option>
            <Option value="group">分组</Option>
        </Select>)
    }
    //修改候选人分类
    onSelect = (value) => {
        this.valueDistriBution = ''
        this.setState({
            optionValue: value,
            initialFp: true
        })
    }
    //显示弹框
    showModal = (optionValue) => {
        // console.log(this.myNode)
        let dynamicAllocation = []
        let idm = []
        let group = []
        if (optionValue == 'idm') {
            idm = this.myNode?.properties?.usertaskassignment?.assignment?.idm?.candidateUsers ?
                this.myNode.properties.usertaskassignment.assignment.idm.candidateUsers : []
            // console.log(idm)
        }

        if (optionValue == 'dynamicAllocation') {
            dynamicAllocation = this.myNode?.properties?.usertaskassignment?.assignment?.candidateUsers ?
                this.myNode.properties.usertaskassignment.assignment.candidateUsers : []
        }

        if (optionValue == 'group') {
            group = this.myNode?.properties?.usertaskassignment?.assignment?.idm?.candidateGroups ?
                this.myNode.properties.usertaskassignment.assignment.idm.candidateGroups : []
            // console.log(group)
        }

        this.setState({
            visible: true,
            idm: idm,
            group: group,
            dynamicAllocation: dynamicAllocation,
            optionValue: optionValue,
        });
    };
    //得到动态分配人列表
    getdtList = () => {
        const person = 'person'
        const { form } = this.props
        let { dynamicAllocation } = this.state
        const value = ''
        return (
            <Fragment>
                {form.getFieldDecorator('addDynamicAlDlocation', {
                    initialValue: value,
                })(<Input placeholder='请输入' />)}
                <Button type="primary" onClick={this.addDynamicAlDlocation}>添加</Button>
                {dynamicAllocation.map((item, index) => {
                    return (
                        <div key={index} className={styles.deleteDynamicAlDlocationBox}>
                            <span>{item.value}</span>
                            <Button className={styles.deleteDynamicAlDlocation} type="primary" onClick={() => { this.deleteDynamicAlDlocation(item.value) }}>删除</Button>
                        </div>
                    )
                })}
            </Fragment>

        )
    }
    //添加动态分配
    addDynamicAlDlocation = () => {
        let dynamicAllocation = this.state.dynamicAllocation
        const { form, dispatch } = this.props
        let values = {}
        setTimeout(() => {
            values = form.getFieldsValue()
            if (values.addDynamicAlDlocation !== '') {
                const obj = {
                    "value": values.addDynamicAlDlocation,
                    "$$hashKey": ""
                }
                form.setFields({ "addDynamicAlDlocation": "" })
                dynamicAllocation.push(obj)
                // console.log(values, dynamicAllocation)
                this.setState({
                    dynamicAllocation: values.dynamicAllocation,
                    IsADD: true
                })
            }

        })

    }
    //删除不要的分配人
    deleteDynamicAlDlocation = (value) => {
        // console.log(value)
        this.myStr = this.state.dynamicAllocation.filter(item => item.value !== value)
        this.setState({
            dynamicAllocation: this.myStr,
            isCancel: true
        })
    }

    //确定
    handleOk = e => {
        this.handleSubmit()
        this.setState({
            visible: false,
            idm: this.state.idm,
            dynamicAllocation: this.state.dynamicAllocation,
            openModel: true,
            isCancel: true,
        });
    };
    //取消
    handleCancel = e => {
        this.setState({
            visible: false,
            isCancel: false,
            IsLisenner: false,
            initialFp: false,
        });
    };

    //分组列表
    renderGroup = () => {
        return (
            <div className={styles.personList}>
                {this.state.group.map((item, index) => {
                    return <div key={index}>
                        <img src={textImg}></img>
                        <span>{item.name}</span>
                        <img className={styles.idmRemove} src={textImg} onClick={() => (this.removeGroup(item.id))}></img>
                    </div>
                })}
            </div>
        )
    }
    //搜索分组数据
    searchGroupList = () => {
        return (
            <div >
                <Input onChange={() => { this.getServerGroupList() }} />
                <div className={styles.searchList}>
                    {this.state.searchGroupList.map((item, index) => {
                        return <div key={index} onClick={() => (this.addGroup(item))}>
                            <img src={textImg}></img>
                            <span>{item.name}</span>
                            <img className={styles.idmRemove} src={textImg} ></img>
                        </div>
                    })}
                </div>
            </div>
        )
    }
    //获取搜索数据
    getServerGroupList = () => {
        const { form, dispatch } = this.props
        let values = {}
        setTimeout(() => {
            values = form.getFieldsValue()
            if (values.search !== '') {
                dispatch({
                    type: 'DataGgEditor/getGroupList',
                    payload: values.search,
                    callback: (response) => {
                        this.setState({
                            searchGroupList: response.data
                        })
                    }
                })
            } else {
                this.setState({
                    searchGroupList: []
                })
            }

        })
    }
    //添加分组人
    addGroup = (person) => {
        let flag = true
        let group = this.state.group
        this.state.group.map(item => {
            if (item.id == person.id) {
                flag = false
            }
        })
        if (flag) {
            group.push(person)
        }
        this.setState({
            group: group,
            IsADD: true
        })
    }
    //删除分组人
    removeGroup = (id) => {
        let group = this.state.group.filter(item => {
            if (item.id !== id) {
                return item
            }
        })
        this.setState({
            group: group,
            isCancel: true
        })
    }
    //选定的候选人列表
    renderIdm = (id) => {
        return (
            <div className={styles.personList}>
                {this.state.idm.map((item, index) => {
                    return <div key={index}>
                        <img src={textImg}></img>
                        <span>{item.firstName}</span>
                        <img className={styles.idmRemove} src={textImg} onClick={() => (this.removeIdm(item.id))}></img>
                    </div>
                })}
            </div>
        )
    }
    //搜索候选人列表
    searchList = () => {
        return (
            <div >
                <Input onChange={() => { this.getServerList() }} />
                <div className={styles.searchList}>
                    {this.state.searchList.map((item, index) => {
                        return <div key={index} onClick={() => (this.addIdm(item))}>
                            <img src={textImg}></img>
                            <span>{item.firstName}</span>
                            <img className={styles.idmRemove} src={textImg} ></img>
                        </div>
                    })}
                </div>
            </div>
        )
    }
    //获取搜索的数据
    getServerList = () => {
        const { form, dispatch } = this.props
        let values = {}
        setTimeout(() => {
            values = form.getFieldsValue()
            if (values.search !== '') {
                dispatch({
                    type: 'DataGgEditor/getDistriBution',
                    payload: values.search,
                    callback: (response) => {
                        this.setState({
                            searchList: response.data
                        })
                    }
                })
            } else {
                this.setState({
                    searchList: []
                })
            }

        })

    }
    //删除不要的候选人
    removeIdm = (id) => {
        let idm = this.state.idm.filter(item => {
            if (item.id !== id) {
                return item
            }
        })
        this.setState({
            idm: idm,
            isCancel: true
        })
    }
    //添加候选人
    addIdm = (person) => {
        let flag = true
        let idm = this.state.idm
        this.state.idm.map(item => {
            if (item.id == person.id) {
                flag = false
            }
        })
        if (flag) {
            idm.push(person)
        }
        this.setState({
            idm: idm,
            IsADD: true
        })
    }

    //activity多选框的函数
    changeCheckBox = () => {
        this.setState({
            activity: !this.state.activity
        })
    }
    //得到当前node
    getNeedNode = (id) => {
        const detail = this.props.data.model.childShapes.filter(item => {
            if (item.resourceId === id) {
                if (item.stencil.id == 'UserTask' || item.stencil.id == 'StartNoneEvent' || item.stencil.id == 'EndNoneEvent') {//判断是否是有监听器的节点
                    if (this.state.judge) {//判断是否开启监听器
                        const executionlisteners = item?.properties?.executionlisteners?.executionListeners?.length
                        this.checked = executionlisteners ? true : false
                    } else {
                        this.checked = this.state.checked
                    }
                } else {
                    this.checked = this.state.checked
                }
                return item
            }
        })
        if (detail.length == 0) return
        this.myNode = detail[0]
        //获取分配人
        if (detail[0]?.properties?.usertaskassignment) {
            this.usertaskassignment = detail[0].properties.usertaskassignment
            this.distriBution = this.usertaskassignment.assignment ? this.usertaskassignment.assignment.type : 'static'
        }
        if (detail[0]?.properties?.cancelactivity) {
            this.cancelactivity = detail[0].properties.cancelactivity
            this.timerdatedefinition = detail[0].properties.timerdatedefinition
        }

        this.stencil = detail[0].stencil.id
        //获取定时器
        if (detail[0]?.properties?.executionlisteners) {
            this.detail = detail[0].properties.executionlisteners.executionlisteners
            return detail[0].properties.executionlisteners.executionListeners !== undefined ?
                detail[0].properties.executionlisteners.executionListeners : this.detail
        }
    }
    //获取需要的线
    getNeededge = (id) => {
        this.myedge = ''
        this.props.data.model.childShapes.filter(item => {
            if (item.resourceId === id) {
                this.myedge = item
                return item
            }
        })
    }

    //节点的具体数据
    aginRender = () => {
        const { form, getDrag, getEvent } = this.props;
        let { id, shape } = !!getEvent ?
            getEvent.item.model : !!getDrag.currentItem ?
                getDrag.currentItem.model : this.MyE.model
        this.getNeedNode(id)
        console.log(this.myNode)
        const label = this.myNode?.properties?.name ? this.myNode.properties.name : ''
        let formkey = this.myNode?.properties?.formkeydefinition
        const overrideid = this.myNode?.properties?.overrideid ? this.myNode.properties.overrideid : ''
        const userId = 'userId'
        const listener = this.checked
        const timer = this.timerdatedefinition !== undefined ? this.timerdatedefinition : ''
        const activity = this.cancelactivity
        const category = ''
        const things = 'start'
        const expression = ''
        // console.log(id, shape, label)
        switch (shape) {
            case 'StartNoneEvent':
            case 'EndNoneEvent':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="监听器" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('listener', {
                            initialValue: listener,
                        })(this.switch())}
                    </Item>
                    {this.state.checked && this.checked ?
                        <div>
                            {this.renderSimpleForm(golbalInfo)}
                        </div> : ''
                    }
                </Fragment>
            case 'UserTask':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="表单键(key)" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('formkey', {
                            initialValue: formkey,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="分配人" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('userId', {
                            initialValue: userId,
                        })(this.modal())}
                    </Item>
                    <Item label="监听器" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('listener', {
                            initialValue: listener,
                        })(this.switch())}
                    </Item>
                    {this.state.checked && this.checked ?
                        <div>
                            {this.renderSimpleForm(golbalInfo)}
                        </div> : ''
                    }
                </Fragment>
            case 'BoundaryTimerEvent':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="开启时间" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('timer', {
                            initialValue: timer,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="Activity" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('activity', {
                            initialValue: activity,
                        })(<Checkbox defaultChecked={activity} onClick={this.changeCheckBox, this.handleSubmit}></Checkbox>)}
                    </Item>
                </Fragment>
            case 'ExclusiveGateway':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                </Fragment>
            default:
                return <span>缺乏匹配项</span>

        }
    }
    //线的参数
    aginRenderEdge = () => {
        const { form, getEvent } = this.props;
        const { label, id, shape, overrideid, conditions } = getEvent.item.model
        // const label = this.MyE.model.label,
        //     shape = this.MyE.model.shape,
        //     id = this.MyE.model.id,
        //     overrideid = this.MyE.model.overrideid,
        //     conditions = this.MyE.model.conditions
        return (
            <Fragment>
                <Item label="标签名" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('label', {
                        initialValue: label,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="Shape" style={{ display: 'none' }} {...inlineFormItemLayout}>
                    {form.getFieldDecorator('shape', {
                        initialValue: shape,
                    })(this.renderEdgeShapeSelect())}
                </Item>
                <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('id', {
                        initialValue: id,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="编号" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('overrideid', {
                        initialValue: overrideid,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="流条件" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('conditions', {
                        initialValue: conditions,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
            </Fragment>
        );
    }
    //canvas的参数
    aginRendercanvas = () => {
        const { form, data } = this.props;
        const name = Object.keys(this.state.values).length > 0 ? this.state.values.name : data.name,
            key = Object.keys(this.state.values).length > 0 ? this.state.values.key : data.key
        let author = '', namespace = ''
        data.model !== undefined ?
            author = Object.keys(this.state.values).length > 0 ?
                this.state.values.author : data.model.properties.process_author : ''
        data.model !== undefined ?
            namespace = Object.keys(this.state.values).length > 0 ?
                this.state.values.namespace : data.model.properties.process_namespace : ''

        return (
            <Fragment>
                <Item label="name" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('name', {
                        initialValue: name,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="key" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('key', {
                        initialValue: key,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="author" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('author', {
                        initialValue: author,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="namespace" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('namespace', {
                        initialValue: namespace,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
            </Fragment>
        );
    }
    //线的显示样式
    renderEdgeShapeSelect = () => {
        return (
            <Select onChange={this.handleSubmit}>
                <Option value="flow-smooth">Smooth</Option>
                <Option value="flow-polyline">Polyline</Option>
                <Option value="flow-polyline-round">Polyline Round</Option>
            </Select>
        );
    };

    //跟新数据调用的函数
    towRender = () => {
        // console.log(golbalInfo)
        const { getDrag, getEvent, getDragEnd } = this.props;
        console.log('第二次点击', this.MyE)
        // console.log(getDrag, getEvent)
        const isGetEvent = !!getEvent
        const isGetDrag = !!getDrag
        let type = ''
        if (isGetEvent && !isGetDrag) {
            type = !!getEvent.item ? getEvent.item.type : 'canvas'
            // console.log(getEvent)
            if (getEvent.item) {
                if (!getEvent.item.model.shape && !!getDragEnd) {
                    type = 'canvas'
                }
            }

        } else if (!isGetEvent && isGetDrag) {
            type = !!getDrag.currentItem ? getDrag.currentItem.type : 'canvas'
        }
        // console.log(type)
        // let type = !!getEvent ? getEvent.item.type : !!getDrag.currentItem ? getDrag.currentItem.type : 'canvas'
        return (
            <Card type="inner" size="small" title={type} bordered={false}>
                <Form onSubmit={this.handleSubmit}>
                    {type === 'node' && this.aginRender()}
                    {type === 'edge' && this.aginRenderEdge()}
                    {type === 'canvas' && this.aginRendercanvas()}
                </Form>
            </Card>
        );
    }
    //移动节点是改变定时器的位子
    moveTimer = (item) => {
        item.itemMap._nodes.map(timer => {
            if (timer.model.shape == "BoundaryTimerEvent") {
                console.log(1236)
                timer.model.x = 900
            }
        })
    }
    renderNodeDetail = () => {
        const { form, propsAPI } = this.props;
        const { getSelected } = propsAPI;
        const { label, id } = this.item.getModel();
        const item = getSelected()[0];
        this.MyE = this.item//在更新视图后保留住this.item
        console.log(this.item)
        console.log(this.myNode)
        const detail = this.getNeedNode(id)
        this.getNewMap(item.itemMap)
        this.getNeedNode(id)
        this.isAddEdge(this.item)
        let overrideid = this.myNode?.properties?.overrideid
        overrideid = overrideid ? overrideid : ''
        let formkey = this.myNode?.properties?.formkeydefinition
        const shape = item.model.shape
        const userId = 'userId'
        const listener = this.checked
        const timer = this.timerdatedefinition !== undefined ? this.timerdatedefinition : ''
        const activity = this.cancelactivity
        const category = ''
        const things = 'start'
        const expression = ''
        golbalInfo = { label, id, overrideid, detail, shape, userId, listener, timer, activity, category, things, expression, type: 'node' }
        switch (shape) {
            case 'StartNoneEvent':
            case 'EndNoneEvent':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="监听器" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('listener', {
                            initialValue: listener,
                        })(this.switch())}
                    </Item>
                    {this.state.checked && this.checked ?
                        <div>
                            {this.renderSimpleForm(golbalInfo)}
                        </div> : ''
                    }
                </Fragment>
            case 'UserTask':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="表单键(key)" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('formkey', {
                            initialValue: formkey,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="分配人" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('userId', {
                            initialValue: userId,
                        })(this.modal())}
                    </Item>
                    <Item label="监听器" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('listener', {
                            initialValue: listener,
                        })(this.switch())}
                    </Item>
                    {this.state.checked && this.checked ?
                        <div>
                            {this.renderSimpleForm(golbalInfo)}
                        </div> : ''
                    }
                </Fragment>
            case 'BoundaryTimerEvent':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="开启时间" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('timer', {
                            initialValue: timer,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="Activity" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('activity', {
                            initialValue: activity,
                        })(<Checkbox defaultChecked={activity} onClick={this.changeCheckBox, this.handleSubmit}></Checkbox>)}
                    </Item>
                </Fragment>
            case 'ExclusiveGateway':
                return <Fragment>
                    <Item label="标签名" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('label', {
                            initialValue: label,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('id', {
                            initialValue: id,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="编号" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('overrideid', {
                            initialValue: overrideid,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                </Fragment>
            default:
                return <span>缺乏匹配项</span>

        }
    };
    //判断是否有新赠线条
    isAddEdge = (item) => {
        let flag = false
        this.newEdge = false
        item.itemMap._edges.filter(edge => {
            if (edge.model.style == undefined) {
                // console.log(2155688)
                this.newEdge = true
                flag = true
                return edge
            }
        })
        if (flag) {
            this.getNewMap(item.itemMap, item.id)
        }

    }
    renderEdgeDetail = () => {
        const { form, propsAPI } = this.props;
        const { label = '', shape = 'flow-polyline', id } = this.item.getModel();
        console.log(this.item)
        this.MyE = this.item//在更新视图后保留住this.item
        // this.item.keyShape._attrs.lineWidth = 20//修改选中后的样式
        this.getNeededge(id)
        this.sourceAnchor = this.item.model.sourceAnchor !== undefined ? this.item.model.sourceAnchor : ''
        this.targetAnchor = this.item.model.targetAnchor !== undefined ? this.item.model.targetAnchor : ''
        let overrideid = ''
        let conditions = ''
        console.log(this.myedge)
        this.isAddEdge(this.item)
        if (!!this.myedge) {//判断是否有这个边
            overrideid = this.myedge.properties.overrideid
            let value = this.myedge?.properties?.conditionsequenceflow?.expression?.staticValue
            // console.log(value)
            conditions = value ? value : ''
            // console.log(conditions)
        }
        this.getNewMap(this.item.itemMap, id)
        golbalInfo = { label, shape, id, overrideid, conditions, type: 'edge' }

        return (
            <Fragment>
                <Item label="标签名" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('label', {
                        initialValue: label,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="Shape" style={{ display: 'none' }} {...inlineFormItemLayout}>
                    {form.getFieldDecorator('shape', {
                        initialValue: shape,
                    })(this.renderEdgeShapeSelect())}
                </Item>
                <Item style={{ display: 'none' }} label="" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('id', {
                        initialValue: id,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="编号" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('overrideid', {
                        initialValue: overrideid,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
                <Item label="流条件" {...inlineFormItemLayout}>
                    {form.getFieldDecorator('conditions', {
                        initialValue: conditions,
                    })(<Input onBlur={this.handleSubmit} />)}
                </Item>
            </Fragment>
        );
    };

    renderGroupDetail = () => {
        const { form } = this.props;
        const { label = 'æ–°å»ºåˆ†ç»„' } = this.item.getModel();


        return (
            <Item label="Label" {...inlineFormItemLayout}>
                {form.getFieldDecorator('label', {
                    initialValue: label,
                })(<Input onBlur={this.handleSubmit} />)}
            </Item>
        );
    };



    renderCanvasDetail = () => {
        const { form, data } = this.props;
        const name = Object.keys(this.state.values).length > 0 ? this.state.values.name : data.name,
            key = Object.keys(this.state.values).length > 0 ? this.state.values.key : data.key
        let author = '', namespace = ''
        data.model !== undefined ?
            author = Object.keys(this.state.values).length > 0 ?
                this.state.values.author : data.model.properties.process_author : ''
        data.model !== undefined ?
            namespace = Object.keys(this.state.values).length > 0 ?
                this.state.values.namespace : data.model.properties.process_namespace : ''


        return (
            <Card type="inner" size="small" title="Canvas" bordered={false}>
                <Fragment>
                    <Item label="name" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('name', {
                            initialValue: name,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="key" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('key', {
                            initialValue: key,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="author" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('author', {
                            initialValue: author,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                    <Item label="namespace" {...inlineFormItemLayout}>
                        {form.getFieldDecorator('namespace', {
                            initialValue: namespace,
                        })(<Input onBlur={this.handleSubmit} />)}
                    </Item>
                </Fragment>
            </Card>
        );
    }
    render() {
        const { type } = this.props;
        // console.log(this.props)
        if (type === 'canvas' || this.props.isDelete == true) {
            return this.renderCanvasDetail()
        }
        // console.log('再次执行render', this.item)
        if (!this.item) {
            // console.log(545544)
            return this.towRender();
        }
        return (
            <Card type="inner" size="small" title={upperFirst(type)} bordered={false}>
                <Form onSubmit={this.handleSubmit}>
                    {type === 'node' && this.renderNodeDetail()}
                    {type === 'edge' && this.renderEdgeDetail()}
                    {type === 'group' && this.renderGroupDetail()}
                </Form>
            </Card>
        );
    }
}

export default Form.create()(withPropsAPI(DetailForm));
