import React from 'react';
import { Card } from 'antd';
import { NodePanel, EdgePanel, GroupPanel, MultiPanel, CanvasPanel, DetailPanel } from 'gg-editor';
import DetailForm from './DetailForm';
import styles from './index.less';

const FlowDetailPanel = ({ getDrag, getDragEnd, getprocess, data, getEvent, isDelete }) => {
  return (
    <DetailPanel className={styles.detailPanel}>
      <NodePanel>
        <DetailForm
          type="node"
          getDragEnd={getDragEnd}
          getDrag={getDrag}
          getEvent={getEvent}
          data={data} getprocess={getprocess}
          isDelete={isDelete}
        />
        {/* <GetDetail type="node" getprocess={getprocess} /> */}
      </NodePanel>
      <EdgePanel>
        <DetailForm type="edge"
          getDragEnd={getDragEnd}
          getEvent={getEvent}
          data={data}
          getprocess={getprocess}
          isDelete={isDelete}
        />
        {/* <GetDetail type="edge" getprocess={getprocess} /> */}
      </EdgePanel>
      <GroupPanel>
        <DetailForm type="group"
          getEvent={getEvent} data={data}
          getprocess={getprocess}
        />
        {/* <GetDetail type="group" getprocess={getprocess} /> */}
      </GroupPanel>
      <MultiPanel>
        <Card type="inner" size="small" title="Multi Select" bordered={false} />
      </MultiPanel>
      <CanvasPanel>
        {/* <Card type="inner" size="small" title="Canvas" bordered={false} /> */}
        <DetailForm type="canvas"
          getEvent={getEvent}
          data={data}
          getprocess={getprocess}
        />
        {/* <GetDetail type="canvas" getprocess={getprocess} /> */}
      </CanvasPanel>
    </DetailPanel>
  );
};

export default FlowDetailPanel;
