import React from 'react';
import { Card, Collapse, Icon } from 'antd';
import { ItemPanel, Item, RegisterNode } from 'gg-editor';
import styles from './index.less';
import UserTaskImg from '../assets/UserTaskImg.png'
import StartNoneEvent from '../assets/StartNoneEvent.png'
import EndNoneEvent from '../assets/EndNoneEvent.png'
import BoundaryTimerEvent from '../assets/BoundaryTimerEvent.png'
import ExclusiveGateway from '../assets/ExclusiveGateway.png'

const { Panel } = Collapse;

const FlowItemPanel = (props) => {
  let { maxX, minY } = props
  return (
    //     {/* 画板中的节点样式由 model 控制，而节点预览样式由 CSS 或者图片控制， */}
    //     {/* model: {
    //       color: '#333', // 节点主题色（选中颜色、激活颜色基于该值）
    //       size: [10, 10], // [x, y] 节点尺寸
    //       shape: 'cirle', // 图形：圆形 circle | 圆角矩形 rect | 菱形 rhombus | 椭圆矩形 capsule
    //       style: { // 关键形样式(可覆盖color的普通样式，但激活、选中依然无效，坑！)
    //       fill: 'red', // 填充背景
    //       stroke: 'blue' // 形状描边
    //             },
    //       label: { // 节点标签
    //       text: '开始节点', // 文本内容
    //       fill: 'green' // 文本颜色
    //     },
    //      index: 1 // 渲染层级
    //     } */}
    //
    <Collapse accordion className={styles.itemPanelBox}>
      <Panel header="启动事件" key="2">
        <ItemPanel className={styles.itemPanel}>
          <Card bordered={false}>
            <Item
              type="node"
              size="20*20"
              shape="StartNoneEvent"
              model={{
                label: '开始',
              }}
            // src={StartNoneEvent}
            />
            <img src={StartNoneEvent}></img>
            <span>开始事件</span>
          </Card>
        </ItemPanel>
        <ItemPanel className={styles.itemPanel}>
          <Card bordered={false}>
            <Item
              type="node"
              size="20*20"
              shape="EndNoneEvent"
              model={{
                label: '结束',
              }}
            // src={EndNoneEvent}
            />
            <img src={EndNoneEvent}></img>
            <span>结束事件</span>
          </Card>
        </ItemPanel>
      </Panel>
      <Panel header="任务" key="3">
        <ItemPanel className={styles.itemPanel}>
          <Card bordered={false}>
            <Item
              type="node"
              size="80*48"
              shape="UserTask"
              model={{
                label: '',
              }}
            // src={UserTaskImg}
            />
            <img src={UserTaskImg}></img>
            <span>任务</span>
          </Card>
        </ItemPanel>
      </Panel>
      <Panel header="定时器" key="4">
        <ItemPanel className={styles.itemPanel}>
          <Card bordered={false}>
            <Item
              type="node"
              size="20*20"
              shape="BoundaryTimerEvent"
              model={{
                color: '#578586',
                label: '定时器',
              }}
              src={BoundaryTimerEvent}
            />
            <img src={BoundaryTimerEvent}></img>
            <span>定时器</span>
          </Card>
        </ItemPanel>
      </Panel>
      <Panel header="网关" key="5">
        <ItemPanel className={styles.itemPanel}>
          <Card bordered={false}>
            <Item
              type="node"
              size="20*20"
              shape="ExclusiveGateway"
              model={{
                color: '#578586',
                label: '网关',
              }}
            // src={ExclusiveGateway}
            />
            <img src={ExclusiveGateway}></img>
            <span>网关</span>
          </Card>
        </ItemPanel>
      </Panel>
      {maxX !== 0 && minY !== 0 ?
        <div id={styles.more} className={styles.more} style={{ left: maxX + 274 + "px", top: minY + 'px' }}>
          <ItemPanel className={styles.myItemPanel}>
            <Card bordered={false} className='myCard'>
              <Item
                type="node"
                size="20*20"
                shape="StartNoneEvent"
                model={{
                  label: '开始',
                }}
              />
              <img src={StartNoneEvent}></img>
            </Card>
            <Card bordered={false} className='myCard'>
              <Item
                type="node"
                size="80*48"
                shape="UserTask"
                model={{
                  label: '',
                }}
              />
              <img src={UserTaskImg}></img>
            </Card>
            <Card bordered={false} className='myCard'>
              <Item
                type="node"
                size="20*20"
                shape="EndNoneEvent"
                model={{
                  label: '结束',
                }}
              />
              <img src={EndNoneEvent}></img>
            </Card>
          </ItemPanel>
        </div> : ''}
    </Collapse>
  );
};

export default FlowItemPanel;
