/**
 * 回收组件
 * 徐立
 * 2020.4.8
 * @param { Function } asyncReasion 转交理由同步参数
 */
import React, { Component } from 'react'
import styles from '../style.less';
import { Row, Col,Input,Spin } from 'antd';
import { connect } from 'dva';
import { getUaaServicesNomal } from '../../../../Services/services';
import { getListApi } from '../../../../Services/services';
const { TextArea } = Input;
@connect()
export default class index extends Component {
    constructor(props){
        super(props)
        this.state = {
            textAreaValue: '',
            data:'',
            isLoading: false,
        }
    }
    async componentDidMount(){ // 请求当前
        const { value, dispatch } = this.props
        this.setState({
            isLoading: true
        })
        await getUaaServicesNomal(getListApi, {
            taskId:value.taskId,
        }).then(val => {
            this.setState({
                data:Array.isArray(val)&&val?.length>0?val[val.length-1]:'',
                isLoading: false,
            })
        });
    }
    /**
     * 多行文本输入
     */
    textAreaChange = (e) => {
        this.setState({
            textAreaValue: e.target.value
        })
        this.props.asyncReasion(e.target.value)
    }
    render() {
        const { data,isLoading } = this.state
        return (
            <div
                className={styles.show_recall_user_div}
                >
                {
                    !isLoading?
                    <>
                    <Row 
                    gutter={16}
                    >
                    <Col
                        span={4}
                        style={{
                            textAlign:'right'
                        }}
                        >
                        转发人:
                    </Col>
                    <Col
                        span={20}
                        >
                        {data?.sendUserName}
                    </Col>
                </Row>
                <Row 
                    gutter={16}
                    >
                    <Col
                        span={4}
                        style={{
                            textAlign:'right'
                        }}
                        >
                        转发理由:
                    </Col>
                    <Col
                        span={20}
                        >
                        {data?.massage??'暂无'}
                    </Col>
                </Row>
                <Row
                    gutter={16}
                    style={{
                        marginTop:12
                    }}
                    >
                    <Col
                        span={4}
                        style={{
                            textAlign:'right'
                        }}
                        >
                        回退原因:
                    </Col>
                    <Col
                        span={20}
                        >
                        <TextArea  
                                rows={4}
                                style={{
                                    resize:'none'
                                }}
                                onChange={
                                    this.textAreaChange
                                }
                                />
                    </Col>
                </Row>
                </>
                :<div
                    className={styles.spin_div}
                    >
                    <Spin />
                </div>
                }
            </div>
        )
    }
}
