import React from 'react';
import { openToast } from './components/Notification';
import { preHandle } from '@/webPublic/one_stop_public/utils/myutils';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { callbackSubmitData } from '@/webPublic/one_stop_public/models/callbackExamineProcess';
import { getModal } from '@/webPublic/one_stop_public/utils/utils';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import beforeAuditSubmit from '@/webPublic/one_stop_public/utils/beforeAuditSubmit';
import beforeApplySubmit from '@/webPublic/one_stop_public/utils/beforeApplySubmit';

const Modal = getModal();

const must = (
	<span
		style={{
			color: '#FF5350',
			marginLeft: 5,
			marginRight: 5,
		}}>
		*
	</span>
);

// 检查是否启用表单校验
const checkNeedFormValidateFieldsAndScroll = ({ btns, btnValue }) => {
	let btnInfo = btns.find((g) => g.value + '' === btnValue + '');
	let checkSumbitInfo = true;
	if (btnInfo && btnInfo.isValidateForm === false) {
		checkSumbitInfo = false; // 23425 学生事务/学生违纪管理/违纪上报/审核，2013010255 学生处干事选择驳回 这些字段不用填
	}
	return checkSumbitInfo;
};

// 校验是否该按钮需要填写审批意见
const checkNeedWriteAuditInfo = ({ btns, btnValue }) => {
	let btnInfo = btns.find((g) => g.value + '' === btnValue + '');
	let needWrite = false;
	if (btnInfo && isJSON(btnInfo?.documentation)) {
		let documentation = JSON.parse(btnInfo.documentation);
		if (documentation.needAuditInfo) {
			needWrite = true; // 26589 毕业生毕业去向中签约和改签审核拒绝必须要填审批说明
		}
	}
	return needWrite;
};

/**
 * 流程审批 提交数据
 * */
const submitValues = ({
	values,
	isCloseFlowPath,
	radiovalue,
	isSecond,
	taskId,
	code,
	btnValue,
	oldkey,
	value,
	checked,
	setData,
	data,
	userInfo,
	btns,
	dispatch,
	that,
	handleUser,
}) => {
	if (isCloseFlowPath) {
	} else if (!radiovalue && isSecond) {
		openToast('success', '请选择紧急度');
		return;
	}
	that.setState(
		{
			isSumbitLoading: true,
		},
		() => {
			preHandle(values); // 引入 import {preHandle} from '@/webPublic/one_stop_public/utils/myutils.js'
			// return ;

			let payload = {
				taskIds: [taskId], // 接口里面的taskId 任务Id
				//   taskIds: [this.state.taskId], // 接口里面的taskId 任务Id
				level: radiovalue && isSecond ? radiovalue : '', // 流程紧急度 可不传
				// code: this.state.code, // 接口里面的code 为表单编号
				code: code, // 接口里面的code 为表单编号
				// 所有审核内容都在这里面
				examineMap: JSON.stringify({
					// 接口里面的btns数组, key值和value没有值问题后期已修复
					// 是否同意 0同意 1拒绝
					[oldkey]: btnValue, // 每个配置按钮对应的对象内容 oldkey = 接口中 key btnValue = 接口中 value
					reason: value, // 审批理由
					// code: this.state.code, // 接口里面的code 为表单编号
					code: code, // 接口里面的code 为表单编号
					sign: checked ? setData?.userSign : '', // 加签
				}),
				taskForm: JSON.stringify(values), // 审批表单的参数值
				handleUser, // 表单处理人
				apiData: data,
				taskFormKey: data.taskFormKey,
				userNowInfo: userInfo,
				buttonInfo: btns && btns.length ? btns.find((x) => x.value === btnValue) : {},
				token: getToken(),
			};
			payload = callbackSubmitData(payload);

			const beforeAuditSubmitFunc = (valuesPayload = {}) => { // 提交数据到审批接口
				beforeAuditSubmit(valuesPayload).then((resParams) => {
					if (!resParams) {
						that.setState({
							isSumbitLoading: false,
						});
						return false;
					} else {
						dispatch({
							type: 'affair/getExamineProcess',
							payload: resParams,
							callback: (val) => {
								if (val) {
									// that.getInit();
									that.setState({
										isHandle: false,
										isSumbitLoading: false,
										isSign: checked,
									});
									Modal.success({
										title: '操作成功',
										content: (
											<div>
												<p>操作成功,点击确认刷新页面!</p>
											</div>
										),
										onOk: () => {
											that.props.getFormDetailData();
										},
										okText: '确认',
									});
								} else {
									openToast('error', '失败', '请稍后重试');
								}
							},
						});
					}
				});
			};

			/**
			 * 29943 北电]违纪-违纪上报辅导员，驳回修改的处分不生效
       * 27696 [黔南一站式1.0]单位申请数据撤销之后，就业管理员审核报错
			 * */
			const taskInfo = that.state?.data?.taskInfo;
			if (
        btnValue === '0' && // 只有通过 或者同意 或者 提交 才能使用申请回调
				Array.isArray(taskInfo) &&
				taskInfo.length >= 2 &&
				taskInfo[0].taskDefKey &&
				taskInfo[0].taskDefKey === taskInfo[taskInfo.length - 1].taskDefKey
			) {
				console.log('驳回到发起人了,并且发起人重新提交了 则执行这个发起回调');
				beforeApplySubmit({
					appId: window.smartFormGlobalProps.data.appId,
					content: payload.taskForm,
				}).then((res) => {
				  if(!res){ // 如果返回false 中止提交.
            that.setState({
              isSumbitLoading: false,
            });
				    return false;
          }
					if (res && res.content && isJSON(res.content)) {
						payload.taskForm = res.content; // 替换表单数据
					}
					beforeAuditSubmitFunc(payload); // 提交数据到审批接口
				});
			} else {
				beforeAuditSubmitFunc(payload); // 提交数据到审批接口
			}
			/**
			 * 29943 北电]违纪-违纪上报辅导员，驳回修改的处分不生效
			 * */
		},
	);
};
export { must, checkNeedFormValidateFieldsAndScroll, submitValues, checkNeedWriteAuditInfo };
