/**
 * 历史表单+最新表单生成
 * data 'affair/getIdFormDetail' 接口返回的详细参数
 * form 表单控件
 * isNewForm 是否展示最新表单
 */
import React, { Component } from 'react';
import ZdyTable from '@/webPublic/one_stop_public/Table';
import { Spin } from 'antd';
import { isEmpty } from '../../copy';
export default class index extends Component {
	render() {
		const { data, isNewForm } = this.props;

		let routerState = {
			history: this.props?.history,
			location: this.props?.location,
			match: this.props?.match,
			computedMatch: this.props?.computedMatch,
			route: this.props?.route,
		};
		return (
			<div>
				{data.hisTaskForm.formKeys && data.hisTaskForm.formKeys.length > 0
					? data.hisTaskForm.formKeys.map((item, index) => {
							return (
								<>
									<h3>{item.taskName}</h3>
									{!data ? (
										<div
											style={{
												width: '100%',
												height: 200,
												display: 'flex',
												justifyContent: 'center',
												alignItems: 'center',
											}}>
											<Spin size="large" />
										</div>
									) : (
										<ZdyTable
											get="web"
											postData={data}
											obj={data.hisTaskForm.formData}
											form={this.props.form}
											formKey={item.formKey}
											routerState={routerState}
										/>
									)}
								</>
							);
					  })
					: ''}
				{isNewForm ? ( // 展示最新表单
					data.isHandle && !!data.taskFormKey ? (
						<>
							<h3>当前流程</h3>
							{!isEmpty(data) ? (
								<ZdyTable
									postData={data}
									get="web"
									obj={data.hisTaskForm.formData}
									table="new"
									form={this.props.form}
								/>
							) : null}
						</>
					) : null
				) : null}
			</div>
		);
	}
}
