/**
 * 入口文件
 * 传入Id
 * 移动端或web端识别值
 * form
 * 通过ID生成表单
 */
import React, { Component } from 'react';
import ZdyTable from '../Table';
import { connect } from 'dva';
@connect()
export default class Index extends Component {
	constructor(props) {
		super(props);
		this.state = {
			data: '',
		};
	}
	componentDidMount() {
		const { id, dispatch } = this.props;
		dispatch({
			type: 'modileHome/getDetail',
			payload: {
				id,
			},
			callback: (val) => {
				this.setState({
					data: val,
				});
			},
		});
	}
	render() {
		const { form, get } = this.props;
		const { data } = this.state;
		let routerState = {
			history: this.props?.history,
			location: this.props?.location,
			match: this.props?.match,
			computedMatch: this.props?.computedMatch,
			route: this.props?.route,
		};
		return (
			<>{data && <ZdyTable get={get} postData={data} form={form} routerState={routerState} />}</>
		);
	}
}
