/**
 * 姚鑫国
 * 2024-07-05 20点37分
 * 树多选组件
 */

import { TreeSelect } from 'antd';
import React, { useEffect, useState } from 'react';
import getPopupContainer
  from "@/webPublic/one_stop_public/tableCompon/Split_Index/getPopupContainer";

const { SHOW_PARENT } = TreeSelect;
export default function TreeSelectDiy(props) {
  const { value, onChange, json, disabled, treeData, uuid } = props;
  const [data, setData] = useState([]);
  const onChangeS = v => {
    onChange(v);
  };
  useEffect(() => {
    setData(treeData)
  }, [treeData]);
  return (
    <TreeSelect
      labelInValue
      disabled={disabled}
      treeData={data}
      value={value}
      onChange={onChangeS}
      treeCheckable
      showCheckedStrategy={SHOW_PARENT}
      searchPlaceholder="请选择"
      placeholder={json.placeholder}
      getPopupContainer={getPopupContainer(false, uuid)}

      style={{
        width: '100%',
      }}
      {...json.otherProps}
    />
  )
}
