import root from './root.js';

/** Detect free variable `exports`. */
/** 检测自由变量“导出” */
const freeExports = typeof exports === 'object' && exports !== null && !exports.nodeType && exports;

/** Detect free variable `module`. */
/** 检测自由变量“模块”。 */
const freeModule =
	freeExports && typeof module === 'object' && module !== null && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
/** 检测流行的CommonJS扩展“module.exports” */
const moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
/** 内置参考价值。 */
const Buffer = moduleExports ? root.Buffer : undefined,
	allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;

/**
 * Creates a clone of `buffer`.
 * 创建一个“buffer”的克隆
 * @private
 * @param {Buffer} buffer 要克隆的缓冲区.
 * @param {boolean} [isDeep] 指定深度克隆.
 * @returns {Buffer} 返回克隆的缓冲区.
 */
function cloneBuffer(buffer, isDeep) {
	if (isDeep) {
		return buffer.slice();
	}
	const length = buffer.length;
	const result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

	buffer.copy(result);
	return result;
}

export default cloneBuffer;
