import cloneArrayBuffer from './cloneArrayBuffer.js';

/**
 * Creates a clone of `dataView`.
 * 创建“dataView”的克隆
 * @private
 * @param {Object} dataView 要克隆的数据视图.
 * @param {boolean} [isDeep] 指定深度克隆.
 * @returns {Object} 返回克隆的数据视图。
 */
function cloneDataView(dataView, isDeep) {
	const buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
	return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}

export default cloneDataView;
