/** Used to match `RegExp` flags from their coerced string values. */
/** 用于从强制字符串值匹配' RegExp '标志。 */
const reFlags = /\w*$/;

/**
 * Creates a clone of `regexp`.
 * 创建' regexp '的克隆
 * @private
 * @param {Object} regexp 要克隆的regexp.
 * @returns {Object} 返回克隆的regexp.
 */
function cloneRegExp(regexp) {
	const result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	result.lastIndex = regexp.lastIndex;
	return result;
}

export default cloneRegExp;
