/** Used to convert symbols to primitives and strings. */
/** 用于将符号转换为基本类型和字符串。 */
const symbolValueOf = Symbol.prototype.valueOf;

/**
 * Creates a clone of the `symbol` object.
 * 创建“symbol”对象的克隆。
 * @private
 * @param {Object} symbol 要克隆的符号对象.
 * @returns {Object} 返回克隆的符号对象。
 */
function cloneSymbol(symbol) {
	return Object(symbolValueOf.call(symbol));
}

export default cloneSymbol;
