import copyObject from './copyObject.js';
import getSymbolsIn from './getSymbolsIn.js';

/**
 * Copies own and inherited symbols of `source` to `object`.
 * 复制自己和继承的符号'源'到'对象'。
 * @private
 * @param {Object} source 要从中复制符号的对象。
 * @param {Object} [object={}] 要将符号复制到的对象。
 * @returns {Object} 返回的对象。
 */
function copySymbolsIn(source, object) {
	return copyObject(source, getSymbolsIn(source), object);
}

export default copySymbolsIn;
