import getSymbols from './getSymbols.js';
import keys from './keys.js';

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 * 创建自己的可枚举属性名和“对象”符号的数组。
 * @private
 * @param {Object} object 要查询的对象。
 * @returns {Array} 返回属性名和符号的数组。
 */
function getAllKeys(object) {
	const result = keys(object);
	if (!Array.isArray(object)) {
		result.push(...getSymbols(object));
	}
	return result;
}

export default getAllKeys;
