/** Built-in value references. */
/** 内置参考价值。 */
const propertyIsEnumerable = Object.prototype.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
/* 内置的方法引用与其他“lodash”方法同名。 */
const nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 * 创建“对象”的可枚举符号的数组。
 * @private
 * @param {Object} object 要查询的对象。
 * @returns {Array} 返回符号数组.
 */
function getSymbols(object) {
	if (object == null) {
		return [];
	}
	object = Object(object);
	return nativeGetSymbols(object).filter((symbol) => propertyIsEnumerable.call(object, symbol));
}

export default getSymbols;
