const toString = Object.prototype.toString;

/**
 * Gets the `toStringTag` of `value`.
 * 获取' value '的' toStringTag '。
 * @private
 * @param {*} value 要查询的值。
 * @returns {string} 返回“toStringTag”.
 */
function getTag(value) {
	if (value == null) {
		return value === undefined ? '[object Undefined]' : '[object Null]';
	}
	return toString.call(value);
}

export default getTag;
