import getTag from './getTag.js';
import isObjectLike from './isObjectLike.js';

/**
 * Checks if `value` is likely an `arguments` object.
 * 检查' value '是否可能是' arguments '对象。
 * @since 0.1.0
 * @category Lang
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '是' arguments '对象，则返回' true '，否则返回' false '。
 * @example
 *
 * isArguments(function() { return arguments }())
 * // => true
 *
 * isArguments([1, 2, 3])
 * // => false
 */
function isArguments(value) {
	return isObjectLike(value) && getTag(value) == '[object Arguments]';
}

export default isArguments;
