import root from './root.js';

/** Detect free variable `exports`. */
/** 检测自由变量“导出” */
const freeExports = typeof exports === 'object' && exports !== null && !exports.nodeType && exports;

/** Detect free variable `module`. */
/** 检测自由变量“模块”。 */
const freeModule =
	freeExports && typeof module === 'object' && module !== null && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
/** 检测流行的CommonJS扩展“module.exports”。 */
const moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
/** 内置参考价值。 */
const Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
/* 内置的方法引用与其他“lodash”方法同名。 */
const nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 * 检查' value '是否为缓冲区。
 * @since 4.3.0
 * @category Lang
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '是一个缓冲区，则返回' true '，否则返回' false '。
 * @example
 *
 * isBuffer(new Buffer(2))
 * // => true
 *
 * isBuffer(new Uint8Array(2))
 * // => false
 */
const isBuffer = nativeIsBuffer || (() => false);

export default isBuffer;
