/** Used as references for various `Number` constants. */
/** 用作各种“数字”常量的引用。 */
const MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
/** 用于检测无符号整数值。 */
const reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 * 检查' value '是否是一个有效的类数组索引。
 * @private
 * @param {*} value 要检查的值。
 * @param {number} [length=MAX_SAFE_INTEGER] 有效索引的上界。
 * @returns {boolean} 如果' value '是有效的索引，则返回' true '，否则返回' false '。
 */
function isIndex(value, length) {
	const type = typeof value;
	length = length == null ? MAX_SAFE_INTEGER : length;

	return (
		!!length &&
		(type === 'number' || (type !== 'symbol' && reIsUint.test(value))) &&
		(value > -1 && value % 1 == 0 && value < length)
	);
}

export default isIndex;
