/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 * 检查“value”是否为
 * (语言类型)(http://www.ecma-international.org/ecma-262/7.0/ sec-ecmascript-language-types)
 * 的“对象”。(例如:数组、函数、对象、正则表达式、' new Number(0) '和' new String(") ')
 * @since 0.1.0
 * @category Lang
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '是一个对象，则返回' true '，否则返回' false '。
 * @example
 *
 * isObject({})
 * // => true
 *
 * isObject([1, 2, 3])
 * // => true
 *
 * isObject(Function)
 * // => true
 *
 * isObject(null)
 * // => false
 */
function isObject(value) {
	const type = typeof value;
	return value != null && (type === 'object' || type === 'function');
}

export default isObject;
