/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 * 检查' value '是否类似于对象。如果一个值不是“null”，那么它就是类对象的。
 * 和有一个' typeof '结果的“对象”。
 * @since 4.0.0
 * @category Lang
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '类似于对象，则返回' true '，否则返回' false '。
 * @example
 *
 * isObjectLike({})
 * // => true
 *
 * isObjectLike([1, 2, 3])
 * // => true
 *
 * isObjectLike(Function)
 * // => false
 *
 * isObjectLike(null)
 * // => false
 */
function isObjectLike(value) {
	return typeof value === 'object' && value !== null;
}

export default isObjectLike;
