/** Used for built-in method references. */
/** 用于内置的方法引用。 */
const objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 * 检查' value '是否可能是一个原型对象。
 * @private
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '是原型，则返回' true '，否则返回' false '。
 */
function isPrototype(value) {
	const Ctor = value && value.constructor;
	const proto = (typeof Ctor === 'function' && Ctor.prototype) || objectProto;

	return value === proto;
}

export default isPrototype;
