import getTag from './getTag.js';
import nodeTypes from './nodeTypes.js';
import isObjectLike from './isObjectLike.js';

/** Used to match `toStringTag` values of typed arrays. */
/** 用于匹配类型化数组的' toStringTag '值。 */
const reTypedTag = /^\[object (?:Float(?:32|64)|(?:Int|Uint)(?:8|16|32)|Uint8Clamped)Array\]$/;

/* Node.js helper references. */
/** node . js的辅助参考。 */
const nodeIsTypedArray = nodeTypes && nodeTypes.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 * 检查' value '是否被归类为一个有类型的数组。
 * @since 3.0.0
 * @category Lang
 * @param {*} value 要检查的值。
 * @returns {boolean} 如果' value '是一个有类型的数组，则返回' true '，否则返回' false '。
 * @example
 *
 * isTypedArray(new Uint8Array)
 * // => true
 *
 * isTypedArray([])
 * // => false
 */
const isTypedArray = nodeIsTypedArray
	? (value) => nodeIsTypedArray(value)
	: (value) => isObjectLike(value) && reTypedTag.test(getTag(value));

export default isTypedArray;
