/* global globalThis, self */
import freeGlobal from './freeGlobal.js';

/** Detect free variable `globalThis` */
/** 检测自由变量' globalThis ' */
const freeGlobalThis =
	typeof globalThis === 'object' &&
	globalThis !== null &&
	globalThis.Object == Object &&
	globalThis;

/** Detect free variable `self`. */
/** 检测自由变量“自我”。 */
const freeSelf = typeof self === 'object' && self !== null && self.Object === Object && self;

/** Used as a reference to the global object. */
/** 用作对全局对象的引用。 */
const root = freeGlobalThis || freeGlobal || freeSelf || Function('return this')();

export default root;
