import React from 'react';
import { useMemo } from 'react';
import Viewer from 'react-viewer';
import { checkIsImage } from '@/webPublic/one_stop_public/libs/UploadCom';
export const ImgViewer = props => {
  const { onClose, path } = props;
  const images = useMemo(() => {
    if (props.images && Array.isArray(props.images)) {
      return props.images.filter(i => checkIsImage(i.src));
    } else {
      return [
        {
          src: path,
          alt: '预览',
        },
      ];
    }
  }, [props.images]);
  const activeIndex = useMemo(() => {
    if (path && images.length) {
      return images?.findIndex(item => item?.src === path);
    }
    return 0;
  }, [path]);
  return <Viewer visible={true} onClose={onClose} activeIndex={activeIndex} images={images} />;
};
