import { getHeaders } from '@/webPublic/zyd_public/utils/getHeaders';
import FormdataWrapper from '@/webPublic/zyd_public/utils/object-to-formdata-custom';
import { downloadFile } from "@/webPublic/zyd_public/utils/utils";

export function getPdfFile(params) {
	let responseHeadersFileName = '';
	const fetchParams = {
    body: FormdataWrapper(params),
    method: 'POST',
    ...getHeaders(),
    credentials: 'omit',
    mode: 'cors',
  };
	return fetch(window.CONFIG.fileServer + '/officePreviewApi/path', fetchParams)
		.then((res) => {
     return res.blob();
			// 解码

		})
		.then((blob) => {
      let url = window.URL.createObjectURL(new Blob([blob], {
        type: 'application/pdf',
      }));
      return url;
		});
}
