import React, { Fragment, useEffect, useRef, useState } from 'react';
import { Button, Table } from 'antd';
import TableSelectZhanWei from '@/webPublic/one_stop_public/libs/Split/TableSelectZhanWei';

export default function TableSelectNormal(props) {
  const {
    isMultiple, isShowQuanXuan,
    selectAll, cancelAll,
    valueName, dataSource,
    columns3, allWidth,
    get, otherProps,
  } = props;

  if(otherProps && otherProps.showType === 'card-select'){
    return <TableSelectZhanWei {...props} otherProps={otherProps}/>;
  }
  return (
    <Fragment>
      {isMultiple && isShowQuanXuan !== false && (
        <>
          {' '}
          <Button
            id={'quanXuanButton'}
            type={'primary'}
            style={{ margin: '0 10px 10px 0' }}
            onClick={selectAll}>
            全选
          </Button>
          <Button
            id={'quXiaoQuanXuanButton'}
            type={'primary'}
            style={{ marginBottom: '10px' }}
            onClick={cancelAll}>
            取消全选
          </Button>
        </>
      )}
      <Table
        rowKey={valueName}
        size='small'
        dataSource={dataSource.list}
        columns={columns3}
        scroll={{ x: get === 'mobile' ? 'max-content' : allWidth }}
      />
    </Fragment>
  );
}
