import React from 'react';
import { isEmpty } from 'lodash';
import { isJSON } from '@/webPublic/one_stop_public/2022beidianke/isJSON';
import styles from '@/webPublic/one_stop_public/tableCompon/style.less';
import FilePreview from '@/webPublic/one_stop_public/filePreview';
import { queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

export default function UploadComReadOnly(props) {
	const { obj, dataColumn, get, isPrint, otherProps = {} } = props;
	let cm = '';
	/**
	 * 查找不到数据 添加判断
	 * 只有一个附件返回的是一个对象不是数组,暂时使用2个判断
	 */
	if (!isEmpty(obj[dataColumn.base52])) {
		// 首先判断是否为空对象
		let ary;
		/**
		 * 判断返回值是否为JSON字符串,不是则直接使用
		 */
		if (isJSON(obj[dataColumn.base52])) {
			ary = JSON.parse(obj[dataColumn.base52]);
		} else {
			ary = obj[dataColumn.base52];
		}
		if (!!ary.files) {
			// 然后判断存在多个附件的数组是否存在
			const files = !isEmpty(ary) ? ary.files : [];
			cm = (
				<ul className={styles.imageUl}
            style={ get === 'web' && otherProps.readOnlyWebFileStyle ? otherProps.readOnlyWebFileStyle : {} }
        >
					{files.map((f, index2) => {
						if (get === 'web' && !isPrint) {
							return (
								<li key={index2}>
									<FilePreview path={queryFileUrl(f.path)}
                               pathName={f.name}
                               type={'UploadCom'}
                               width={otherProps.readOnlyWebFileWidth || '100px'}
                               height={otherProps.readOnlyWebFileHeight || '100px'}
															 images={files?.map((item) => {
																return {
																	src: queryFileUrl(item.path),
                        					alt: '预览',
																};
															 })}
															 activeIndex={index2}
                  />
								</li>
							);
						}
						return (
							<li key={index2}>
								<a target="_blank" key={f.path} href={queryFileUrl(f.path)}>
									{f.name}
								</a>
							</li>
						);
					})}
				</ul>
			);
		} else {
			const files = !isEmpty(ary) ? ary : [];
			cm = (
				<ul className={styles.imageUl}>
					{Array.isArray(files) &&
						files.map((f, index2) => {
							if (get === 'web' || !isPrint) {
								return (
									<li key={index2}>
										<FilePreview path={queryFileUrl(f.path)} pathName={f.name} type={'UploadCom'} />
									</li>
								);
							}
							return (
								<li key={index2}>
									<a target="_blank" key={f.filePath} href={queryFileUrl(f.filePath)}>
										{f.fileName}
									</a>
								</li>
							);
						})}
				</ul>
			);
		}
	} else {
		cm = (
			<span
				style={{
					display: 'inline-block',
					width: '100%',
					textAlign: 'center',
				}}>
				暂无附件
			</span>
		);
	}

	return cm;
}
