// 图片上传组件
import React from 'react';
import { Button, Icon, message, Upload } from 'antd';
import { queryApiActionPath, queryFileUrl } from '../utils/queryConfig';
import config from '@/webPublic/one_stop_public/config';
import styles from './style.less';
import UploadComDiyForQnZy from '@/webPublic/one_stop_public/libs/UploadComDiyForQnZy';
import Viewer from 'react-viewer';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import {
  getSassApiHeader,
  getSysCode
} from '@/webPublic/one_stop_public/2023yunshangguizhou/utils';

message.config({
	top: 300,
});

export function checkIsImage(path) {
	if (!path) {
		return false;
	}
	if(typeof path !== 'string'){
	  return false;
  }
	let p = path.toLowerCase();
	let find = ['.jpg', '.png', '.jpeg', '.bmp', '.gif', '.bmp', '.svg'].find((x) => {
		return p.indexOf(x) > -1;
	});
	return !!find;
}

export default function index(props) {
	if (window.specialImportantSystemConfig && window.specialImportantSystemConfig.schoolName === '黔南民族职业技术学院' && window.location.href.indexOf('jy/geren/subsidy') > -1) {
		return <UploadComDiyForQnZy {...props} />;
	} else {
		return <UploadCom {...props} />;
	}
}

/**
 *
 * otherProps: {
 *   limitImageSize: {
 *     width:  number// 限制上传的图片的最小宽度
 *     height: number// 限制上传的图片的最小高度
 *     widthMinusHeight: number// 限制必须宽度大于高度 且 宽度 - 高度 >= widthMinusHeight
 *   }
 *   limitWarnningMessage: string// 当图片不满足限制条件时 提示语句
 *   limitImageInfo: string// 在上传按钮旁展示的提示语句
 * }
 * */

class UploadCom extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.state = {
			files: value.files,
			previewVisible: false,
			previewImage: '',
		};
		this.otherProps = {};
		if (props.json?.otherProps) {
			try {
				this.otherProps = new Function(props.json?.otherProps)() || {};
			} catch (e) {
			  console.log(e);
      }
		}
		this.limitImageInfo = this.otherProps?.limitImageInfo || props.json.limitImageInfo || '';
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(Object.assign({}, this.state, changedValue));
		}
	};

	//图片上传之前进行判断
	beforeUpload = (file) => {
	  const { limitImageSize, onlyPdf } = this.otherProps;
	  if(limitImageSize){ // 限制上传图片大小
      return this.isSize(file).then((res) => {
        message.info('正在上传中,请等待');
        return true;
      });
    }else if(onlyPdf){ // 限制只能上传pdf文件
	    let name = file.name;
	    if(!name || !name.endsWith('.pdf')){
	      message.warn('请上传pdf文件');
	      return false;
      }
    }
	  return true;

	};

	//检测尺寸
	isSize = (file) => {
		const { limitWarnningMessage } = this.otherProps;
		return new Promise((resolve, reject) => {
			let { width, height, widthMinusHeight } = this.otherProps.limitImageSize;
			let _URL = window.URL || window.webkitURL;
			let img = new Image();
			img.onload = function() {
				let valid = img.width >= width && img.height >= height;
				if (!!widthMinusHeight && valid) {
					if (widthMinusHeight > 0) {
						if (img.width - img.height < widthMinusHeight) {
							// widthMinusHeight: number// 限制必须宽度大于高度 且 宽度 - 高度 >= widthMinusHeight
							valid = false;
						}
					}
					if (widthMinusHeight < 0) {
						if (img.height - img.width < Math.abs(widthMinusHeight)) {
							// widthMinusHeight: number// 限制必须高度大于宽度
							valid = false;
						}
					}
				}
				valid ? resolve() : reject();
			};
			img.src = _URL.createObjectURL(file);
		}).then(
			() => {
				return file;
			},
			() => {
				message.error(file.name + limitWarnningMessage);
				return Promise.reject();
			},
		);
	};

	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps) {
			const value = nextProps.value;
			this.setState(value);
		}
	}

	changeUrl = (info) => {
		if (info.file.status === 'done') {
			message.success(`${info.file.name} 上传成功`);
			const files = this.state.files;
			files.push({ path: info.file.response, name: info.file.name });
			if (!('value' in this.props)) {
				this.setState({ files });
			}
			this.triggerChange({ files });
		} else if (info.file.status === 'error') {
			message.error(`${info.file.name} 上传失败`);
		}
	};
	remove = (path) => {
		const files = this.state.files;
		for (var i = 0; i < files.length; i++) {
			if (files[i].path == path) {
				files.splice(i, 1);
				break;
			}
		}
		if (!('value' in this.props)) {
			this.setState({ files });
		}
		this.triggerChange({ files });
	};

	render() {
	  // console.log(this.props.value);
		const { files, previewVisible, previewImage, previewImageName } = this.state;
		const { isMultiple, accept, btnName, disabled, dataKey } = this.props;
		const props = {
			name: 'file',
			multiple: isMultiple,
			accept: accept,
      headers: getSassApiHeader(),
      data: {
        token: getToken(),
      },
			action: config.uploadUrl,
			showUploadList: false,
			onChange: this.changeUrl,
      // beforeUpload: this.otherProps?.limitImageSize ? this.beforeUpload : undefined,
      beforeUpload: this.beforeUpload
		};
		return (
			<div data-mes={dataKey}>
				{' '}
				<Upload {...props} disabled={disabled}>
					{!disabled && (
						<>
							<Button>
								<Icon type="upload" />
								{btnName ? btnName : '上传附件'}
							</Button>
							{this.limitImageInfo && <div style={this.otherProps?.limitImageInfoStyle || {}}>{this.limitImageInfo}</div>}
						</>
					)}
				</Upload>
				<ul className={styles.ulImageList}>
					{((Array.isArray(files) && files) || []).map((f) => {
					  // console.log(f);
						if (f.path && checkIsImage(f.path)) {
							return (
								<li key={f.path} className={styles.preview_img}>
									<div className={styles.preview_div}>
										<img
											style={{ width: '100px', height: 'auto' }}
											className={styles.img}
											src={queryFileUrl(f.path)}
										/>
										<div
											className={styles.mask}
											onClick={() => {
												this.setState({
													previewImage: queryFileUrl(f.path),
                          previewImageName : f.name,
                          previewVisible: true,
                        });
											}}>
											<Icon type="eye" className={styles.icon_eye} />
										</div>
									</div>
									{!disabled && (
										<Icon
											style={{ marginLeft: 10 }}
											type="delete"
											onClick={this.remove.bind(this, f.path)}
										/>
									)}
								</li>
							);
						}
						return (
							<li key={f.path}>
								<a target="_blank" key={f.path} href={queryFileUrl(f.path)}>
									{f.name}
								</a>{' '}
								{!disabled && (
									<Icon
										style={{ marginLeft: 10 }}
										type="delete"
										onClick={this.remove.bind(this, f.path)}
									/>
								)}
							</li>
						);
					})}
				</ul>
					<Viewer
						visible={previewVisible}
						onClose={() => {
							this.setState({ previewVisible: false });
						}}
						images={[
							{
								src: previewImage,
								alt: previewImageName,
							},
						]}
					/>
			</div>
		);
	}
}
