import React from "react";
import { Button, Icon, message, Upload } from "antd";
import { queryApiActionPath, queryFileUrl } from '../utils/queryConfig';
import config from "@/webPublic/one_stop_public/config";
import styles from "./style.less";
import { checkIsImage } from "./UploadCom";
import Viewer from "react-viewer";
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { getHeaders } from '@/webPublic/zyd_public/utils/utils';
import {
  getSassApiHeader,
  getSysCode
} from '@/webPublic/one_stop_public/2023yunshangguizhou/utils';


// 为黔南职院单独写的 上传组件 用于 bug 20576 个人就业信息/求职创业补贴申报，201801010006 119242 上传图片加限制，跟签约派遣上传图片加限制一样
// 后续考虑修改 一站式组件 让组件支持所有功能
export default class UploadComDiyForQnZy extends React.Component {
  constructor(props) {
    super(props);
    const value = props.value || {};
    this.state = {
      files: value.files,
      previewVisible: false,
      previewImage: ""
    };
  }

  //图片上传之前进行判断
  beforeUpload = (file) => {
    return this.isSize(file).then((res) => {
      message.info("正在上传中,请等待");
      return true;
    });
  };

  //检测尺寸
  isSize = (file) => {
    return new Promise((resolve, reject) => {
      let width = 1080; //宽高限制为1080 * 1080 原来为2400 * 2400
      let height = 1080;
      let _URL = window.URL || window.webkitURL;
      let img = new Image();
      img.onload = function() {
        let valid = img.width >= width && img.height >= height;
        valid ? resolve() : reject();
      };
      img.src = _URL.createObjectURL(file);
    }).then(() => {
        return file;
      },
      () => {
        message.error(file.name + "图片尺寸不符合要求，需要上传高清图像 1080像素及以上,请修改后重新上传！");
        return Promise.reject();
      }
    );
  };

  triggerChange = (changedValue) => {
    // Should provide an event to pass value to Form.
    const onChange = this.props.onChange;
    if (onChange) {
      onChange(Object.assign({}, this.state, changedValue));
    }
  };

  componentWillReceiveProps(nextProps) {
    // Should be a controlled component.
    if ("value" in nextProps) {
      const value = nextProps.value;
      this.setState(value);
    }
  }

  changeUrl = (info) => {
    if (info.file.status === "done") {
      message.success(`${info.file.name} 上传成功`);
      const files = this.state.files;
      files.push({ path: info.file.response, name: info.file.name });
      if (!("value" in this.props)) {
        this.setState({ files });
      }
      this.triggerChange({ files });
    } else if (info.file.status === "error") {
      message.error(`${info.file.name} 上传失败`);
    }
  };
  remove = (path) => {
    const files = this.state.files;
    for (var i = 0; i < files.length; i++) {
      if (files[i].path == path) {
        files.splice(i, 1);
        break;
      }
    }
    if (!("value" in this.props)) {
      this.setState({ files });
    }
    this.triggerChange({ files });
  };

  render() {
    const { files, previewVisible, previewImage,previewImageName } = this.state;
    const { isMultiple, accept, btnName, disabled } = this.props;
    const props = {
      name: "file",
      multiple: isMultiple,
      accept: accept,
      ...getHeaders(),
      action: config.uploadUrl,
      showUploadList: false,
      onChange: this.changeUrl,
      beforeUpload: this.beforeUpload,
      headers: getSassApiHeader(),
      data: {
        token: getToken(),
      },
    };

    return (
      <div>
        {" "}
        <Upload {...props} disabled={disabled}>
          {!disabled && (
            <>
              <Button>
                <Icon type="upload" />
                {btnName ? btnName : "上传附件"}
              </Button>
              <div>
                （注：必须上传高清扫描件,图像高至少是1080px，宽至少是1080px）
              </div>
            </>
          )}
        </Upload>
        <ul style={{ paddingLeft: 8, display: "flex" }}>
          {(files || []).map((f) => {
            if (f.path && checkIsImage(f.path)) {
              return (
                <li key={f.path} className={styles.preview_img}>
                  <div className={styles.preview_div}>
                    <img
                      style={{ width: 100, height: 100 }}
                      className={styles.img}
                      src={queryFileUrl(f.path)}
                    />
                    <div
                      className={styles.mask}
                      onClick={() => {
                        this.setState({
                          previewVisible: true,
                          previewImage: queryFileUrl(f.path),
                          previewImageName: f.name,
                        });
                      }}>
                      <Icon type="eye" className={styles.icon_eye} />
                    </div>
                  </div>
                  {!disabled && (
                    <Icon
                      style={{ marginLeft: 10 }}
                      type="delete"
                      onClick={this.remove.bind(this, f.path)}
                    />
                  )}
                </li>
              );
            }
            return (
              <li key={f.path}>
                <a target="_blank" key={f.path} href={queryFileUrl(f.path)}>
                  {f.name}
                </a>{" "}
                {!disabled && (
                  <Icon
                    style={{ marginLeft: 10 }}
                    type="delete"
                    onClick={this.remove.bind(this, f.path)}
                  />
                )}
              </li>
            );
          })}
        </ul>
        <Viewer
          visible={previewVisible}
          onClose={() => {
            this.setState({ previewVisible: false });
          }}
          images={[
            {
              src: previewImage,
              alt: previewImageName,
            },
          ]}
        />
      </div>
    );
  }
}
