import React from 'react';
import { extend } from 'umi-request';
import queryConfig from './queryConfig';

import { Upload, message } from 'antd';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import {
  getSassApiHeader,
  getSysCode
} from '@/webPublic/one_stop_public/2023yunshangguizhou/utils';

const getToken = () => {
	const x = localStorage.getItem('uploadVideoServiceToken');
	if (x === 'null' || x === 'undefined') {
		return null;
	}
	return x;
};

const configService = queryConfig('uploadVideoService');

const token = getToken();

const umiRequest = extend({
	// errorHandler, // 默认错误处理
	credentials: 'include', // 默认请求是否带上cookie
	mode: 'cors',
});

export default class VideoUploadCom extends React.Component {
	constructor(props) {
		super(props);
		const { value } = props;
		let url = value;
		if (isJSON(value)) {
			url = JSON.parse(value).url;
		}
		this.state = {
			url: url || '',
		};
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(changedValue);
		}
	};

	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps) {
			const { value } = nextProps;
			if (isJSON(value)) {
				this.setState({
					url: JSON.parse(value).url,
				});
			}
		}
	}

	changeUrl = (info, key) => {
		if (info.file.status === 'done') {
			let filePathThis = info?.file?.response?.data?.filePath;
			message.info('正在获取视频缩略图,请稍后');
			if (filePathThis) {
				setTimeout(() => {
					umiRequest(`${configService}/folderConvertApi/videoScreenshot?token=${token}`, {
						method: 'POST', // 暂时支持post 请求
						headers: {
							Accept: 'application/json;charset=UTF-8',
							// 'Content-Type': 'application/json',
						},
						requestType: 'form',
						data: {
							path: filePathThis,
							screenshotTime: '00:00:5',
						},
					}).then((res) => {
						if (res && res.data) {
							let info = res.data;
							const { screenshots, url, createTime, downloadUrl, filePath, fileExt } = info;
							let needInfo = {
								screenshots,
								url,
								createTime,
								downloadUrl,
								filePath,
								fileExt,
							};
							message.success(`视频上传成功`);
							this.triggerChange(JSON.stringify(needInfo));
						}
					});
				}, 3000);
			}
		} else if (info.file.status === 'error') {
			message.error(`视频上传失败`);
		}
	};

	render() {
		const { json, disabled } = this.props;
		const { url } = this.state;
		return (
			<Upload.Dragger
				disabled={disabled}
				accept={'.mp4,.webm,.ogg'}
				url={url}
				showUploadList={false}
				name="file"
				action={configService + '/uploadFileApi/upload'}
				onChange={this.changeUrl}
        headers={
          getSassApiHeader()
        }
				multiple={false}
				data={{
					isConvert: true,
					token,
				}}
				style={{ padding: 0 }}>
				{url ? (
					<video
						src={url}
						controls
						style={{
							height: json.height,
							width: json.width,
						}}
					/>
				) : (
					<div style={{ height: json.height, width: json.width }} />
				)}
			</Upload.Dragger>
		);
	}
}
