import { Button } from 'antd';
import React, { useState, useEffect } from 'react';

export function FormListButtonDiy(props) {
  const [stateProps, setProps] = useState({ ...props });
  useEffect(() => {
    if (props.changeButtonProps && typeof props.changeButtonProps === 'function') {
      props.changeButtonProps({
        selectedRows: props.selectedRows,
        setProps,
        stateProps,
      });
    }
  }, [props.selectedRows]);

  const handleClick = e => {
    if (props.onClick && typeof props.onClick === 'function') {
      props.onClick(e, props.selectedRows, props.obj);
    }
  };
  return <Button {...stateProps} onClick={handleClick} obj={'formListButtonDiy'} children={props.children}/>;
}
