import React from 'react';
// import { FormattedMessage } from 'umi/locale';
import Link from 'umi/link';
import PageHeader from '../../../PageHeader';
import { connect } from 'dva';
import GridContent from './GridContent';
import styles from './index.less';
import MenuContext from './BasicLayout/MenuContext';

const PageHeaderWrapper = ({ children, contentWidth, wrapperClassName, top, ...restProps }) => {
	return (
		<div className={wrapperClassName}>
			{top}
			<MenuContext.Consumer>
				{(value) => (
					<PageHeader
						wide={contentWidth === 'Fixed'}
						home={''}
						{...value}
						key="pageheader"
						{...restProps}
						linkElement={Link}
						breadcrumbSeparator=">"
						itemRender={(item) => {
							// if (item.locale) {
							// 	return <FormattedMessage id={item.locale} defaultMessage={item.name} />;
							// }
							return item.name;
						}}
					/>
				)}
			</MenuContext.Consumer>
			{children ? (
				<div className={styles.content}>
					<GridContent>{children}</GridContent>
				</div>
			) : null}
		</div>
	);
};

export default connect(({ settings }) => ({
	contentWidth: settings.contentWidth,
}))(PageHeaderWrapper);
