const text = [
	'BINARY',
	'BIT',
	'BLOB',
	'CHAR',
	'GEOMETRY',
	'GEOMETRYCOLLECTION',
	'JSON',
	'LINESTRING',
	'LONGBLOB',
	'LONGTEXT',
	'MEDIUMBLOB',
	'MEDIUMINT',
	'MEDIUMTEXT',
	'MULTILINESTRING',
	'MULTIPOINT',
	'MULTIPOLYGON',
	'POINT',
	'POLYGON',
	'REAL',
	'DECIMAL',
	'ENUM',
	'SET',
	'TEXT',
	'TINYBLOB',
	'TIBYTEXT',
	'VARBINARY',
	'VARCHAR',
  'VARCHAR2',
  'NVARCHAR2',
];

const number = ['BIGINT', 'DOUBLE', 'FLOAT', 'INT', 'INTEGER', 'NUMERIC', 'SMALLINT', 'TINYINT'];

const date = ['DATE', 'DATETIME', 'TIME', 'TIMESTAMP', 'YEAR'];

const format = {
	DATE: 'YYYY-MM-DD',
	DATETIME: 'YYYY-MM-DD HH:mm:ss',
	TIME: 'HH:mm:ss',
	TIMESTAMP: 'YYYY-MM-DD HH:mm:ss',
	YEAR: 'YYYY',
};

const getFormArrayConfig = (header, isAdd, options) => {
	let config = [];
	for (let item of header) {
		if (item.isPrimaryKey) {
			if (!isAdd) {
				// 主键
				config.push({
					key: item.name,
					name: item.title,
					type: 'input',
					placeholder: `请输入${item.name}`,
					required: !item.isNull,
				});
			}
		} else if (item.referenceObjId != null) {
			const ops = options[item.id + ''] || [];
			const xx = [];

			for (var i = 0; i < ops.length; i++) {
				xx.push({ key: ops[i][item.referenceCodeName], name: ops[i][item.referenceNameName] });
			}

			config.push({
				key: item.name,
				name: item.title,
				type: 'select',
				placeholder: `请输入${item.name}`,
				required: !item.isNull,
				options: xx,
			});
		} else if (text.indexOf(item.type) > -1) {
			config.push({
				key: item.name,
				name: item.title,
				type: 'input',
				placeholder: `请输入${item.name}`,
				required: !item.isNull,
			});
		} else if (number.indexOf(item.type) > -1) {
			config.push({
				key: item.name,
				name: item.title,
				type: 'inputNumber',
				placeholder: `请输入${item.name}`,
				required: !item.isNull,
				min: 0,
			});
		} else if (date.indexOf(item.type) > -1) {
			config.push({
				key: item.name,
				name: item.title,
				type: 'datePicker',
				placeholder: `请输入${item.name}`,
				required: !item.isNull,
				format: format[item.type],
			});
		} else {
			config.push({
				key: item.name,
				name: item.title,
				type: 'input',
				placeholder: `请输入${item.name}`,
				required: !item.isNull,
			});
		}
	}
	return config;
};

export { text, number, date, getFormArrayConfig, format };
