export default function countWidth({
                                     json,
                                     uuid,
                                   }) {
  let showDiv = 500; // 列表宽度
  if (json.twidth) {
    // 列表宽度配置项 在 组件的 扩展的配置里面
    showDiv = json.twidth;
    return showDiv;
  }
  if(document.querySelector(`td[data-cell-id="${uuid}"]`)){
    // 左边可能有个树组件导致不能取学工里面的ant-layout-content 的宽度. 只能取父级td
    showDiv = document.querySelector(`td[data-cell-id="${uuid}"]`).clientWidth - 70;
    return showDiv;
  }
  if (document.getElementsByClassName('ant-layout-content')?.length) {
    // 这是大学工项目 容器元素的宽度
    showDiv = document.getElementsByClassName('ant-layout-content')[0].clientWidth - 100;
    // console.log(showDiv);
  }
  if (document.querySelector('#mobelDiv')) {
    showDiv = document.querySelector('#mobelDiv')?.parentNode.clientWidth;
    // 这个是一站式的元素的宽度
  }
  changeVisitor(json, uuid);
  // console.log('showDiv', showDiv);
  return showDiv;
}


/**
 * json
 * uuid
 * 变动观察器
 * 解决禅道 28008 生源地统计页面显示调整
 */
function changeVisitor(json, uuid) {
  if (!uuid) {
    return null;
  }
  let dom = document.querySelector(`td[data-cell-id="${uuid}"]`);
  if (!dom) {
    return null;
  }
  const targetNode = dom;

  // 配置器的配置：需要监听的变动
  const config = {
    characterData: true, // 监视指定目标节点或子节点树中节点所包含的字符数据的变化 无默认值。
    subtree: true, // 观察后代节点，默认为 false
    childList: true, // 观察目标子节点的变化，是否有添加或者删除
  };

  // 变动时回调
  const callback = function (mutations) {
    // console.log('变动观察器callback')
    if(!json.twidth){
      let dxx = document.querySelector(`td[data-cell-id="${uuid}"] .mobelDivClassName`);
      if(dxx && dxx.style.width === '500px'){
        dxx.style.width = document.querySelector(`td[data-cell-id="${uuid}"] .mobelDivClassName`)?.parentNode.clientWidth + 'px';
      }
    }
  };
  // 创建一个MutationObserver实例
  const observer = new MutationObserver(callback);
  // 监听目标节点
  observer.observe(targetNode, config);
  // observer.disconnect()

}
