import React from 'react';
import { Col, Form, message, Row } from 'antd';
import { connect } from 'dva';
import PageHeaderWrapper from './PageHeaderWrapper';
import router from 'umi/router';
import { getFormArrayConfig } from './config/index';
import FormArray from '../../App/ButtonDiy/FormArray';
import ButtonDiy from '../../App/ButtonDiy/ButtonDiy';
import Shell from './Shell';
import { getServicesNomal } from '../../Services/services'; 
import {
	getBatchOptionsApi,
	getFormDataApi,
	getHeaderListApi,
	addFormDataApi,
} from '../../Services/apiConfig';

@connect(({ formEdit, formList, loading }) => ({
	formEdit,
	formList,
}))
@Form.create()
class FormEdit extends React.Component {
	state = {
		modalVisible: false,
		formData: {},
		formItem: [],
		isAdd: this.props.location.state.isAdd,
		objId: this.props.location.state.id,
		recordId: this.props.location.state.recordId,
		recordKey: this.props.location.state.recordKey,
		options: {},
		isView: this.props.location.state.isView,
	};
	columns = [];

	//渲染值
	componentDidMount() {
		const { objId, recordKey, recordId } = this.state;
		getServicesNomal(getHeaderListApi, { dataObjId: objId }).then(dates => {
			if (dates) {
				this.state.formItem = dates;
				const refIds = [];
				for (let t in dates) {
					if (
						dates[t].referenceObjId != null &&
						this.state.options[this.state.formItem[t].id + ''] == null
					) {
						refIds.push(dates[t].id);
					}
				}

				if (refIds.length > 0) {
					getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
						this.setState({ options });
					});
				}
			}
		});
		//渲染表单字段
		if (recordId != null) {
			getServicesNomal(getFormDataApi, {
				dataObjId: objId,
				key: recordKey,
				value: recordId,
			}).then(date => {
				if (date) {
					this.state.formData = date;
				}
			});
		}
	}

	onSubmit = () => {
		const { isAdd, objId, formData } = this.state;
		let payload = {
			params: { ...formData },
			objId,
			isAdd,
			isSelf: true,
		};
		getServicesNomal(addFormDataApi, payload).then(() => {
			message.success('操作成功');
			router.goBack();
		});
	};

	goBack = () => {
		router.goBack();
	};

	changeFormData = (value, key) => {
		let oldValue = this.state.formData;
		oldValue[key] = value;
		this.setState({
			formData: oldValue,
		});
	};

	render() {
		const { getFieldDecorator } = this.props.form;

		const { formItem, formData, isAdd, options, isView } = this.state;

		return (
			<PageHeaderWrapper title="">
				<Shell>
					<Row>
						<FormArray
							config={getFormArrayConfig(formItem, isAdd, options)}
							nameSpan={{ big: 10, small: 12 }}
							fileSpan={{ big: 4, small: 3 }}
							value={formData}
							changeValue={this.changeFormData}
						/>
						<Col
							span={24}
							style={{ textAlign: 'center', paddingTop: '200px', paddingBottom: '50px' }}>
							{!isView ? (
								<ButtonDiy className={'primaryBlue'} handleClick={this.onSubmit} name={'保存'} />
							) : (
								''
							)}
							<ButtonDiy className={'defaultRed'} handleClick={this.goBack} name={'返回'} />
						</Col>
					</Row>
				</Shell>
			</PageHeaderWrapper>
		);
	}
}

export default FormEdit;
