import React, { Fragment } from 'react';
import {
  Button,
  Card,
  DatePicker,
  Divider,
  Form,
  Row,
  Col,
  Input,
  message,
  Select,
  Tooltip,
  Spin,
  Popover,
  Checkbox,
} from 'antd';
import { connect } from 'dva';
import PageHeaderWrapper from './PageHeaderWrapper';
import styles from './TableList.less';
import StandardTable from './StandardTable';
import moment from 'moment';
import router from 'umi/router';
import ExportInfo from '../../App/ExportInfo';
import ExportCurrentInfo from '../../App/ExportCurrentInfo';
import StatisticsInfo from '../../App/StatisticsInfo';
import ImportUtil from '../../App/ImportUtil';
import SearchInfo from '../../App/SearchInfo';
import { Base16Encode } from '../../Base16/index';
import { isEmpty } from 'lodash';
import FilePreview from '@/webPublic/one_stop_public/filePreview';
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
import UploadCom from '@/webPublic/one_stop_public/libs/UploadCom';
import { cloneDeep } from '../../copy/index';
import { getPopconfirm, getModal } from '@/webPublic/one_stop_public/utils/utils';
import { text, number, date } from '@/webPublic/one_stop_public/libs/formList/config';
import { FormListButtons } from '@/webPublic/one_stop_public/libs/formList/FormListButtons';
import countWidth from '@/webPublic/one_stop_public/libs/formList/countWidth';
import { getFormDataPage, getServicesNomal } from '../../Services/services';
import {
  getHeaderListApi,
  getBatchOptionsApi,
  getFormDataApi,
  deleteFormDataApi,
  getDetailByCodeApi,
  findByCodeApi,
  getDetailApi,
  addFormDataApi,
  getGroupListApi,
} from '../../Services/apiConfig';
import { FormListButtonDiy } from '@/webPublic/one_stop_public/libs/formList/FormListButtonDiy';
import UploadZipCom from './UploadZipCom.js';
const FormItem = Form.Item;
const Popconfirm = getPopconfirm();
const Modal = getModal();
let AllWidth = 0; // 表格总长度
const { RangePicker } = DatePicker;

const CreateForm = Form.create()((props) => {
  const {
    modalVisible,
    form,
    handleAdd,
    formData,
    isAdd,
    handleModalVisible,
    formItem,
    getItem,
    isView,
  } = props;

  //通过回调
  const okHandle = () => {
    form.validateFields((err, fieldsValue) => {
      if (err) return;
      if (isView) {
        handleModalVisible();
        return;
      }
      formItem.map((item, index) => {
        if (item.type.indexOf('DATE') > -1) {
          for (let d in fieldsValue) {
            if (item.name === d && fieldsValue[d]) {
              //处理日期何时入库问题
              try {
                fieldsValue[d] = fieldsValue[d].format('YYYY-MM-DD HH:mm:ss');
              } catch (e) {
              }
              break;
            }
          }
        } else if (number.includes(item.type)) {
          for (let d in fieldsValue) {
            if (item.name === d && fieldsValue[d] == '') {
              fieldsValue[d] = null;
              break;
            }
          }
        }
      });
      let params = { ...fieldsValue };
      handleAdd(params, isAdd);
    });
  };

  //需要获取动态表单
  return (
    <Modal
      width="700px"
      maskClosable={false}
      destroyOnClose
      title={isView ? '查看详情' : isAdd ? '新增' : '编辑'}
      visible={modalVisible}
      footer={
        isView
          ? null
          : [
            <Button key="back" onClick={() => handleModalVisible()}>
              取消
            </Button>,
            <Button key="submit" type="primary" onClick={okHandle}>
              确定
            </Button>,
          ]
      }
      onOk={okHandle}
      onCancel={() => handleModalVisible()}>
      {formItem.map((item, index) =>
        getItem(false, form, item, isAdd, formData, { span: 5 }, { span: 15 }),
      )}
    </Modal>
  );
});

// @connect(({
//             formList,
//             DataColumn,
//             DataObj
//           }) => ({
//   formList,
//   DataColumn,
//   DataObj,
//   // loading: loading.models.formList || loading.models.DataColumn || loading.models.DataObj,
//   // loading: loading.models.formList,
//   // 解决 禅道  28100 查询下拉选择后界面会刷新一次
//   // https://blog.csdn.net/m0_37148591/article/details/103685339 dva-loading
// }))
@Form.create()
class FormList extends React.Component {
  state = {
    data: {
      list: [],
      pagination: {},
    },
    selects: [],
    modalVisible: false,
    formData: null,
    formValues: {},
    formItem: [],
    objId: this.props.objId || (this.props.location ? this.props.location.state.id : null),
    isAdd: false,
    querys: [],
    selectedRows: [],
    primaryKey: null,
    options: {},
    isTable: true,
    tableWidth: 500,
    rights: this.props.rights || [],
    columnRights: [],
    isReady: false,
    groups: {},
    showMobileDiv: '',
    isView: false,
    checkedList: [], // 复选框默认选中
    cacheColumns: '', // 初始表头缓存数据 后续不做增删改查
    loading: false,
  };

  columns = [];
  checkList = []; // 复选框内容
  getOptions = () => {
    const refIds = [];
    for (var i = 0; i < this.state.formItem.length; i++) {
      if (
        this.state.formItem[i].referenceObjId != null &&
        this.state.options[this.state.formItem[i].id + ''] == null
      ) {
        refIds.push(this.state.formItem[i].id);
      }
    }

    if (refIds.length > 0) {
      getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
        this.setState({ options: { ...this.state.options, ...options } });
      });
    }
  };
  modify = (record) => {
    //  if (this.state.formItem.length < 10) {
    this.getOptions();
    getServicesNomal(getFormDataApi, {
      dataObjId: this.state.objId,
      key: this.state.primaryKey,
      value: record[this.state.primaryKey],
      isBase: false,
    }).then(record2 => {
      this.setState({
        formData: record2,
        modalVisible: true,
        isAdd: false,
        isView: false,
      });
    });
  };

  view = (record) => {
    this.getOptions();
    this.setState({
      formData: record,
      modalVisible: true,
      isAdd: false,
      isView: true,
    });
  };z

  isJSON = (str) => {
    if (typeof str == 'string') {
      try {
        var obj = JSON.parse(str);
        if (typeof obj == 'object' && obj) {
          return true;
        } else {
          return false;
        }
      } catch (e) {
        console.log('error：' + str + '!!!' + e);
        return false;
      }
    }
    console.log('这不是个字符串');
  };

  delete = (record) => {
    //找出主键
    let Keys = {};
    Keys[this.state.primaryKey] = record[this.state.primaryKey];
    getServicesNomal(deleteFormDataApi, {
      keys: JSON.stringify(Keys),
      objId: this.state.objId,
    }).then(res => {
        this.getPage();
    });
  };

  viewProcess = (record) => {
    getServicesNomal(getDetailByCodeApi, { code: record.process_biz_key }).then(data => {
      const domainName = sessionStorage.getItem('domainName')
      ? sessionStorage.getItem('domainName')
      : '';

      window.open(domainName + '/portal/serviceCentre/getdetail?id=' + data.id, '_blank');
      //router.push({ pathname: '/portal/serviceCentre/getdetail', state: { id: data.id } });
    });
  };

  /**
   * 宽度自适应函数
   */
  resize = (e) => {
    let scrollWidth = document.documentElement.clientWidth || document.body.clientWidth; //可使宽度
    let showMobileDiv = scrollWidth - 77;
    if (document.querySelector('#previewDiv')) {
      // 预览模式
      this.setState({
        showMobileDiv: document.querySelector('#previewDiv').clientWidth - 77,
      });
    } else {
      this.setState({
        showMobileDiv,
      });
    }
  };

  //渲染值
  componentDidMount() {
    window.addEventListener('resize', this.resize);

    if (this.props.objCode) {
      const {
        objCode,
        sql
      } = this.props;

      if (Number(objCode) === 1) {
        this.initColumn();
      } else {
        // DataObj models层中的数据
        getServicesNomal(findByCodeApi, { objCode: this.props.objCode }).then(dataObj => {
          if(dataObj && dataObj.id){
            this.setState(
              {
                objId: dataObj.id,
                isTable: dataObj.isTable,
              },
              () => {
                this.initColumn();
              })
          }

        });
      }
    } else {
      getServicesNomal(getDetailApi, { id: this.state.objId }).then(data => {
        this.setState({ isTable: data.isTable });
      });
      /**
       * 2022年10月27日
       * 欢哥说这个权限功能没用了
       * 问了姚新国也说没用了
       * */
      this.initColumn();
    }
  }

  /**
   * 移除监听器
   */
  componentWillUnmount() {
    window.removeEventListener('resize', this.resize);
  }

  custom = this.props.value ? JSON.stringify(this.props.value) : null;

  componentWillReceiveProps(nextProps) {
    const b = nextProps.value || {};
    const a = this.props.value || {};
    const jsonb = JSON.stringify(b);
    const jsona = JSON.stringify(a);
    this.custom = jsonb;
    if (jsona != jsonb) {
      let params = {
        pageNo: b.pageNo ? b.pageNo : 1,
        pageSize: b.pageSize ? b.pageSize : this.state.data.pagination.pageSize,
        query: JSON.stringify(this.state.formValues),
      };

      if (nextProps.value.columns != null && nextProps.value.columns.length > 0) {
        this.columns = nextProps.value.columns;
      }
      if (nextProps.value.selectedRows && Array.isArray(nextProps.value.selectedRows)) {
        // 27867 就业市场/线上招聘管理/职位信息审核，胡林那 hulinnaAdmin 马上审核通过的职位直接发布 发布不了
        this.setState({
          selectedRows: nextProps.value.selectedRows,
        });
      }

      if (nextProps.value.getPage) {
        this.getPage(params, null, nextProps.value.getPage);
      } else {
        if (this.state.objId) {
          this.getPage(params);
        }
      }
    }
    const x = nextProps.selects;
    const y = this.props.selects;
    if (JSON.stringify(x) != JSON.stringify(y)) {
      this.setState({ selects: x });
    }
  }

  initColumn = () => {
    const {
      value,
      objCode
    } = this.props;
    const {
      rights,
      columnRights
    } = this.state;
    if (value && value.columns) {
      this.columns = value.columns;
      let cacheList = [];
      let cacheChecked = [];
      // 表头筛选逻辑
      Array.isArray(value.columns) &&
      value.columns.map((item) => {
        if (item.dataIndex != null) {
          cacheList.push({
            label: item.title,
            value: item.dataIndex,
          });
          cacheChecked.push(item.dataIndex);
        }
      });
      this.checkList = cacheList;

      this.setState({
        checkedList: cacheChecked,
        cacheColumns: cloneDeep(value.columns),
      });
      if (Number(objCode) === 1) {
        this.getPage();
      } else {
        if (this.props.json?.isDiy !== 'false' && this.props.json?.isDiy !== false) {
          // 2022年11月8日 姚鑫国说的 开起了这个 自定义模式 就不调接口查表头了. 也不调接口查枚举项那些
          // 2022年12月12日 姚新国说的 没配这个东西都搞成 true  qq 聊天记录
          this.getPage();
          return undefined;
        }
        getServicesNomal(getHeaderListApi, { dataObjId: this.state.objId }).then(datas => {
          this.state.formItem = datas;
            const querys = [];
            const groups = {};
            const refIds = [];
            for (let t in datas) {
              if (datas[t].isPrimaryKey) this.state.primaryKey = datas[t].name;
              if (datas[t].isShowQuery) {
                querys.push(datas[t]);
                if (datas[t].referenceObjId != null) {
                  refIds.push(datas[t].id);
                }
                if (datas[t].isGroupQuery != null) {
                  getServicesNomal(getGroupListApi, { columnId: datas[t].id }).then(gourp => {
                    groups[datas[t].id] = gourp;
                    this.setState({ groups });
                  });
                }
              }
            }
            if (querys.length > 0) {
              this.setState({ querys });
              if (refIds.length > 0) {
                getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
                  this.setState({ options });
                });
              }
            }
            this.getPage();
        });
      }
      return;
    }

    if (Number(objCode) === 1) {
    } else {
      const isDiy = this.props.json?.isDiy;
      if (isDiy !== 'false' && isDiy !== false && typeof isDiy !== 'undefined') {
        // 2022年11月8日 姚鑫国说的 开起了这个 自定义模式 就不调接口查表头了.
        // 2022年12月12日 姚新国说的 没配这个东西都搞成 true  qq 聊天记录
        this.getPage();
        return undefined;
      }
      getServicesNomal(getHeaderListApi, { dataObjId: this.state.objId }).then(datas => {
        const querys = [];
        const refIds = [];
        const groups = {};
        if (datas) {
          this.state.formItem = datas;
          let i = 0;
          let cacheList = [];
          let cacheChecked = [];
          // 表头筛选逻辑
          datas.map((item) => {
            if (item.name != null) {
              cacheList.push({
                label: item.title,
                value: item.name,
              });
              cacheChecked.push(item.name);
            }
          });
          this.checkList = cacheList;
          this.setState({
            checkedList: cacheChecked,
          });
          for (let t in datas) {
            if (datas[t].isPrimaryKey) this.state.primaryKey = datas[t].name;
            if (datas[t].isHidden) {
              continue;
            }
            let column = {};
            column.title = datas[t].title;
            column.dataIndex = datas[t].name;
            column.width = datas[t].width;
            if (i == 0) column.fixed = 'left';

            if (columnRights.length > 0 && !columnRights.includes(datas[t].id)) {
              continue;
            }
            if (date.includes(datas[t].type)) {
              column.render = (val) => {
                if (val == null) {
                  return val;
                }
                if (datas[t].dataFormatStrWeb != null) {
                  return moment(val)
                    .format(datas[t].dataFormatStrWeb);
                } else {
                  return moment(val)
                    .format('YYYY-MM-DD HH:mm:ss');
                }
              };
            } else if (datas[t].name.indexOf('process_status') > -1) {
              column.render = (val) => (val ? (val === '0' ? '审核通过' : '审核未通过') : null);
            } else if (datas[t].extendTypeId && datas[t].extendTypeId.indexOf('file') > -1) {
              //特殊处理附件
              column.render = (val) => {
                if (this.isJSON(val)) {
                  val = JSON.parse(val);
                  let files = val.files;
                  let xx = (
                    <ul>
                      {files.map((f, index2) => {
                        return (
                          <li key={index2}>
                            <FilePreview
                            path={queryFileUrl(f.path)}
                            pathName={f.name}
                            images={files?.map((item) => {
                              return {
                                src: queryFileUrl(item.path),
                                alt: '预览',
                              };
                             })}
                             activeIndex={index2}
                            />
                          </li>
                        );
                      })}
                    </ul>
                  );
                  return xx;
                } else {
                  return val;
                }
              };
            } else {
              column.render = (val) =>
                val && val.length > 100 ? (
                  <Tooltip title={val} overlayStyle={{ width: 1000 }}>
                    <span
                      style={{
                        width: column.width || 200,
                        display: 'block',
                        wordBreak: 'keep-all',
                        whiteSpace: 'nowrap',
                        overflow: 'hidden',
                        textOverflow: 'ellipsis',
                      }}>
                      {val}
                    </span>
                  </Tooltip>
                ) : (
                  val
                );
            }

            this.setState({ tableWidth: (datas.length - 1) * 200 });
            this.columns.push(column);
            this.setState({
              cacheColumns: cloneDeep(this.columns),
            });
            if (datas[t].isShowQuery) {
              querys.push(datas[t]);
              if (datas[t].referenceObjId != null) {
                refIds.push(datas[t].id);
              }
              if (datas[t].isGroupQuery != null) {
                getServicesNomal(getGroupListApi, { columnId: datas[t].id }).then(gourp => {
                  groups[datas[t].id] = gourp;
                  this.setState({ groups });
                });
              }
            }
            i++;
          }
          if (querys.length > 0) {
            this.setState({ querys });
            if (refIds.length > 0) {
              getServicesNomal(getBatchOptionsApi, { ids: refIds }).then(options => {
                this.setState({ options });
              })
            }
          }

          this.getPage();
        }
      });
    }
  };
  sqlBs16 = this.props.sql;

  getPage = (params, values, callPage, pageNo) => {
    const { objCode } = this.props;
    if (!this.columns || !Array.isArray(this.columns) || this.columns.length === 0) {
      return;
    }
    const pagination = this.state.data.pagination;

    if (params == null) {
      params = {
        pageNo: pageNo != null ? pageNo : pagination.current ? pagination.current : 1,
        pageSize: pagination.pageSize ? pagination.pageSize : this.props.pageSize || 10,
        query: JSON.stringify(values != null ? values : this.state.formValues),
      };
    } else {
      if (params.pageNo == null && callPage == null && this.props.value.getPage == null) return;
    }

    if (Number(objCode) === 1) {
      if (callPage) {
        callPage(params, (data) => {
          if (!this.state.isReady) {
            this.setState({
              data,
              isReady: true,
            });
          } else {
            this.setState({ data });
          }
        });
      } else if (this.props.value && this.props.value.getPage) {
        this.props.value.getPage(params, (data) => {
          if (!this.state.isReady) {
            this.setState({
              data,
              isReady: true,
            });
          } else {
            this.setState({ data });
          }
        });
      }
    } else {
      this.setState({
        loading: true,
      });
      getFormDataPage({
        custom: this.custom,
        ...params,
        sql: this.sqlBs16,
        dataObjId: this.state.objId,
      }).then(data => {
        this.setState({
          loading: false,
        });
        if(!data){
          return null;
        }
        if (!this.state.isReady) {
          this.setState({
            data,
            isReady: true,
            selectedRows: [], // 姚鑫国说的 调了分页接口以后需要 把这个选择的行数据 清空
          });
        } else {
          this.setState({
            data,
            selectedRows: [], // 姚鑫国说的 调了分页接口以后需要 把这个选择的行数据 清空
          });
        }
      });
    }
  };

  handleStandardTableChange = (pagination, filtersArg, sorter) => {
    const filters = Object.keys(filtersArg)
      .reduce((obj, key) => {
        const newObj = { ...obj };
        newObj[key] = getValue(filtersArg[key]);
        return newObj;
      }, {});

    const params = {
      pageNo: pagination.current,
      pageSize: pagination.pageSize,
      ...filters,
      query: JSON.stringify(this.state.formValues),
    };
    if (sorter.field) {
      params.sorter = `${sorter.field}_${sorter.order}`;
    }
    this.getPage(params);
  };

  handleAdd = (fields, isAdd) => {
    let params = {
      ...fields,
    };
    getServicesNomal(addFormDataApi, {
      data: JSON.stringify(params),
      objId: this.state.objId,
      isAdd: isAdd,
      isSelf: true,
      isView: false,
    }).then(() => {
      message.success('操作成功');
      this.setState({
        modalVisible: false,
      });
      this.getPage();
    });
  };

  handleModalVisible = () => {
    this.setState({
      modalVisible: this.state.modalVisible ? false : true,
      formData: {},
      isView: false,
    });
  };

  add = () => {
    // if (this.state.formItem.length < 10) {
    this.getOptions();
    this.setState({
      modalVisible: true,
      formData: {},
      isAdd: true,
      isView: false,
    });
    // } else {
    //   router.push({
    //     pathname: '/admin/ddl/dataObj/formEdit',
    //     state: { id: this.state.objId,isAdd: true,isView:false }
    //   });
    // }
  };

  handleSelectRows = (rows) => {
    if (this.props.onSelectRow) {
      this.props.onSelectRow(rows);
    }
    this.setState({
      selectedRows: rows,
    });
  };

  batchDelete = (e) => {
    const { selectedRows } = this.state;

    if (!selectedRows) return;

    let columns = this.state.formItem;
    let Keys = {};

    for (let i in columns) {
      if (columns[i].isPrimaryKey) {
        //key
        Keys[columns[i].name] = selectedRows.map((row) => row[columns[i].name])
          .join(',');
      }
    }
    getServicesNomal(deleteFormDataApi, {
      keys: JSON.stringify(Keys),
      objId: this.state.objId,
      // isSelf: true,
    }).then(res => {
      this.setState({
        selectedRows: [],
      });
      this.getPage();
    });
  };

  goBack = () => {
    router.goBack();
  };
  handleSearch = (e) => {
    e.preventDefault();

    const {
      form
    } = this.props;

    const { formValues } = this.state;

    form.validateFields((err, fieldsValue) => {
      if (err) return;

      const formItem = this.state.formItem;
      formItem.map((item, index) => {
        if (item.type.indexOf('DATE') > -1) {
          for (let d in fieldsValue) {
            if (item.name === d && fieldsValue[d]) {
              if (fieldsValue[d] != null && fieldsValue[d].length > 0) {
                fieldsValue[d] = [
                  fieldsValue[d][0].format('YYYY-MM-DD HH:mm:ss'),
                  fieldsValue[d][1].format('YYYY-MM-DD HH:mm:ss'),
                ];
              } else {
                fieldsValue[d] = '';
              }
            }
          }
        }
      });
      const values = {
        ...this.state.formValues,
        ...fieldsValue,
      };
      this.setState({
        formValues: fieldsValue,
      });
      const params = {
        pageNo: 1,
        pageSize: this.props.pageSize || 10,
        query: JSON.stringify(values),
      };
      this.getPage(params, values, null, 1);
    });
  };

  hanldeHighSearch = (e) => {
    const pagination = this.state.data.pagination;
    let params = {
      pageNo: pagination.current ? pagination.current : 1,
      pageSize: pagination.pageSize ? pagination.pageSize : this.props.pageSize || 10,
      ...e,
    };
    this.setState({ formValues: { ...e, ...this.state.formValues } });
    this.getPage(params);
  };
  handleFormReset = () => {
    const { form } = this.props;
    form.resetFields();
    this.setState(
      {
        formValues: {},
      },
      () => {
        this.getPage();
      },
    );
  };
  getItem = (isQuery, form, item, isAdd, formData, labelCol, wrapperCol) => {
    const {
      groups,
      isView
    } = this.state;
    //如果隐藏的话 就用隐藏域放置
    if (item.isHidden) {
      return (
        <FormItem className={styles.hidden} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
          })(<Input type="hidden" placeholder="请输入"/>)}
        </FormItem>
      );
    }

    if (item.isPrimaryKey) {
      if (isAdd) {
        return <></>;
      } else {
        return (
          <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
            {form.getFieldDecorator(item.name, {
              initialValue: formData == null ? '' : formData[item.name],
              rules: [{ required: !item.isNull }],
            })(<Input style={{ width: '70%' }} readOnly={!isAdd} placeholder="请输入"/>)}
          </FormItem>
        );
      }
    } else if (item.referenceObjId != null) {
      const { options } = this.state;
      const ops = options[item.id + ''] || [];
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [{ required: !item.isNull }],
          })(
            <Select
              disabled={isView}
              style={{ width: '70%' }}
              optionFilterProp="children"
              showSearch
              filterOption={(input, option) =>
                option
                  ? option.props.children.toLowerCase()
                  .indexOf(input.toLowerCase()) >= 0
                  : false
              }
              placeholder="请选择"
              allowClear>
              {ops.map((r) => (
                <Option value={r[item.referenceCodeName]} key={r[item.referenceCodeName]}>
                  {r[item.referenceNameName]}
                </Option>
              ))}
            </Select>,
          )}
        </FormItem>
      );
    } else if (item.name.indexOf('process_status') > -1) {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [{ required: !item.isNull }],
          })(
            <Select disabled={isView} style={{ width: '70%' }} placeholder="请选择" allowClear>
              <Option value={'0'} key={'0'}>
                审核通过
              </Option>
              <Option value={'2'} key={'2'}>
                审核未通过
              </Option>
            </Select>,
          )}
        </FormItem>
      );
    } else if (item.extendTypeId && item.extendTypeId.indexOf('file') > -1) {
      //特殊处理附件 如果是查询就 跳过
      if (isQuery) return;
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue:
              formData == null
                ? ''
                : formData[item.name] && this.isJSON(formData[item.name])
                  ? JSON.parse(formData[item.name])
                  : null,
            rules: [{ required: !item.isNull }],
          })(<UploadCom disabled={isView}/>)}
        </FormItem>
      );
    } else if (isQuery && item.isGroupQuery != null && item.isGroupQuery) {
      //如果是查询 并且是组合查询

      const ops = groups[item.id + ''] || [];
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [{ required: !item.isNull }],
          })(
            <Select
              disabled={isView}
              style={{ width: 200 }}
              placeholder="请选择"
              optionFilterProp="children"
              showSearch
              filterOption={(input, option) =>
                option
                  ? option.props.children.toLowerCase()
                  .indexOf(input.toLowerCase()) >= 0
                  : false
              }
              allowClear>
              {ops.map((r) => (
                <Option value={r.value} key={r.value}>
                  {r.value}
                </Option>
              ))}
            </Select>,
          )}
        </FormItem>
      );
    } else if (text.indexOf(item.type) > -1) {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [{ required: !item.isNull }],
          })(<Input disabled={isView} style={{ width: '70%' }} placeholder="请输入"/>)}
        </FormItem>
      );
    } else if (number.indexOf(item.type) > -1) {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [
              { required: !item.isNull },
              (rule, value, callback) => {
                var errors = [];
                var reg = new RegExp(/(^-?[0-9][0-9]*(.[0-9]+)?)$/);
                if (value != null && value != '' && !reg.test(value)) {
                  errors.push(new Error('请输入'), rule.field);
                }
                callback(errors);
              },
            ],
          })(<Input disabled={isView} placeholder="请输入"/>)}
        </FormItem>
      );
    } else if (isQuery && date.indexOf(item.type) > -1) {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? null : moment(formData[item.name]),
            rules: [{ required: !item.isNull }],
          })(
            <RangePicker
              disabled={isView}
              format={item.dataFormatStrWeb == null ? 'YYYY-MM-DD HH:mm:ss' : item.dataFormatStrWeb}
              style={{ width: '95%' }}
            />,
          )}
        </FormItem>
      );
    } else if (date.indexOf(item.type) > -1) {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue:
              formData == null
                ? moment()
                : formData[item.name]
                  ? moment(formData[item.name])
                  : null,
            rules: [{ required: !item.isNull }],
          })(
            <DatePicker
              format={item.dataFormatStrWeb == null ? 'YYYY-MM-DD HH:mm:ss' : item.dataFormatStrWeb}
              style={{ width: '100%' }}
              placeholder="请输入"
              disabled={isView}
            />,
          )}
        </FormItem>
      );
    } else {
      return (
        <FormItem labelCol={labelCol} wrapperCol={wrapperCol} label={item.title} key={item.id}>
          {form.getFieldDecorator(item.name, {
            initialValue: formData == null ? '' : formData[item.name],
            rules: [{ required: !item.isNull }],
          })(<Input disabled={isView} style={{ width: '70%' }} placeholder="请输入"/>)}
        </FormItem>
      );
    }
  };

  renderForm() {
    const {
      form,
      get,
      json
    } = this.props;

    const { querys } = this.state;
    if (querys.length === 0 || json?.isHiddenSearch === true) {
      return '';
    }

    return (
      <Form layout="inline">
        <Row style={{ padding: '15px' }}>
          {querys.map((item) => (
            <Col style={{ height: 58 }} span={get === 'mobile' ? 24 : 8} key={item.id}>
              {this.getItem(
                true,
                form,
                {
                  ...item,
                  isNull: true,
                },
                true,
              )}
            </Col>
          ))}

          <Col
            span={get === 'mobile' ? 24 : 8}
            style={{
              textAlign: get === 'mobile' ? 'right' : '',
              paddingRight: get === 'mobile' ? 12 : '',
            }}>
						<span className={styles.submitButtons}>
							<Button type="primary" loading={this.state.loading} onClick={this.handleSearch}>
								查询
							</Button>
							<Button style={{ marginLeft: 8 }} onClick={this.handleFormReset}>
								重置
							</Button>
              {/* <a style={{ marginLeft: 8 }} onClick={this.toggleForm}>
                展开 <Icon type="down" />
              </a> */}
						</span>
          </Col>
        </Row>
      </Form>
    );
  }

  /**
   * @description: 表头筛选复选框 根据用户筛选将表头内容重置
   * @param { Array<string> } 用户选择参数
   * @return:
   */

  CheckboxChange = (checkedValues) => {
    if (checkedValues.length === 0) {
      message.error('至少选择一项');
      return;
    }
    const { cacheColumns } = this.state;
    let initList = [];
    checkedValues.map((item) => {
      let ary = cacheColumns.filter((data) => data.dataIndex === item);
      if (ary.length !== 0) {
        initList.push(ary[0]);
      }
    });
    this.columns = initList;
    this.setState({
      checkedList: checkedValues,
    });
  };

  render() {
    const {
      modalVisible,
      selectedRows,
      rights,
      data,
      isReady
    } = this.state;
    if (!isReady) {
      return (
        <div
          style={{
            width: 20,
            margin: 'auto',
          }}>
          <Spin/>
        </div>
      );
    }
    const {
      isFormCom,
      isSelect,
      get,
      callback,
      valueName,
      notShowBack,
      json,
      istableCom, // 是否有模板设计器调用
      value: { btns },
      uuid,
      obj,
    } = this.props;
    const {
      showMobileDiv,
      isView,
      loading
    } = this.state;

    let scrollWidth = document.documentElement.clientWidth || document.body.clientWidth; //可使宽度
    let isMobile = scrollWidth < 1000;
    if (document.querySelector('#previewDiv')) {
      isMobile = true;
    }

    const showDiv = countWidth({
      json,
      uuid,
    });
    const parentMethods = {
      handleAdd: this.handleAdd,
      handleModalVisible: this.handleModalVisible,
      formData: this.state.formData,
      formItem: this.state.formItem,
      isAdd: this.state.isAdd,
      getItem: this.getItem,
      isView: isView,
    };

    if (
      !isSelect &&
      !rights.includes('edit') &&
      !rights.includes('delete') &&
      !rights.includes('view') &&
      !rights.includes('viewProcess')
    ) {
    } else {
      let width = 0;
      if (rights && rights.includes('viewProcess')) {
        width = width + 120;
      }
      if (rights && rights.includes('view')) {
        width = width + 120;
      }
      if (rights && rights.includes('edit')) {
        width = width + 70;
      }
      if (rights && rights.includes('delete')) {
        width = width + 70;
      }
      const column = {
        title: '操作',
        fixed: 'right',
        width: width,
        render: (text, record) => {
          let Dom = [];
          if (isSelect) {
            if (this.state.selects.includes(record[valueName])) {
              Dom.push(<span>已选择</span>);
            } else {
              Dom.push(<a onClick={callback.bind(this, record, this.columns)}>选择</a>);
            }
          }
          if (rights) {
            if (rights.includes('view')) {
              Dom.push(<a onClick={this.view.bind(this, record)}>查看详情</a>);
            }
            if (rights.includes('edit')) {
              Dom.push(<a onClick={this.modify.bind(this, record)}>编辑</a>);
            }
            if (rights.includes('viewProcess') && record.process_biz_key) {
              Dom.push(<a onClick={this.viewProcess.bind(this, record)}>流程详情</a>);
            }
            if (rights.includes('delete')) {
              Dom.push(
                <Popconfirm
                  title="确定删除该数据?"
                  onConfirm={this.delete.bind(this, record)}
                  okText="确定"
                  cancelText="取消">
                  <a>删除</a>
                </Popconfirm>,
              );
            }
          }
          return (
            <Fragment>
              <div
                style={{
                  textAlign: 'center',
                  paddingLeft: '0px',
                  paddingRight: '0px',
                }}>
                {Dom &&
                Dom.length &&
                Dom.map((x, index) => (
                  <Fragment key={Math.random()}>
                    {x}
                    {index > 0 && index !== Dom.length - 1 && <Divider type="vertical"/>}
                  </Fragment>
                ))}
              </div>
            </Fragment>
          );
        },
      };
      if (this.columns.length > 0 && this.columns[this.columns.length - 1].title == '操作') {
        this.columns[this.columns.length - 1] = column;
      } else {
        this.columns.push(column);
      }
    }
    if (this.columns) {
      /**
       * 计算总长度
       */
      AllWidth = 0;
      this.columns = this.columns.map((item, index) => {
        if (isEmpty(item)) {
          return item;
        }
        if (
          index === this.columns.length - 1 &&
          this.columns[this.columns.length - 1].title !== '操作'
        ) {
          AllWidth += 150;
          item.width = '';
          return item;
        }
        let width = item.width ? item.width : 150;
        if (!item.width) {
          item.width = 150;
        }
        AllWidth += width;
        return item;
      });
      if (
        !isEmpty(this.columns[this.columns.length - 1]) &&
        this.columns[this.columns.length - 1].title === '操作'
      ) {
        if (this.columns[this.columns.length - 2]) {
          this.columns[this.columns.length - 2].width = '';
          AllWidth += 100;
        }
      }
    }
    const xxxx = (
      <>
        <Card
          bordered={false}
          bodyStyle={{
            padding: 0,
            width: json.twidth ? json.twidth : '100%',
          }}>
          <div className={styles.tableList}>
            <div className={styles.tableListForm}>{this.renderForm()}</div>
            <div className={styles.tableListOperator}>
              {notShowBack ? (
                notShowBack
              ) : (
                <Button icon="rollback" type="primary" onClick={this.goBack}>
                  返回
                </Button>
              )}

              <FormListButtons
                btns={btns}
                loading={loading}
                importConfig={(this.props.value && this.props.value.importConfig) || []}
                exportConfig={(this.props.value && this.props.value.exportConfig) || []}
                getPage={this.getPage}
                objId={this.state.objId}
                query={JSON.stringify(this.state.formValues)}
                custom={this.props.value ? Base16Encode(JSON.stringify(this.props.value)) : null}
                sql={Base16Encode(this.props.sql)}
                selectedRows={selectedRows}
                obj={obj}
              />
              {this.props.value && this.props.value.uploadZipConfig
                ? this.props.value.uploadZipConfig.map((r, i) => (
                  <UploadZipCom
                    dataObjId={this.state.objId}
                    config={r}
                  />
                ))
                : ''}
              {rights && !rights.includes('add') ? (
                ''
              ) : (
                <Button icon="plus" type="primary" onClick={this.add}>
                  新建
                </Button>
              )}
              {rights && !rights.includes('searchData') ? (
                ''
              ) : (
                <SearchInfo hanldeHighSearch={this.hanldeHighSearch} objId={this.state.objId}/>
              )}

              {rights && !rights.includes('importData') ? (
                ''
              ) : (
                <ImportUtil objId={this.state.objId} callback={() => this.getPage()}/>
              )}

              {rights && !rights.includes('exportCurrent') ? (
                ''
              ) : (
                <ExportCurrentInfo
                  objId={this.state.objId}
                  query={JSON.stringify(this.state.formValues)}
                  custom={this.props.value ? Base16Encode(JSON.stringify(this.props.value)) : null}
                  sql={Base16Encode(this.props.sql)}
                />
              )}

              {rights && !rights.includes('exportData') ? (
                ''
              ) : (
                <ExportInfo objId={this.state.objId}/>
              )}
              {rights && !rights.includes('statistics') ? (
                ''
              ) : (
                <StatisticsInfo objId={this.state.objId}/>
              )}
              {rights && !rights.includes('delete')
                ? ''
                : selectedRows.length > 0 && (
                <span>
											<Popconfirm
                        title="确定删除该数据?"
                        onConfirm={this.batchDelete}
                        okText="确定"
                        cancelText="取消">
												<Button>批量删除</Button>
											</Popconfirm>
										</span>
              )}
              {rights && !rights.includes('headerFilter') ? (
                ''
              ) : (
                <Popover // 划入选择栏
                  content={
                    <div
                      style={{
                        width: 150,
                      }}>
                      <Checkbox.Group
                        onChange={this.CheckboxChange}
                        value={this.state.checkedList}
                        options={this.checkList}
                      />
                    </div>
                  }
                  title="请选择表头展示"
                  trigger="click"
                  placement="bottom">
                  <Button // 表头筛选控件
                    className={styles.filter_btn}
                    icon="filter">
                    表头筛选
                  </Button>
                </Popover>
              )}
              {btns && btns.after && btns.after.length > 0
                ? btns.after.map((r, index) => (
                    <FormListButtonDiy
                      {...r}
                      key={index.toString()}
                      loading={loading}
                      selectedRows={selectedRows}
                      obj={this.props.obj}
                    />
                  ))
                : ''}

              {!!this.props.otherProps &&
              !!this.props.otherProps.showRightTips &&
              this.props.otherProps.RightTipsComponent}
            </div>
            {!istableCom || (this.props.value && this.props.value.columns) ? (
              <div
                id="mobelDiv"
                className={'mobelDivClassName'}
                data-tag={'/libs/formList/index.js-1431'}
                style={{
                  overflow: 'hidden',
                  width: isMobile ? showMobileDiv : showDiv,
                  height: '100%',
                }}>
                {showDiv && (
                  <StandardTable
                    showHeader={this.props.showHeader != null ? this.props.showHeader : true}
                    noSelectRow={
                      this.props.onSelectRow == null &&
                      (rights == null || !rights.includes('delete'))
                    }
                    rowKey={this.props.value?.rowKey ? this.props.value.rowKey : 'row_id'}
                    data={data}
                    isHiddenPage={this.props.isHiddenPage != null ? this.props.isHiddenPage : false}
                    columns={this.columns}
                    scroll={{ x: AllWidth }}
                    selectedRows={selectedRows}
                    onSelectRow={this.handleSelectRows}
                    onChange={this.handleStandardTableChange}
                    loading={loading}
                    getCheckboxProps={this.props.getCheckboxProps || undefined}
                  />
                )}
              </div>
            ) : (
              <div
                id="mobelDiv"
                style={{
                  overflow: 'hidden',
                  width: isMobile ? showMobileDiv : showDiv,
                  height: '100%',
                }}
                data-tag={'/libs/formList/index.js-1463'}
              >
                <div>
                  {get === 'mobile' ? <div>手机端,请使用浏览器将手机横屏查看</div> : null}
                  {showDiv && (
                    <StandardTable
                      showHeader={this.props.showHeader != null ? this.props.showHeader : true}
                      noSelectRow={
                        this.props.onSelectRow == null &&
                        (rights == null || !rights.includes('delete'))
                      }
                      rowKey={this.props.value?.rowKey ? this.props.value.rowKey : 'row_id'}
                      data={data}
                      columns={this.columns}
                      scroll={this.props.value && this.props.value.columns ? {} : { x: AllWidth }}
                      selectedRows={selectedRows}
                      isHiddenPage={
                        this.props.isHiddenPage != null ? this.props.isHiddenPage : false
                      }
                      onSelectRow={this.handleSelectRows}
                      onChange={this.handleStandardTableChange}
                      loading={loading}
                      getCheckboxProps={this.props.getCheckboxProps || undefined}
                    />
                  )}
                </div>
              </div>
            )}
          </div>
        </Card>
        <CreateForm {...parentMethods} modalVisible={modalVisible}/>
      </>
    );
    if (isFormCom) {
      return xxxx;
    }
    return <PageHeaderWrapper title="">{xxxx}</PageHeaderWrapper>;
  }
}

export default FormList;
