/**
 * @param key 配置文件中 key
 * @author yyq
 * @version 0.0.1
 * @return 配置信息
 * @description
 * 当未传入key时返回config对象
 * 当key存在是且存在对应key值时返回key值 否则返回config对象
 * */
const queryConfig = (key) => {
	const dynamicConfig = typeof globalThis !== 'undefined' ? globalThis.CONFIG : window.CONFIG;
	if (typeof key === 'undefined') return dynamicConfig;
	return typeof dynamicConfig[key] === 'undefined' ? dynamicConfig : dynamicConfig[key];
};

/**
 * @description 获取系统编码
 * */
export const querySysCode = () => queryConfig('SYSCODE');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryOauthActionPath = () => queryConfig('OAUTH_ACTION_PATH');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryPermActionPath = () => queryConfig('PERM_ACTION_PATH');
export const queryWsPath = () => queryConfig('WS_PATH');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryApiActionPath = () => queryConfig('API_ACTION_PATH');

/**
 * @description 获取文件上传地址
 * */
export const queryFileUploadActionPath = () => queryConfig('FILE_UPLOAD_ACTION_PATH');

/**
 * @description 获取layout头部logo名称
 * */
export const queryLayoutHeaderLogo = () => queryConfig('LAYOUT_HEADER_LOGO');

/**
 * @description 获取登录页面头部logo名称
 * */
export const queryLoginHeaderLogo = () => queryConfig('LOGIN_HEADER_LOGO');

/**
 * @description 获取系统名称
 * */
export const querySystemName = () => queryConfig('SYSTEM_NAME');

/**
 * @description 获取layout头部系统欢迎语
 * */
export const queryLayoutHeaderSystemWelcome = () => queryConfig('LAYOUT_HEADER_SYSTEM_WELCOME');

/**
 * @description 获取layout类型
 * */
export const queryLayoutType = () => queryConfig('LAYOUT_TYPE');

/**
 * @description 获取layout头部中间背景图片
 * */
export const queryLayoutHeaderCenterBackground = () =>
	queryConfig('LAYOUT_HEADER_CENTER_BACKGROUND');

/**
 * @description 获取layout菜单底部背景图片
 * */
export const queryLayoutSiderFooterBackground = () => queryConfig('LAYOUT_SIDER_FOOTER_BACKGROUND');

/**
 * @description 获取登录页面登录框旁背景图片
 * */
export const queryLoginBackground = () => queryConfig('LOGIN_BACKGROUND');

/**
 * @description 获取动态图片前缀
 * */
export const queryDynamicImagePrefix = () => `${window.publicPath}images/dynamic/`;

/**
 * @description 获取配置项路由是否需要权限控制
 * */
export const queryCheckPath = () => queryConfig('CHECK_PATH');

/**
 * @description 获取配置项路由是否需要权限控制
 * */
export const queryLoginRedirect = () => queryConfig('LOGIN_REDIRECT');

export default queryConfig;
