/**
 * 徐立
 * 滚动图标选择
 */
import React, { Component } from 'react';
import BasicsCard from './Basics';
import { formulaList } from '../excelInitFuc/functionList';

export default class rollTab extends Component {
	constructor(props) {
		super(props);
		this.state = {
			tabList: [],
			name: '', // 转存名字
		};
	}
	componentDidMount() {
		this.setState(
			{
				tabList: formulaList,
			},
			() => {
				this.setCloseAll();
			},
		);
		this.props.setPagesTotal(formulaList.length);
	}
	// 修改选中样式
	setCheckedList = (name) => {
		const { tabList } = this.state;
		if (name == this.state.name) {
			let ary = tabList.map((item) => {
				item.isPitch = false;
				item.isShowList = false;
				return item;
			});
			this.setState({
				tabList: ary,
				name: '',
			});
			return;
		}
		let ary = tabList.map((item) => {
			if (item.name == name) {
				item.isPitch = true;
				item.isShowList = true;
				return item;
			}
			item.isPitch = false;
			item.isShowList = false;
			return item;
		});
		this.setState({
			tabList: ary,
			name,
		});
	};
	// 选中函数后关闭全部
	setCloseAll = () => {
		const { tabList } = this.state;
		let ary = tabList.map((item) => {
			item.isPitch = false;
			item.isShowList = false;
			return item;
		});
		this.setState({
			tabList: ary,
			name: '',
		});
		return;
	};
	render() {
		const {
			setPitchOn, // 打开所有函数选择框
			setFunction, // 设置函数相关
			pages, // 页码
		} = this.props;
		const { tabList } = this.state;
		let pageMax = Math.ceil(tabList.lebgth / 14);
		return tabList.map((item, i) => {
			if (
				i >= (pages == 1 ? 1 : (pages - 1) * 13) - 1 &&
				i < (pages == pageMax ? pageMax * 13 : pages == 1 ? pages * 14 : pages * 13)
			) {
				return (
					<BasicsCard
						key={i}
						setCloseAll={this.setCloseAll}
						setCheckedList={this.setCheckedList}
						item={item}
						setFunction={setFunction}
						setPitchOn={setPitchOn}
					/>
				);
			}
			return null;
		});
	}
}
