/**
 * 徐立
 * 2019年9月2日
 * 用于封装轻提示
 */
import { Toast } from 'antd-mobile';
/**
 *
 * Toast.success(content, duration, onClose, mask)
 * content	提示内容
 * duration	自动关闭的延时，单位秒
 * onClose	关闭后回调
 * mask	是否显示透明蒙层，防止触摸穿透
 */
/**
 * 不带icon图标提示
 */
export function showToast(value, time = 1, fn = () => {}, mask = true) {
	Toast.info(value, time, fn, mask);
}
/**
 * 不带蒙尘提示
 */
export function showToastNoMask(value, time = 1, fn = () => {}, mask = false) {
	Toast.info(value, time, fn, mask);
}
/**
 * 成功提示
 */
export function successToast(value, time = 1, fn = () => {}, mask = true) {
	Toast.success(value, time, fn, mask);
}
/***
 * 失败提示
 */
export function failToast(value, time = 1, fn = () => {}, mask = true) {
	Toast.fail(value, time, fn, mask);
}
/***
 * 错误提示
 */
export function offline(value, time = 1, fn = () => {}, mask = true) {
	Toast.offline(value, time, fn, mask);
}
/***
 * 带进度提示信息的提示
 *  duration = 0 时，onClose 无效，toast 不会消失；隐藏 toast 需要手动调用 hide
 * Toast.hide()
 */
export function loadingToast(value, time = 1, fn = () => {}, mask = true) {
	Toast.loading(value, time, fn, mask);
}
