import { apiRequest } from '../utils/request';
const api = '/DataObjApi';
export default {
	namespace: 'DataObj',

	state: {
		list: [],
		data: {
			list: [],
			pagination: {},
		},
		code: {
			list: [],
			pagination: {},
		},
	},

	effects: {
		*importAnalyse({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/importAnalyse', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*importDataQuery({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/importDataQuery', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},

    *importProcess({ payload, callback }, { call, put }) {
      const response = yield call(apiRequest, api + '/importProcess', payload);
      if (!response) {
        yield put({ type: 'nom' });
        return;
      }
      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
		*importExecute({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/importExecute', {
				...payload,
				customErrMsg:
					'导入的文件中可能存在字段不一致、字段类型不匹配、唯一性字段冲突,请检查或联系系统管理员', // 自定义errMsg
			});
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getAll({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getAll', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) callback(response);
		},
		*getStatistics({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getStatistics', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getExportInfo({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getExportInfo', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*changeCatalogue({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/changeCatalogue', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*findByCode({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/findByCode', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*findByName({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/findByName', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*find({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/find', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*add({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/add', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*fetch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getPage', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'page',
				payload: { ...response, isMain: payload.isMain },
			});
		},
		*getTableList({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getTableList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*createTableByName({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/createTableByName', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*remove({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/remove', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
		*open({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/open', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
		*createTabel({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/createTable', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
	},

	reducers: {
		list(state, action) {
			return {
				...state,
				list: action.payload,
			};
		},
		page(state, { payload }) {
			if (payload.isMain) {
				return {
					...state,
					data: {
						list: payload.rows,
						pagination: {
							current: payload.pageNo,
							pageSize: payload.pageSize,
							total: payload.total,
						},
					},
				};
			} else {
				return {
					...state,
					code: {
						list: payload.rows,
						pagination: {
							current: payload.pageNo,
							pageSize: payload.pageSize,
							total: payload.total,
						},
					},
				};
			}
		},
		nom(state, action) {
			return { ...state };
		},
	},
};
