import { apiRequest } from '../utils/request';

const api = '/DataRightApi';

export default {
	namespace: 'DataRight',

	state: {
		list: [],
	},

	effects: {
		*clear({ payload, callback }, { call, put }) {
			yield put({
				type: 'list',
				payload: [],
			});
			if (callback) callback();
		},
		*add({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/add', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*addBatch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/addBatch', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getUserRight({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getUserRight', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*getUserColumnRight({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getUserColumnRight', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}

			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) callback(response);
		},
		*fetch({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/getList', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'list',
				payload: { list: response, isReference: payload.isReference },
			});
			if (callback) callback(response);
		},
		*remove({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/remove', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},

		*open({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/open', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},

		*addReference({ payload, callback }, { call, put }) {
			const response = yield call(apiRequest, api + '/addReference', payload);
			if (!response) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'nom',
				payload: response,
			});
			if (callback) {
				callback();
			}
		},
	},

	reducers: {
		list(state, action) {
			if (action.payload.isReference) {
				return {
					...state,

					refs: action.payload.list,
				};
			} else {
				return {
					...state,
					list: action.payload.list,
				};
			}
		},
		page(state, { payload }) {
			return {
				...state,
				data: {
					list: payload.rows,
					pagination: {
						current: payload.pageNo,
						pageSize: payload.pageSize,
						total: payload.total,
					},
				},
			};
		},
		nom(state, action) {
			return { ...state };
		},
	},
};
