import { uaaRequest } from '../utils/request';

const api = '/ActCommentApi';
const myCollect = {
  namespace: 'trunTo',
  state: {
    user: {}, // 用户数据
  },

  effects: {
    /**
     * 转办流程
     * @param { string|Array } taskIds 需要转交流程ID
     * @param { string } turnsUserCode  移交人账号
     * @param { string } reason 转交理由
     */
    * turnsProcess({
                     payload,
                     callback,
                   }, {
                     call,
                     put,
                   }) {
      const response = yield call(uaaRequest, `${api}/turnsProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 撤回移交流程
     * @param { string|Array } taskIds 需要转交流程ID
     */
    * resetProcess({
                     payload,
                     callback,
                   }, {
                     call,
                     put,
                   }) {
      const response = yield call(uaaRequest, `${api}/resetProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 回退移交流程
     * @param { string|Array } taskIds 需要转交流程ID
     * @param { string } reason 转交理由
     */
    * refuseProcess({
                      payload,
                      callback,
                    }, {
                      call,
                      put,
                    }) {
      const response = yield call(uaaRequest, `${api}/refuseProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
    /**
     * 查询单个转交流程数据
     * @param { string|Array } taskId 需要转交流程ID
     */
    * detailProcess({
                      payload,
                      callback,
                    }, {
                      call,
                      put,
                    }) {
      const response = yield call(uaaRequest, `${api}/getList`, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
  },
  reducers: {
    nom(state) {
      return { ...state };
    },
  },
};
export default myCollect;
