/**
 * 徐立
 * 2019年9月20日
 * 事务相关接口
 */
import { uaaRequest } from '../utils/request';
import prepareShow from "@/webPublic/one_stop_public/Table/prepareShow";
import {deepCopy} from "@/webPublic/one_stop_public/utils/myutils";
import { getHistoryFormDetail } from '@/webPublic/Services';

const api = '/UnifiedAppFormApi';
const myCollect = {
	namespace: 'affair',
	state: {
		user: {}, // 用户数据
		todoListApps: [],
    todoListMessage: [],
    goBackInfo: {},
    pageInfo: {
		  totalPage: 1,
      total: 0,
    },
    waitPageParams: {

    },
	},
	effects: {
		/**
		 * 获取待办分页
		 * @param {pageSize} 每页大小
		 * @param {appId} 应用id
		 * @param {pageNo} 页码
		 */
		*getBacklog({ payload, callback }, { call, put }) {
		  yield put({
			type: 'saveWaitPageParams',
			payload: payload,
		});
			const response = yield call(uaaRequest, `${api}/getWaitPage`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			} else {
				const appIds = new Set();
				response?.rows?.map((x) => {
					appIds.add(x.appId);
					return null;
				});
				yield put({
					type: 'todoList',
					payload: {
						todoListApps: Array.from(appIds),
					},
				});
        yield put({
          type: 'todoInfo',
          payload: {
            todoListMessage: response,
          },
        });
        yield put({
          type: 'savePageInfo',
          payload: {
            totalPage: Number(response.totalPage),
            total: Number(response.total),
          },
        });
			}
			if (callback && typeof callback === 'function') {
				callback(response);
			}
		},
		/**
		 * 获取已办分页
		 * @param {pageSize} 每页大小
		 * @param {appId} 应用id
		 * @param {pageNo} 页码
		 */
		*getHaveDone({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getHandledPage`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
      yield put({
        type: 'savePageInfo',
        payload: {
          totalPage: Number(response.totalPage),
          total: Number(response.total),
        },
      });
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取草稿分页
		 * @param {pageSize} 每页大小
		 * @param {appId} 应用id
		 * @param {pageNo} 页码
		 */
		*getDraft({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getDraftPage`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
      yield put({
        type: 'savePageInfo',
        payload: {
          totalPage: Number(response.totalPage),
          total: Number(response.total),
        },
      });
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取申请分页
		 * @param {pageSize} 每页大小
		 * @param {appId} 应用id
		 * @param {pageNo} 页码
		 */
		*getApply({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getApplyPage`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
      yield put({
        type: 'savePageInfo',
        payload: {
          totalPage: Number(response.totalPage),
          total: Number(response.total),
        },
      });
			if (callback) {
				callback(response);
			}
		},
		*getData({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getData`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 审批流程
		 * @param {taskId} 任务id
		 * @param {examineMap} 审核内容
		 */
		*getExamineProcess({ payload, callback }, { call, put }) {
			let response = yield call(uaaRequest, `${api}/examineProcess`, {
				...payload,
			});

			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 根据id获得表单详情
		 * @param {id} 表单id
		 */
		*getIdFormDetail({ payload, callback }, { call, put }) {
			const response = yield call(getHistoryFormDetail, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}

      yield call(prepareShow, deepCopy(response)); // prepareShow( // 执行templateWillMount公式
			if (callback) {
				callback(window.smartFormGlobalProps.data);
			}
		},

    //26708 学生事务/请假管理/请假申请，202002050943 辅导员在手机端填写的审批原因 在这个表中没有体现出来
    *getIdFormDetailNoNeedShowForm({ payload, callback }, { call, put }) {
      const response = yield call(getHistoryFormDetail, {
        ...payload,
      });
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }
      if (callback) {
        callback(response);
      }
    },
		/**
		 * 删除草稿
		 * @param {ids } 表单ids
		 */
		*removeDraft({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/removeDraft`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 撤销流程
		 * @param {id} 表单id
		 */
		*revokeProcess({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/revokeProcess`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 保存或修改草稿
		 * @param {appId} 应用id
		 * @param {id} 表单id
		 * @param {content} 表单内容
		 * @param {title} 表单标题
		 */
		*saveDraft({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/saveDraft`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 发起流程
		 * @param {appId} 应用id
		 * @param {id} 表单id
		 * @param {content} 表单内容
		 * @param {title} 表单标题
		 */
		*startProcess({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/startProcess`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
      // TODO 需要判断发起是否成功.失败的话需要返回false; 2024年9月23日 钟是志
			if (callback) {
				callback(response);
			}
		},
		*startProcessByService({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/startProcessByService`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		*getHandleUser({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getHandleUser`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取应用列表字段信息
		 * @param {id} 表单id
		 */
		*getFormTitle({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getFormTitle`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取数据字段
		 * @param payload
		 * @param callback
		 * @param call
		 * @param put
		 * @returns {IterableIterator<*>}
		 */
		*getDataTitle({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, `${api}/getDataTitle`, {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
	},
	reducers: {
		nom(state, action) {
			return { ...state };
		},
    todoInfo(state, { payload } ) {
		  return {
		    ...state,
        todoListMessage: payload.todoListMessage,
      }
    },
		todoList(state, { payload }) {
			return {
				...state,
				todoListApps: payload.todoListApps,
			};
		},
    saveGoBack(state, { payload }) {
      return {
        ...state,
        goBackInfo: payload,
      };
    },
    savePageInfo(state, { payload }) {
      return {
        ...state,
        pageInfo: payload,
      };
    },
    saveWaitPageParams(state, { payload } ) {
      return {
        ...state,
        waitPageParams: payload,
      }
    },
	},
};
export default myCollect;
