/**
 * 徐立
 * 2019年9月20日
 * 主页接口
 */
import { uaaRequest } from '../utils/request';
import prepareShow from "@/webPublic/one_stop_public/Table/prepareShow";
import { queryApiVersion } from '@/webPublic/one_stop_public/utils/queryConfig';

const myCollect = {
	namespace: 'modileHome',
	state: {
		home: {},
		affair: {},
	},
	effects: {
		// 为主页我的服务的数据请求函数
		*getMyHome({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedAppApi/getCurrentList', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'initHome',
				payload: response,
			});
			if (callback) {
				callback(response);
			}
		},
		// 为主页所有服务的数据请求函数
		*getHome({ payload, callback }, { call, put }) {
			let response = yield call(uaaRequest, '/UnifiedThemeApi/getList', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if(queryApiVersion() === '2.0' && response.info){
			  response = response.info;
      }
			yield put({
				type: 'initHome',
				payload: response,
			});
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 添加当前事务到我的服务
		 * @param {ids} 服务ids
		 */
		*addMyHome({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedAppApi/addApp', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'initHome',
				payload: response,
			});
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 移除当前用户我的服务
		 * @param {ids} 服务ids
		 */
		*removeMyHome({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedAppApi/removeApp', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			yield put({
				type: 'initHome',
				payload: response,
			});
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 根据id查询应用详情指南
		 * @param {id} 服务ids
		 */
		*getDetail({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedAppApi/getDetail', {
				...payload,
			});
			yield put({
				type: 'initAffair',
				payload: response,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
      yield call(prepareShow, response, {}, {
        fromStart: true,
      }); // prepareShow( // 执行templateWillMount公式

      if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取系统指南
		 * @param {configKey} 系统指南 homeHelp
		 */
		*getConfigDetail({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/ConfigApi/getDetail', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		/**
		 * 获取我的收藏系统分页
		 * @param {pageNo} 页码
		 * @param {pageSize} 每页数量
		 */
		*getPagesCollect({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedAppApi/getCurrentPage', {
				...payload,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
		*getCodeDetail({ payload, callback }, { call, put }) {
			const response = yield call(uaaRequest, '/UnifiedServicePatternApi/getDetail', {
				...payload,
			});
			yield put({
				type: 'initAffair',
				payload: response,
			});
			if (response == null) {
				yield put({ type: 'nom' });
				return;
			}
			if (callback) {
				callback(response);
			}
		},
	},
	reducers: {
		initHome(state, action) {
			return { ...state, home: action.payload };
		},
		initAffair(state, action) {
			return { ...state, affair: action.payload };
		},
		nom(state, action) {
			return { ...state };
		},
	},
};
export default myCollect;
