/**
 * 徐立
 * 2019年11月27日
 * 个人申请新增按钮接口
 */
import { uaaRequest } from '../utils/request';

const api: string = "/UnifiedAppFormApi"

const myCollect = {
  namespace: 'urge',
  state: {
    user: {}, // 用户数据
    deaImg: '', // 全局背景图
  },
  effects: {
    /**
     * 催促办理请求
     * @param {需要催办的数组id} taskIds
     */
    * GetUrge({payload, callback}: { payload: any, callback: any },
              {call, put}: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/urgeProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({type: 'nom'});
        return
      }
      if (callback) {
        callback(response)
      }
    },
    /**
     * 撤回已发起流程
     * @param {撤回函数} taskIds
     */
    * GetRecall({payload, callback}: { payload: any, callback: any },
                {call, put}: { call: any, put: any }) {
      const response = yield call(uaaRequest, `${api}/regressionProcess`, {
        ...payload,
      });
      if (response == null) {
        yield put({type: 'nom'});
        return
      }
      if (callback) {
        callback(response)
      }
    },
    /**
     * 获取用户权限
     */
    * GetMyPath({payload, callback}: { payload: any, callback: any },
                {call, put}: { call: any, put: any }) {
      const response = yield call(uaaRequest, `/UserApi/myPath`, {
        ...payload,
      });
      if (response == null) {
        yield put({type: 'nom'});
        return
      }
      if (callback) {
        callback(response)
      }
    },
    /**
     * 紧急度动态按钮请求
     */
    * GetMyBtn({payload, callback}: { payload: any, callback: any },
               {call, put}: { call: any, put: any }) {
      const response = yield call(uaaRequest, `/UnifiedAppFormLevelApi/getAll`, {
        ...payload,
      });
      if (response == null) {
        yield put({type: 'nom'});
        return
      }
      if (callback) {
        callback(response)
      }
    },
  },
  reducers: {
    setImg(state: any, action: any) {
      return {
        ...state,
        deaImg: action.payload,
      };
    },
    nom(state: any, action: any) {
      return {...state};
    },
  },
};
export default myCollect;
