// import config from '@/webPublic/one_stop_public/config';
import { apiRequest } from '../utils/request';

const api = '/UserSetCenterApi';
const Search = {
  namespace: 'UserSetCenterApi',
  state: {
    result: [], // 初始请求，默认条件为全选
    options: {}, // 初始化请求条件
  },
  effects: {
    // 新增或则修改1
    *addOrUpdate({ payload, callback }, { call, put }) {
      const response = yield call(apiRequest, `${api}/addOrUpdate`, payload);
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
    // 查询
    *queryUserSet({ payload, callback }, { call, put }) {
      const response = yield call(apiRequest, `${api}/queryUserSet`, payload);
      if (response == null) {
        yield put({ type: 'nom' });
        return;
      }

      yield put({
        type: 'nom',
        payload: response,
      });
      if (callback) callback(response);
    },
  },
  reducers: {
    nom(state, action) {
      return { ...state };
    },
  },
};
export default Search;
