import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';

export const getOneStopSystemConfig = (params) => {
	return uaaRequest('/ConfigApi/getDetails', params);
};

export function getOneStopConfigList() {
	// 获取一站式系统配置项
	// 对应一站式 泸职 pages/Portal/Layouts/Headers 的代码   type: 'emailorphone/GetLogo',
	return getOneStopSystemConfig({
		configKeys: [
			'webHomeLogin',
			'isCloseFlowPath',
			'HandleAffairsHall',
			'ServiceCenter',
			'PersonalCenter',
			'NewHome',
			'ssoUrl',
			'isSSOLogin',
			'webMobileAdress',
			'isCloseMessage',
			'isCloseStatistics',
			'isSkipHomeModel',
			'IsUpBacImg',
			'domainName',
			'isCloseHeadPortrait',
			'isOpenMessageStatus',
			'ssoLogoutUrl',
			'isShare',
			'isGuide',
			'isDiscoverAffair',
			'isNewsCollect',
		],
	}).then((val) => {
		if (!val) {
			return false;
		}
		sessionStorage.setItem(
			'sso',
			JSON.stringify({
				ssoUrl: val[6].configValue,
				ssoLogin: val[7].configValue,
				ssoLogoutUrl: val[16].configValue,
			}),
		);
		localStorage.setItem(
			'isCloseStatistics',
			val[10]?.configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
		);
		if (val[1]?.configValue) {
			sessionStorage.setItem(
				'isCloseFlowPath',
				val[1]?.configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[11]?.configValue) {
			sessionStorage.setItem(
				'isSkipHomeModel',
				val[11]?.configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[13] && val[13].configValue) {
			sessionStorage.setItem('domainName', val[13] && val[13].configValue);
		}
		if (val[14] && val[14].configValue) {
			sessionStorage.setItem(
				'isCloseHeadPortrait',
				val[14] && val[14].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[15] && val[15].configValue) {
			sessionStorage.setItem(
				'isOpenMessageStatus',
				val[15] && val[15].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[17] && val[17].configValue) {
			sessionStorage.setItem(
				'isShare',
				val[17] && val[17].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[18] && val[18].configValue) {
			sessionStorage.setItem(
				'isGuide',
				val[18] && val[18].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[19] && val[19].configValue) {
			sessionStorage.setItem(
				'isDiscoverAffair',
				val[19] && val[19].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		if (val[20] && val[20].configValue) {
			sessionStorage.setItem(
				'isNewsCollect',
				val[20] && val[20].configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
			);
		}
		return true;
	});
}
